/*
 *  Author:       Serg Stoyan
 *
 *  Classes:      AppIcon : NSObject
 *
 *  Description:  Application's icon window. Used to draw PPP load graphics
 *                and showing status of connection.
 */

#import "AppIcon.h"

#import <Foundation/NSTimer.h>

#import <AppKit/NSApplication.h>
#import <AppKit/NSEvent.h>
#import <AppKit/NSImage.h>
#import <AppKit/NSCell.h>
#import <AppKit/PSOperators.h>

#include <net/ppp_defs.h>
#include <net/if_ppp.h>

char *active_interface = "ppp0";
int  ppp_h = -1;
int  x = 45;
int  y = 58;
long packets_in = 0; 
long packets_out = 0;
long bytes_in = 0;
long bytes_out = 0;

long old_packets_in = 0; 
long old_packets_out = 0;
long old_bytes_in = 0;
long old_bytes_out = 0;

void
get_ppp_stats (struct ppp_stats *cur)
{
  struct ifpppstatsreq req;

  memset (&req, 0, sizeof(req));

  req.stats_ptr = (caddr_t)&req.stats;

  strcpy (req.ifr__name, active_interface);

  if (ioctl (ppp_h, SIOCGPPPSTATS, &req) >= 0)
  {
    *cur = req.stats;
  }
}

int
get_statistics (char *devname, long *ip, long *op, long *is, long *os)
{
  struct ppp_stats ppp_cur;
  static int       ppp_opened = 0;
  
  
  if (!ppp_opened)
  {
    /* Open the ppp device. */
    memset(&ppp_cur, 0, sizeof (ppp_cur));
    if ((ppp_h = socket (AF_INET, SOCK_DGRAM, 0)) < 0)
    {
      return -1;
    }
    ppp_opened = 1;
  }
        
  get_ppp_stats (&ppp_cur);
  
  *op = ppp_cur.p.ppp_opackets;
  *ip = ppp_cur.p.ppp_ipackets;
  
  *is = ppp_cur.p.ppp_ibytes;
  *os = ppp_cur.p.ppp_obytes;

  return 0;
}

@implementation AppIcon

- init
{
  if (!(self = [super initWithFrame: NSMakeRect (0, 0, 64, 64)]))
    return nil;

  NSLog (@"AppIcon init");

  tileImage = [NSImage imageNamed: @"common_Tile"];
  onImage = [NSImage imageNamed: @"PPP-on"];
  offImage = [NSImage imageNamed: @"PPP-off"];
  maskImage = [NSImage imageNamed: @"Mask"];

  dragCell = [[NSCell alloc] initImageCell: offImage];
  [dragCell setBordered: NO];
  tileCell = [[NSCell alloc] initImageCell: tileImage];
  [tileCell setBordered: NO];

  [self setMode: PPPOffMode];

  return self;
}

- (void) dealloc
{
  NSLog (@"AppIcon dealloc");

  RELEASE (tileImage);
  RELEASE (onImage);
  RELEASE (offImage);
  RELEASE (maskImage);
}

- (BOOL) isOpaque
{
  return YES;
}

- (void) drawRect: (NSRect)rect
{
  [tileCell drawWithFrame: NSMakeRect (0,0,64,64) inView: self];
  [dragCell drawWithFrame: NSMakeRect (8,8,48,48) inView: self];

/*  if (x >= 5)
  {
    PSsetlinewidth(1);
    PSsetrgbcolor(0.0, 0.6, 0.0);
    
    PSmoveto (x, 6);
    PSlineto (x, y);
    PSstroke ();
  }

  NSLog (@"AppIcon drawRect");*/
}

- (BOOL) acceptsFirstMouse: (NSEvent *)e
{
  return YES;
}

- (void) mouseDown: (NSEvent *)theEvent
{
  if ([theEvent clickCount] >= 2 && ![NSApp isActive])
    [NSApp unhide: self];
}

- (void) setMode: (int)mode
{
  switch (mode)
  {
    case PPPOffMode:
      [dragCell setImage: offImage];
      if (drawStatsTimer != nil)
      {
        [drawStatsTimer invalidate];
        drawStatsTimer = nil;
      }
      break;
      
    case PPPOnMode:
      [dragCell setImage: onImage];
      break;

    case PPPStatsMode:
      [dragCell setImage: maskImage];
      // Create timer for drawing stats
      drawStatsTimer = [NSTimer scheduledTimerWithTimeInterval: 1.0
        target: self selector: @selector (drawStats) userInfo: nil
        repeats: YES];
      break;

    default:
      NSLog (@"AppIcon setMode: invalid mode(%i) requested", mode);
      break;
  }

  if (mode >= PPPOffMode && mode <= PPPStatsMode)
  {
    currentMode = mode;
  }

  [self display];
}

- (void) drawStats
{
  long pi = 0;
  long po = 0;
  long bi = 0;
  long bo = 0;
  NSGraphicsContext *ctxt = GSCurrentContext();

/*  PScompositerect(rect.origin.x, rect.origin.y, 
                  rect.size.width, rect.size.height,
                  NSCompositeClear);*/

/*  get_statistics (active_interface, 
      &packets_in, &packets_out, &bytes_in, &bytes_out);
  
  NSLog (@"drawStats: pi = %i, po = %i, bi = %i, bo = %i", 
      packets_in - old_packets_in, packets_out - old_packets_out,
      bytes_in - old_bytes_in, bytes_out - old_bytes_out);*/

  old_packets_in = packets_in;
  old_packets_out = packets_out;
  old_bytes_in = bytes_in;
  old_bytes_out = bytes_out;

  [self setNeedsDisplay: YES];
  x--;
}

@end

