use Language::INTERCAL;
use Language::INTERCAL::Runtime::Library;

my $prog = '
	@K@L`@{
M]	@@@M]@@@
	@K@L`@\
M]	@@@K
M]	@@@M]
	@K@L`@\
	@@@K
	@@@M]
	@@
';

print "1..12\n";

fiddle Language::INTERCAL 'bug=0', 'ubug=0';

my @foo;

compile Language::INTERCAL 'prog', $prog;
@foo= ();
eval { prog(0, \&foo) };
print STDERR $@ if $@ !~ /456 NO SPLAT/;
print $@ !~ /456 NO SPLAT/ ? "not " : "", "ok 1\n";
print @foo == 1 ? "" : "not ", "ok 2\n";
print "CDLVI\n" eq (shift @foo) ? "" : "not ", "ok 3\n";

compile Language::INTERCAL 'prog_o', $prog, 'opt';
@foo= ();
eval { prog_o(0, \&foo) };
print STDERR $@ if $@ !~ /456 NO SPLAT/;
print $@ !~ /456 NO SPLAT/ ? "not " : "", "ok 4\n";
print @foo == 1 ? "" : "not ", "ok 5\n";
print "CDLVI\n" eq (shift @foo) ? "" : "not ", "ok 6\n";

compile Language::INTERCAL 'prog_p', $prog, 'post';
@foo= ();
eval { prog_p(0, \&foo) };
print STDERR $@ if $@ !~ /456 NO SPLAT/;
print $@ !~ /456 NO SPLAT/ ? "not " : "", "ok 7\n";
print @foo == 1 ? "" : "not ", "ok 8\n";
print "CDLVI\n" eq (shift @foo) ? "" : "not ", "ok 9\n";

compile Language::INTERCAL 'prog_d', $prog, 'dbhook';
@foo= ();
_run_db(prog_d(0, \&foo));
print STDERR $@ if $@ !~ /456 NO SPLAT/;
print $@ !~ /456 NO SPLAT/ ? "not " : "", "ok 10\n";
print @foo == 1 ? "" : "not ", "ok 11\n";
print "CDLVI\n" eq (shift @foo) ? "" : "not ", "ok 12\n";

sub foo {
    push @foo, join('', @_);
}

