;;; -*- Syntax: Ansi-Common-Lisp; Base: 10; Mode: lisp; Package: odcl -*-
;;; $Id: interfaces.lisp,v 1.6 2003/03/24 21:51:31 adam Exp $
;;;
;;; Copyright (c) 2002 - 2003 onShore Development, Inc.

(in-package :odcl)

;; generic collection

(eval-when (:compile-toplevel :load-toplevel)

(defgeneric c-add (collection item)
  (:documentation "add an item to a collection"))

(defgeneric c-remove (collection item)
  (:documentation "remove an item from a collection"))

(defgeneric c-copy (collection)
  (:documentation "copy a collection"))

;; sorted set

(defgeneric c-test (set)
  (:documentation "return the test used to order a set"))

(defgeneric c-subseq (set first &optional end)
  (:documentation "same semantics as subseq"))

;; propertied object

(defgeneric get-property (object property-name)
  (:documentation
   "Returns the specified value of the given object.  it provides a
unified interface to slots and metadata properties, as well as
computed value."))

(defgeneric get-property-n (object property-name property-args)
  (:documentation
   "Returns the specified value of the given object.  it provides a
unified interface to slots and metadata properties, as well as
computed value. For properties conditioned by additional arguments."))

)
