(in-package :cl-user)

;; very simple GL test
(defun test-gl ()
  (gl:glutCreateWindow "dummy")
  (list (gl:glGetString gl:GL_VENDOR)
	(gl:glGetString gl:GL_RENDERER)
	(gl:glGetString gl:GL_VERSION)))

;; GLUT test
(defun draw ()
  (format t "In DRAW~%"))

(defun keypress (key x y)
  (format t "In KEYPRESS~%key ~A,  x ~A,  y ~A~%" (code-char key) x y)
  (case (char-downcase (code-char key))
    ((#\q #\Escape)
     ;; jump out of glutMainLoop
     (throw :exit-glut nil))
    (#\g
     ;; Will the callbacks survive a GC?
     (write-line "garbage collecting...")
     (gc :full t)
     (write-line "GC done."))))

(defun test-glut ()
  (gl:glutInitWindowSize 300 300)
  (let ((window (gl:glutCreateWindow "dummy")))
    (gl:glutDisplayFunc #'draw)
    (gl:glutKeyboardFunc #'keypress)
    (unwind-protect
	 (catch :exit-glut
	   (gl:glutMainLoop))
      (gl:glutDestroyWindow window))))

;; Xlib test
(defun test-xlib ()
  (let* ((display (XOpenDisplay ""))
	 (screen (XDefaultScreen display))
	 (root (XRootWindow display screen))
	 (window (XCreateWindow display root
				50 50 200 200 0
				CopyFromParent CopyFromParent CopyFromParent
				0 0)))
    (format t "An empty X window should appear for 5 seconds...~%")
    (XMapWindow display window)
    (XFlush display)
    (sleep 5)
    (XDestroyWindow display window)
    (XCloseDisplay display)))

