*
* $Id: name12.s,v 1.1.1.1 1996/04/01 15:03:04 mclareni Exp $
*
* $Log: name12.s,v $
* Revision 1.1.1.1  1996/04/01 15:03:04  mclareni
* Mathlib gen
*
*
#if defined(CERNLIB_IBM)
NAME12   CSECT
#if defined(CERNLIB_QMIBMXA)
NAME12   AMODE ANY
NAME12   RMODE ANY
#endif
*
* CERN PROGLIB# J402    NAME12          .VERSION KERNIBM  X          X
*
*********************************************************************
*
* FUNCTION:     BUILD IN A SPECIFIED OUTPUT AREA ONE LINE OF A
*               STRING OF 12*12 BLOCK CHARACTERS.
*
* CALLING SEQUENCE:     CALL NAME12 (STRING,LINE,OUTPUT,NCHARS)
*
* ARGUMENTS:     STRING - THE STRING OF EBCDIC CHARACTERS TO BE
*                         BLOCKED.
*
*                LINE   - THE LINE NUMBER AS A 4-BYTE INTEGER IN THE
*                         RANGE 1-12.  (TO CONSTRUCT COMPLETE BLOCK
*                         CHARACTERS THE ROUTINE MUST BE ENTERED 12
*                         TIMES).
*
*                OUTPUT - THE AREA IN WHICH A LINE OF THE BLOCK
*                         CHARACTER STRING IS TO BE CONSTRUCTED.
*                         THE ROUTINE SPACES 2 COLUMNS BETWEEN
*                         BLOCK CHARACTERS, THE REQUIRED LENGTH IN
*                         BYTES OF THIS AREA IS THEREFORE 14N-2,
*                         WHERE N REPRESENTS THE NUMBER OF CHARACTERS
*                         IN THE STRING.  THE ROUTINE DOES NOT ENTER
*                         BLANKS BETWEEN OR WITHIN THE BLOCK
*                         CHARACTERS, THE CALLING PROGRAM MUST
*                         THEREFORE PREFILL THIS AREA WITH BLANKS OR
*                         ANY OTHER DESIRED BACKGROUND.
*
*                NCHARS - THE NUMBER OF CHARACTERS IN THE STRING AS
*                         A 4-BYTE INTEGER.
*
*********************************************************************
*
*********************************************************************
*
*                   M O D I F I C A T I O N   L O G
*                   ===============================
*
*********************************************************************
*
*                               2 . 0 1
*                               =======
*
* NAME CHANGED FROM BLK12 TO NAME12
*
* H. RENSHALL, CERN/DD, JANUARY 1982.
*
*********************************************************************
*
*                               2 . 0 0
*                               =======
*
* NEW VERSION.
*
* R. MATTHEWS, CERN/DD, DECEMBER 1980.
*
*********************************************************************
*
R0       EQU   0
R1       EQU   1
R2       EQU   2
R3       EQU   3
R4       EQU   4
R5       EQU   5
R6       EQU   6
R7       EQU   7
R8       EQU   8
R9       EQU   9
R10      EQU   10
R11      EQU   11
R12      EQU   12
R13      EQU   13
R14      EQU   14
R15      EQU   15
*
        PRINT NOGEN
*
*  P R O L O G U E
*
         USING NAME12,R15
         B     SAVEREGS
         DC    AL1(7),CL7'NAME12'    IDENTIFIER
         DC    C'2.01'               VERSION.MODIFICATION LEVEL
SAVEREGS STM   R14,R12,12(R13)
         LR    R4,R13
         CNOP  0,4
         BAL   R13,AROUNDSA
SAVEAREA DC    A(EPILOGUE),17F'0'
         DROP  R15
         USING SAVEAREA,R13
AROUNDSA ST    R13,8(0,R4)
         ST    R4,4(0,R13)
         XC    8(4,R13),8(R13)
*
         LM    R2,R5,0(R1)    R2 -> STRING,  R3 -> LINE
*                             R4 -> OUTPUT,  R5 -> NCHARS
         BCTR  R2,0           R2 -> STRING - 1
         L     R3,0(0,R3)     R3 := LINE
         BCTR  R3,0           R3 := LINE - 1
         L     R5,0(0,R5)     R5 := NCHARS
         LR    R6,R5          R6 := NCHARS
         MH    R6,=H'14'      R6 := 14*NCHARS
         LA    R6,11(0,R6)    R6 := 14*NCHARS + 11
         SR    R7,R7          R7 := 0
         SR    R8,R8          R8 := 0
*
NEXTCHAR SH    R6,=H'14'      STEP BACK 14 BYTES FOR THE NEXT CHARACTE
         IC    R7,0(R5,R2)    R7 := CURRENT CHARACTER
         LR    R9,R7          R9 := CURRENT CHARACTER
         SH    R9,=H'64'      ALLOW FOR TABLE STARTING WITH BLANK CHAR
         BM    BCTCHAR        BRANCH IF THE CHARACTER IS OUT OF RANGE
         MH    R9,=H'12'      R9 := OFFSET IN CHARDEFS FOR CURRENT CHA
         AR    R9,R3          R9 := OFFSET FOR CURRENT LINE OF CHAR
         IC    R8,CHARDEFS(R9)  R8 := CHARDEFS ENTRY
         LH    R9,LINEBITS(R8)  R9 := BIT PATTERN
         SLL   R9,19          SHIFT IT TO BITS 1-12
         O     R9,=F'1'       TURN ON BIT 31
         LA    R8,12          R8 := 12 FOR LOOP CONTROL
         SR    R6,R8          SUBTRACT 12 ADDED BY PREVIOUS LOOP
*
NEXTBYTE LA    R6,1(0,R6)     R6 -> CURRENT OUTPUT BYTE
         BXH   R9,R9,BCTBYTE  TEST THE TOP BIT AND SHIFT THE OTHERS
         STC   R7,0(R6,R4)    STORE THE CHARACTER IF THE BIT WAS ON
BCTBYTE  BCT   R8,NEXTBYTE    GO AND REPEAT FOR THE NEXT OUTPUT BYTE
*
BCTCHAR  BCT   R5,NEXTCHAR    GO AND REPEAT FOR THE NEXT CHAR
*
*  E P I L O G U E
*
EPILOGUE EQU   *
         L     R13,4(0,R13)
         LM    R14,R12,12(R13)
**       MVI   12(R13),X'FF'
         BR    R14
*
*********************************************************************
*
* THE FOLLOWING IS THE CHARACTER DEFINITION TABLE CONTAINING ONE
* TWELVE-BYTE ENTRY FOR EACH CHARACTER.  EACH BYTE IS THE ADDRESS IN
* THE LINEBITS TABLE OF THE BIT PATTERN WHICH DEFINES ONE LINE OF THE
* BLOCK CHARACTER.  FOR EXAMPLE, 'A' IS COMPOSED OF THE LINES
* L2, L1, L5, L5, L5, L1, L1, L5, L5, L5, L5, L5.
*
*********************************************************************
*
CHARDEFS DC    192X'4C4C4C4C4C4C4C4C4C4C4C4C'
         ORG   CHARDEFS
BLANK    DC    X'4C4C4C4C4C4C4C4C4C4C4C4C'
         ORG   CHARDEFS+12*X'0B'
PERIOD   DC    X'4C4C4C4C4C4C4C4C60606060'
LESSTHAN DC    X'120A14721674741672140A12'
OPENBRAC DC    X'061472721616161672721406'
PLUS     DC    X'4C141414140202141414144C'
VERTLINE DC    X'141414141414141414141414'
AMPERSND DC    X'0E989A9A980E9C9EA09200A2'
         ORG   CHARDEFS+12*X'1A'
SHRIEK   DC    X'14141414141414144C4C1414'
CURRENCY DC    X'4C4C4C4C4C4C4C4C4C4C4C4C'     UNDEFINED
ASTERISK DC    X'14888A048C00008C048A8814'
CLOSBRAC DC    X'84140A0A121212120A0A1484'
         ORG   CHARDEFS+12*X'20'
MINUS    DC    X'4C4C4C4C4C02024C4C4C4C4C'
SLASH    DC    X'4C1070120A1472167418264C'
         ORG   CHARDEFS+12*X'2C'
PERCENT  DC    X'4C787A7C0A1472167E80824C'
UNDERSCR DC    X'4C4C4C4C4C4C4C4C4C4C0000'
GREATHAN DC    X'1672140A127070120A147216'
QUESTION DC    X'020008645EA48614144C1414'
         ORG   CHARDEFS+12*X'3B'
HASH     DC    X'202020000020200000202020'
AT       DC    X'020008448E4242A690929496'
         ORG   CHARDEFS+12*X'3E'
EQUALS   DC    X'4C4C4C02024C4C02024C4C4C'
         ORG   CHARDEFS+12*X'81'
A        DC    X'020008080800000808080808'
B        DC    X'2C000808322A2A320808002C'
C        DC    X'020008262626262626080002'
D        DC    X'282A32080808080808322A28'
E        DC    X'000026262668682626260000'
F        DC    X'000026262668682626262626'
G        DC    X'020008262626343408080002'
H        DC    X'080808080800000808080808'
I        DC    X'020214141414141414140202'
         ORG   CHARDEFS+12*X'91'
J        DC    X'66660A0A0A0A0A0A3A3A686A'
K        DC    X'08322E3C3A36363A3C2E3208'
L        DC    X'262626262626262626260000'
M        DC    X'083E40424446080808080808'
N        DC    X'086C6E484A464E5052540876'
O        DC    X'000008080808080808080000'
P        DC    X'2C00080808002C2626262626'
Q        DC    X'020008080808084E50522C56'
R        DC    X'2C00080808002C3A3C2E3208'
         ORG   CHARDEFS+12*X'A2'
S        DC    X'02000826585A5C5E64080002'
T        DC    X'000014141414141414141414'
U        DC    X'080808080808080808080002'
V        DC    X'080808080808083062206014'
W        DC    X'080808080808464442403E08'
X        DC    X'080830622060602062300808'
Y        DC    X'080830622060141414141414'
Z        DC    X'00001070120A147216742400'
         ORG   CHARDEFS+12*X'B0'
ZERO     DC    X'040208080808080808080204'
ONE      DC    X'140C0E141414141414140202'
TWO      DC    X'020008646410121416180000'
THREE    DC    X'02000864641A1A6464080002'
FOUR     DC    X'061C1E202224001212121212'
FIVE     DC    X'0000262626282A106464002C'
SIX      DC    X'02000826262C000808080002'
SEVEN    DC    X'002C2E120A14141414141414'
EIGHT    DC    X'020008083004043008080002'
NINE     DC    X'020008080800006464080002'
         DC    6X'4C4C4C4C4C4C4C4C4C4C4C4C'
         ORG
*
*********************************************************************
*
* THE FOLLOWING IS THE TABLE OF BIT PATTERNS WHICH ARE USED TO
* CONSTRUCT THE BLOCK CHARACTERS.  EACH BLOCK CHARACTER IS COMPOSED
* OF 12 BIT PATTERNS, ONE FOR EACH LINE OF THE CHARACTER, AS DEFINED
* IN THE CHARACTER DEFINITION TABLE.  IF A BIT IS ON THE CHARACTER IS
* PRINTED AND IF THE BIT IS OFF THE PRINTING OF THE CHARACTER IS
* SUPPRESSED.
*
*********************************************************************
*
LINEBITS DS    0H
L1       DC    BL2'111111111111'
L2       DC    BL2'011111111110'
L3       DC    BL2'001111111100'
L4       DC    BL2'000000111000'
L5       DC    BL2'110000000011'
L6       DC    BL2'000000110000'
L7       DC    BL2'000011100000'
L8       DC    BL2'000111100000'
L9       DC    BL2'000000000110'
L10      DC    BL2'000000011000'
L11      DC    BL2'000001100000'
L12      DC    BL2'000110000000'
L13      DC    BL2'011000000000'
L14      DC    BL2'000000011110'
L15      DC    BL2'000001111000'
L16      DC    BL2'000011011000'
L17      DC    BL2'000110011000'
L18      DC    BL2'001100011000'
L19      DC    BL2'011111111111'
L20      DC    BL2'110000000000'
L21      DC    BL2'111111111000'
L22      DC    BL2'111111111100'
L23      DC    BL2'111111111110'
L24      DC    BL2'110000001100'
L25      DC    BL2'011000000110'
L26      DC    BL2'110000000110'
L27      DC    BL2'110000011111'
L28      DC    BL2'111111100000'
L29      DC    BL2'110001100000'
L30      DC    BL2'110000110000'
L31      DC    BL2'110000011000'
L32      DC    BL2'111000000111'
L33      DC    BL2'111100001111'
L34      DC    BL2'110110011011'
L35      DC    BL2'110011110011'
L36      DC    BL2'110001100011'
L37      DC    BL2'110110000011'
L38      DC    BL2'110011000011'
L39      DC    BL2'000000000000'
L40      DC    BL2'110000110011'
L41      DC    BL2'110000011011'
L42      DC    BL2'110000001111'
L43      DC    BL2'110000000111'
L44      DC    BL2'011111111011'
L45      DC    BL2'111000000000'
L46      DC    BL2'011111111100'
L47      DC    BL2'001111111110'
L48      DC    BL2'000000000111'
L49      DC    BL2'000011110000'
L50      DC    BL2'001100001100'
L51      DC    BL2'000000000011'
L52      DC    BL2'001111111111'
L53      DC    BL2'111111110000'
L54      DC    BL2'011111100000'
L55      DC    BL2'111000000011'
L56      DC    BL2'111100000011'
L57      DC    BL2'000000001100'
L58      DC    BL2'000011000000'
L59      DC    BL2'001100000000'
L60      DC    BL2'110000000001'
L61      DC    BL2'001110000110'
L62      DC    BL2'001010001100'
L63      DC    BL2'001110011000'
L64      DC    BL2'001100111000'
L65      DC    BL2'011000101000'
L66      DC    BL2'110000111000'
L67      DC    BL2'000111000000'
L68      DC    BL2'000001111100'
L69      DC    BL2'011001100110'
L70      DC    BL2'011101101110'
L71      DC    BL2'000111111000'
L72      DC    BL2'110111111011'
L73      DC    BL2'110011111111'
L74      DC    BL2'110000001110'
L75      DC    BL2'111111000000'
L76      DC    BL2'011111000000'
L77      DC    BL2'001111110000'
L78      DC    BL2'001100110000'
L79      DC    BL2'001111110011'
L80      DC    BL2'011000111011'
L81      DC    BL2'110000011110'
L82      DC    BL2'011111110011'
L83      DC    BL2'000001111110'
L84      DC    BL2'110011111011'
*
         LTORG
*
         END
#endif
