module T = Custom.Array(Custom.Pair(Types)(Custom.List(Patterns.Node)))

module P = struct
  let pms = ref [] and nb_pms = ref (-1)

  let init () = pms:=[]; nb_pms:=0
  let mk () = 
    let pms = Array.of_list !pms in
    Serialize.Put.run T.serialize pms

  let pm t = pms:=t::!pms; incr nb_pms; !nb_pms
end

module G = struct
  type chunk = T.t
  let mk s = Serialize.Get.run T.deserialize s
  let pm x i = x.(i)
end
