/*
 * Decompiled with CFR 0.152.
 */
package sun.servlet.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUtils;
import sun.servlet.ServletConnection;
import sun.servlet.http.HttpInputStream;
import sun.servlet.http.HttpRequestLine;
import sun.servlet.http.HttpRequestListener;
import sun.servlet.http.HttpResponse;
import sun.servlet.http.HttpSessionImpl;
import sun.servlet.http.InvalidRequestException;
import sun.servlet.http.MessageBytes;
import sun.servlet.http.MessageString;
import sun.servlet.http.MimeHeaders;
import sun.servlet.http.SessionContextImpl;

public class HttpRequest
implements HttpServletRequest,
Cloneable {
    private String scheme = "http";
    private String sessionCookieName = "session";
    protected HttpRequestLine line = new HttpRequestLine();
    protected final MessageString servletPath = new MessageString();
    protected final MessageString pathInfo = new MessageString();
    protected String assignedRequestURI;
    protected boolean isRequestURIAssigned;
    protected MessageBytes requestPath;
    protected final MessageString remoteUser = new MessageString();
    protected final MessageString authType = new MessageString();
    protected MimeHeaders headers = new MimeHeaders();
    protected HttpInputStream in = new HttpInputStream();
    protected ServletConnection con;
    protected int length;
    private boolean keepAlive;
    private String protocolString;
    private MessageBytes protocolBytes;
    private String version;
    private int majorVersion = -1;
    private int minorVersion = -1;
    protected Dictionary params;
    protected HttpSessionImpl session;
    protected String requestedSessionID;
    protected SessionContextImpl sessionContext;
    protected HttpResponse response;
    private Vector attributeDictionaries = new Vector();
    private static final String METHOD_STRING_GET = "GET";
    private static final String METHOD_STRING_POST = "POST";
    private Hashtable nullHashtable = new Hashtable();
    private String mimeType;
    private BufferedReader reader;
    private boolean gotReader;
    private boolean gotInputStream;
    private boolean isFilterRequest = false;

    public Cookie[] getCookies() {
        String[] stringArray = null;
        stringArray = this.getHeaders().getHeaders("Cookie");
        if (stringArray == null) {
            return null;
        }
        Vector<Cookie> vector = new Vector<Cookie>();
        int n = 0;
        while (n < stringArray.length) {
            int n2 = 0;
            StringTokenizer stringTokenizer = new StringTokenizer(stringArray[n], ",;");
            Cookie cookie = null;
            while (stringTokenizer.hasMoreElements()) {
                String string = null;
                String string2 = null;
                StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), "=");
                if (!stringTokenizer2.hasMoreElements()) break;
                string = stringTokenizer2.nextToken().trim();
                if (!stringTokenizer2.hasMoreElements()) break;
                string2 = stringTokenizer2.nextToken().trim();
                if (stringTokenizer2.hasMoreElements()) break;
                if (string.charAt(0) == '$') {
                    if (string.equalsIgnoreCase("$Version")) {
                        n2 = Integer.parseInt(string2);
                        continue;
                    }
                    if (string.equalsIgnoreCase("$Domain") && cookie != null) {
                        cookie.setDomain(string2);
                        continue;
                    }
                    if (!string.equalsIgnoreCase("$Path") || cookie == null) continue;
                    cookie.setPath(string2);
                    continue;
                }
                try {
                    cookie = new Cookie(string, string2);
                    cookie.setVersion(n2);
                    vector.addElement(cookie);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            ++n;
        }
        Cookie[] cookieArray = new Cookie[vector.size()];
        int n3 = 0;
        while (n3 < cookieArray.length) {
            cookieArray[n3] = (Cookie)vector.elementAt(n3);
            ++n3;
        }
        return cookieArray;
    }

    public void init(ServletConnection servletConnection) throws IOException {
        this.con = servletConnection;
        this.keepAlive = true;
        this.init();
        this.attributeDictionaries.removeAllElements();
        this.in.init(servletConnection.getInputStream());
    }

    private void init() {
        this.mimeType = null;
        this.reader = null;
        this.gotReader = false;
        this.gotInputStream = false;
        this.protocolString = null;
        this.protocolBytes = null;
        this.version = null;
        this.majorVersion = -1;
        this.minorVersion = -1;
        this.params = null;
        this.session = null;
        this.requestedSessionID = null;
        this.assignedRequestURI = null;
        this.isRequestURIAssigned = false;
        this.requestPath = null;
        this.servletPath.reset();
        this.remoteUser.reset();
        this.pathInfo.reset();
        this.headers.clear();
        int n = this.attributeDictionaries.size();
        int n2 = 0;
        while (n2 < n) {
            Object e = this.attributeDictionaries.elementAt(n2);
            if (e instanceof HttpRequestListener) {
                ((HttpRequestListener)e).resetHttpRequest(this);
            }
            ++n2;
        }
    }

    public boolean next() throws IOException, InvalidRequestException {
        boolean bl = false;
        while (!bl) {
            this.in.next();
            try {
                if (!this.line.parse(this.in)) {
                    return false;
                }
                bl = true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (this.line.line != null && this.line.line.length() == 0) continue;
                throw new InvalidRequestException();
            }
        }
        this.init();
        if (this.line.isFullRequest()) {
            try {
                this.headers.read(this.in);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new InvalidRequestException();
            }
            MessageBytes messageBytes = this.line.getMethod();
            this.length = messageBytes.equals(METHOD_STRING_GET) || messageBytes.equals("HEAD") ? -1 : this.headers.getIntHeader("Content-Length");
            if (this.length != -1) {
                this.in.setContentLength(this.length);
            }
            if (this.keepAlive) {
                String string = this.getHeader("Connection");
                if (string != null) {
                    if (this.getProtocolBytes().equals("HTTP/1.0")) {
                        if (!string.equalsIgnoreCase("Keep-Alive")) {
                            this.keepAlive = false;
                        }
                    } else if (string.equalsIgnoreCase("Close")) {
                        this.keepAlive = false;
                    }
                } else if (this.getProtocolBytes().equals("HTTP/1.0")) {
                    this.keepAlive = false;
                }
            }
        } else {
            this.keepAlive = false;
            this.length = -1;
        }
        return true;
    }

    public void finish() throws IOException {
        this.in.finish();
    }

    public void reset() throws IOException {
        this.init();
        this.in.resets();
        this.line.reset();
    }

    public boolean isFullRequest() {
        return this.line.isFullRequest();
    }

    public boolean isProxyRequest() {
        return this.line.isProxyRequest();
    }

    public int getTotalBytes() {
        return this.in.getTotal();
    }

    public MimeHeaders getHeaders() {
        return this.headers;
    }

    public void setKeepAlive(boolean bl) {
        this.keepAlive = bl;
    }

    public boolean getKeepAlive() {
        return this.keepAlive;
    }

    public MessageBytes getRequestPath() {
        if (this.requestPath != null) {
            return this.requestPath;
        }
        return this.line.getRequestPath();
    }

    public void setRequestPath(String string) {
        byte[] byArray = new byte[string.length()];
        string.getBytes(0, byArray.length, byArray, 0);
        this.requestPath = new MessageBytes(byArray, 0, byArray.length);
    }

    public MessageBytes getRequestLine() {
        return this.line.getRequestLine();
    }

    public void setServletPath(String string) {
        this.servletPath.setString(string);
    }

    public void setServletPath(byte[] byArray, int n, int n2) {
        this.servletPath.setBytes(byArray, n, n2);
    }

    public void setPathInfo(String string) {
        this.pathInfo.setString(string);
    }

    public void setPathInfo(byte[] byArray, int n, int n2) {
        this.pathInfo.setBytes(byArray, n, n2);
    }

    public int getContentLength() {
        return this.length;
    }

    public String getContentType() {
        if (this.mimeType == null) {
            this.mimeType = this.headers.getHeader("Content-Type");
        }
        return this.mimeType;
    }

    public String getProtocol() {
        if (this.protocolString != null) {
            return this.protocolString;
        }
        this.protocolString = this.getProtocolBytes().toString();
        return this.protocolString;
    }

    public MessageBytes getProtocolBytes() {
        if (this.protocolBytes != null) {
            return this.protocolBytes;
        }
        this.protocolBytes = this.line.getProtocol();
        return this.protocolBytes;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String string) {
        this.scheme = string;
    }

    public String getVersion() {
        if (this.version != null) {
            return this.version;
        }
        String string = this.getProtocol();
        if (string == null) {
            return null;
        }
        int n = string.indexOf(47);
        if (n == -1) {
            return null;
        }
        this.version = string.substring(n + 1);
        return this.version;
    }

    public int getMajorVersion() {
        if (this.majorVersion != -1) {
            return this.majorVersion;
        }
        String string = this.getVersion();
        if (string == null) {
            return 0;
        }
        int n = string.indexOf(46);
        if (n == -1) {
            return 0;
        }
        this.majorVersion = Integer.parseInt(string.substring(0, n));
        return this.majorVersion;
    }

    public int getMinorVersion() {
        if (this.minorVersion != -1) {
            return this.minorVersion;
        }
        String string = this.getVersion();
        if (string == null) {
            return 0;
        }
        int n = string.indexOf(46);
        if (n == -1) {
            return 0;
        }
        this.minorVersion = Integer.parseInt(string.substring(n + 1));
        return this.minorVersion;
    }

    public String getServerName() {
        String string = this.getHeader("Host");
        if (string == null) {
            string = this.con.getServerName();
        } else {
            int n = string.indexOf(58);
            if (n != -1) {
                string = string.substring(0, n);
            }
        }
        return string;
    }

    public int getServerPort() {
        return this.con.getServerPort();
    }

    public String getRemoteAddr() {
        return this.con.getRemoteAddr();
    }

    public String getRemoteHost() {
        return this.con.getRemoteHost();
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.gotReader) {
            throw new IllegalStateException("can't mix text and binary input");
        }
        this.gotInputStream = true;
        return this.in;
    }

    public BufferedReader getReader() throws UnsupportedEncodingException {
        if (this.gotInputStream) {
            throw new IllegalStateException("can't mix text and binary input");
        }
        if (this.reader == null) {
            this.gotReader = true;
            String string = HttpResponse.getContentCharset(this.getContentType());
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)this.in, string);
            this.reader = new BufferedReader(inputStreamReader);
        }
        return this.reader;
    }

    public String getCharacterEncoding() {
        return HttpResponse.getContentCharset(this.getContentType());
    }

    public String getParameter(String string) {
        String[] stringArray;
        if (this.params == null) {
            this.params = this.getParametersFromRequest();
        }
        if ((stringArray = (String[])this.params.get(string)) == null) {
            return null;
        }
        String string2 = stringArray[0];
        int n = 1;
        while (n < stringArray.length) {
            string2 = String.valueOf(string2) + "," + stringArray[n];
            ++n;
        }
        return string2;
    }

    public String[] getParameterValues(String string) {
        if (this.params == null) {
            this.params = this.getParametersFromRequest();
        }
        return (String[])this.params.get(string);
    }

    public Enumeration getParameterNames() {
        if (this.params == null) {
            this.params = this.getParametersFromRequest();
        }
        return this.params.keys();
    }

    public void setSessionContext(SessionContextImpl sessionContextImpl) {
        this.sessionContext = sessionContextImpl;
    }

    public void setResponse(HttpResponse httpResponse) {
        this.response = httpResponse;
    }

    public HttpSession getSession(boolean bl) {
        if (this.session != null && this.session.isValid()) {
            return this.session;
        }
        if (this.isRequestedSessionIdValid()) {
            return this.session;
        }
        if (bl) {
            Cookie cookie = this.createSessionCookie();
            this.session = new HttpSessionImpl(this.sessionContext, cookie);
            if (this.cookiesSupported()) {
                this.session.setCookieSupported(true);
            }
        } else {
            this.session = null;
        }
        this.response.setHttpSession(this.session);
        return this.session;
    }

    protected boolean cookiesSupported() {
        return this.getHeaders().find("Cookie") != null;
    }

    protected Cookie createSessionCookie() {
        String string = "NEWJSDKCOOKIE";
        Cookie cookie = new Cookie(this.sessionCookieName, string);
        cookie.setComment("Session ID");
        cookie.setPath("/");
        return cookie;
    }

    public String getRequestedSessionId() {
        if (this.requestedSessionID != null) {
            return this.requestedSessionID;
        }
        Cookie cookie = this.getCookie(this.sessionCookieName);
        if (cookie != null) {
            this.requestedSessionID = cookie.getValue();
        }
        return this.requestedSessionID;
    }

    protected Cookie getCookie(String string) {
        Cookie[] cookieArray = this.getCookies();
        Cookie cookie = null;
        if (cookieArray == null) {
            return null;
        }
        int n = 0;
        while (n < cookieArray.length) {
            if (cookieArray[n].getName().equals(string)) {
                cookie = (Cookie)cookieArray[n].clone();
                break;
            }
            ++n;
        }
        return cookie;
    }

    public boolean isRequestedSessionIdFromCookie() {
        String string = this.getRequestedSessionId();
        return string != null;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return false;
    }

    public boolean isRequestedSessionIdValid() {
        if (this.isRequestedSessionIdFromCookie()) {
            this.session = (HttpSessionImpl)this.sessionContext.getSession(this.requestedSessionID);
            if (this.session != null) {
                this.session.setNew(false);
                this.session.setCookieSupported(true);
                this.session.setLastAccessedTime();
                this.response.setHttpSession(this.session);
                return true;
            }
        }
        return false;
    }

    public String getMethod() {
        MessageBytes messageBytes = this.line.getMethod();
        if (messageBytes.equals(METHOD_STRING_GET)) {
            return METHOD_STRING_GET;
        }
        if (messageBytes.equals(METHOD_STRING_POST)) {
            return METHOD_STRING_POST;
        }
        return messageBytes.toString();
    }

    public String getRequestURI() {
        String string = this.isRequestURIAssigned ? this.assignedRequestURI : this.line.getURI().toString();
        return string;
    }

    public void setRequestURI(String string) {
        this.isRequestURIAssigned = true;
        this.assignedRequestURI = string;
    }

    public String getServletPath() {
        return this.servletPath.toString();
    }

    public String getPathInfo() {
        return this.decode(this.pathInfo.toString());
    }

    public String getPathTranslated() {
        String string = this.getPathInfo();
        if (string != null) {
            return this.con.getRealPath(string);
        }
        return null;
    }

    public String getRealPath(String string) {
        return this.con.getRealPath(string);
    }

    public String getQueryString() {
        return this.line.getQueryString().toString();
    }

    public void setRemoteUser(String string) {
        this.remoteUser.setString(string);
    }

    public void setRemoteUser(byte[] byArray, int n, int n2) {
        this.remoteUser.setBytes(byArray, n, n2);
    }

    public String getRemoteUser() {
        return this.remoteUser.toString();
    }

    public void setAuthType(String string) {
        this.authType.setString(string);
    }

    public void setAuthType(byte[] byArray, int n, int n2) {
        this.authType.setBytes(byArray, n, n2);
    }

    public String getAuthType() {
        return this.authType.toString();
    }

    public String getHeader(String string) {
        return this.headers.getHeader(string);
    }

    public void setHeader(String string, String string2) {
        this.headers.putHeader(string, string2);
    }

    public int getIntHeader(String string) {
        return this.headers.getIntHeader(string);
    }

    public long getDateHeader(String string) {
        return this.headers.getDateHeader(string);
    }

    public Enumeration getHeaderNames() {
        return this.headers.names();
    }

    public Object getAttribute(String string) {
        int n = 0;
        while (n < this.attributeDictionaries.size()) {
            Dictionary dictionary = (Dictionary)this.attributeDictionaries.elementAt(n);
            Object v = dictionary.get(string);
            if (v != null) {
                return v;
            }
            ++n;
        }
        return null;
    }

    public void addAttributeDictionary(Dictionary dictionary) {
        this.attributeDictionaries.addElement(dictionary);
    }

    public void dump(PrintStream printStream) {
        printStream.println(">> REQUEST LINE INFO");
        this.line.dump(printStream);
        printStream.println(">> HEADERS");
        this.headers.dump(printStream);
        printStream.println();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("Clone not supported on Cloneable");
        }
    }

    public void setParametersDictionary(Dictionary dictionary) {
        this.params = dictionary;
    }

    public void setRawInputStream(InputStream inputStream) throws IOException {
        this.gotInputStream = false;
        this.gotReader = false;
        this.in.init(inputStream);
    }

    public ServletConnection getConnection() {
        return this.con;
    }

    public boolean isFilterRequest() {
        return this.isFilterRequest;
    }

    public void setFilterRequest(boolean bl) {
        this.isFilterRequest = bl;
    }

    private String decode(String string) {
        if (string == null) {
            return null;
        }
        if (string.indexOf(37) == -1) {
            return string;
        }
        byte[] byArray = new byte[string.length()];
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            if (string.charAt(n2) == '%') {
                byArray[n++] = (byte)Integer.parseInt(string.substring(n2 + 1, n2 + 3), 16);
                n2 = n2 + 2 >= string.length() ? string.length() : (n2 += 2);
            } else {
                byArray[n++] = (byte)string.charAt(n2);
            }
            ++n2;
        }
        return new String(byArray, 0, 0, n);
    }

    private Hashtable getParametersFromRequest() {
        Hashtable hashtable = null;
        if (this.line.getMethod().equals(METHOD_STRING_GET)) {
            String string = this.line.getQueryString().toString();
            if (string != null) {
                try {
                    hashtable = HttpUtils.parseQueryString(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    hashtable = null;
                }
            }
        } else if (this.line.getMethod().equals(METHOD_STRING_POST)) {
            if (this.getContentType() != null && this.getContentType().equals("application/x-www-form-urlencoded")) {
                try {
                    hashtable = HttpUtils.parsePostData(this.getContentLength(), this.getInputStream());
                }
                catch (Exception exception) {
                    hashtable = null;
                }
            } else {
                try {
                    String string = this.line.getQueryString().toString();
                    if (string != null) {
                        hashtable = HttpUtils.parseQueryString(string);
                    }
                }
                catch (Exception exception) {
                    hashtable = null;
                }
            }
        }
        if (hashtable == null) {
            hashtable = this.nullHashtable;
        }
        return hashtable;
    }

    protected void setRequest(HttpRequest httpRequest) {
        this.line = httpRequest.line;
    }
}

