(**************************************************************************)
(*                   Cameleon                                             *)
(*                                                                        *)
(*      Copyright (C) 2002 Institut National de Recherche en Informatique et   *)
(*      en Automatique. All rights reserved.                              *)
(*                                                                        *)
(*      This program is free software; you can redistribute it and/or modify  *)
(*      it under the terms of the GNU General Public License as published by  *)
(*      the Free Software Foundation; either version 2 of the License, or  *)
(*      any later version.                                                *)
(*                                                                        *)
(*      This program is distributed in the hope that it will be useful,   *)
(*      but WITHOUT ANY WARRANTY; without even the implied warranty of    *)
(*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     *)
(*      GNU General Public License for more details.                      *)
(*                                                                        *)
(*      You should have received a copy of the GNU General Public License  *)
(*      along with this program; if not, write to the Free Software       *)
(*      Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA          *)
(*      02111-1307  USA                                                   *)
(*                                                                        *)
(*      Contact: Maxence.Guesdon@inria.fr                                *)
(**************************************************************************)

(** Transfering files. *)

open Unix

module M = Chat_messages
module G = Chat_global

let buffer_size = 8192

let ack_string = "OK"

let transfer_file ?f_progress fd_in fd_out =
  let s = String.create buffer_size in
  let cpt = ref 0 in
  try
    while true do
      match read fd_in s 0 buffer_size with
	0 -> raise End_of_file
      |	n -> 
	  ignore(write fd_out s 0 n);
	  Thread.delay 0.1;
	  cpt := !cpt + n;
	  Chat_messages.verbose (Printf.sprintf "Read and wrote %d chars" n);
	  (match f_progress with None -> () | Some f -> f !cpt)
    done
  with
    _ ->
      close fd_out

let receive_file f_progress f_mes (size,name,sock) =
  try
    ignore (write sock ack_string 0 (String.length ack_string));
    let oc = open_out name in
    try
      let fd_out = descr_of_out_channel oc in
      transfer_file ~f_progress sock fd_out;
      f_mes M.transfer_done
    with
       _ ->
	 f_mes M.transfer_aborted;
	 close_out oc;
	 G.safe_close sock
  with
    _ ->
      f_mes M.transfer_aborted;
      G.safe_close sock
  
let send_file sock f_progress f_mes name =
  let s = String.create buffer_size in
  try
    let n = read sock s 0 buffer_size in
    match String.sub s 0 n with
      s when s = ack_string ->
	let ic = open_in name in
	let fd = descr_of_in_channel ic in
	(
	 try
	   transfer_file ~f_progress fd sock;
	   close_in ic;
	   G.safe_close fd;
	   f_mes M.transfer_done
	 with
	   _ ->
	     f_mes M.transfer_aborted;
	     close_in ic;
	     G.safe_close sock
	)
    | _ ->
	f_mes M.transfer_aborted;
	G.safe_close sock
  with
    _ ->
      f_mes M.transfer_aborted;
      G.safe_close sock

