/*

  IMHO - webmail module for Roxen
  
  Copyright  
  Stefan Wallstrm <stewa@lysator.liu.se>
  & Bosse Lincoln <lincoln@lysator.liu.se> 1998-1999

  Finnish version 1.3 2000-02-09 Seppo Kallio kallio@cc.jyu.fi 
  Finnish version (for 0.97.1) 1999-11-29 Tero Pelander tpeland@tkukoulu.fi
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  See the file "LICENSE" for details.

*/

#include <camas/language.h>

string imho_lang() {
  return "suomi";
}

string imho_lang_short() {
  return "fi";
}

string imho_lang_charset() {
  // The new replacement charset that includes euro
  // return "iso-8859-15";
  return "iso-8859-1";
}

string imho_lang_replacement_string() {
  //this is a UNICODE string that MUST be encodable by the local charset
  return "";
}

string msg(object sessobj,int m,array arg) {
  switch(m) {
    
    // Login page
    
  case M_LOGIN:
    //return "Login:";
    return "Tunnus:";
  case M_PASSWORD:
    //return "Password:";
    return "Salasana:";
  case M_NOLOGIN:
    //return "<b>Could not log in:</b> Wrong login or password. Try again. ";
    return "<b>Ei onnistu:</b> Tunnus tai salasana vrin, yrit uudelleen. ";
  case M_IMAPERROR:
    //return "There was a problem talking to the mail (IMAP) server. Please contact the administrator.";
    return "Yhteytt postipalvelijaan (IMAP) ei saada. Ota yhteys yllpitoon.";    

  case M_SMTPERROR:
    //return "There was a problem talking to the outgoing mail (SMTP) server. The recipient of the mail might not exist.";
    return "Yhteytt postipalvelijaan (SMTP) ei saada. Mahdollisesti vastaanottajaa ei ole olemassa.";

  case M_SAVEDUSERINTERFACE:
    //return "From preferences";
    return "Asetuksista";
  case M_USERINTERFACE:
    //return "User interface:";
    return "Kyttliittym:";
  case M_LOGIN_OK:
    //return "OK";
    return "OK";                  

  case M_NEWMAIL:
    //return "Compose";
    return "Kirjoita uusi kirje";
  case M_MAILBOX:
    //return sprintf("Mailbox: %s",@arg);
    return sprintf("Kansio: %s",@arg);
  case M_MAILBOXES:
    //return "Mailboxes";
    return "Kansiot";
  case M_FILES:
    //return "Files";
    return "Tiedostoja";
  case M_PREFS:
    //return "Preferences";
    return "Asetukset";
  case M_LOGOUT:
    //return "Logout";
    return "Lopeta";

  case M_CURRMAILBOX:
    // return "Current Mailbox";
    return "Aktiivinen postilaatikko";
  case M_CHECKACTIVEMAILBOXES:
    // return "Check active mailboxes";
    return "Tarkista postit";

  case M_FROM:
    //return "From";
    return "Kenelt";
  case M_TO:
    //return "To";
    return "Kenelle";
  case M_CC:
    //return "Cc";
    return "Cc";
  case M_BCC:
    //return "Bcc";
    return "Bcc";
  case M_SUBJECT:
    //return "Subject";
    return "Aihe";
  case M_ATTACHMENTS:
    //return "Attachments";
    return "Liitteet";
  case M_TIME:
    //return "Time";
    return "Aika";
  case M_DATE:
    //return "Date";
    return "Pvm";
    
  case  M_MARKFLAG:
    //return "M";
    return "M";
  case M_NEWFLAG:
    //return "N";
    return "U";
  case M_ANSWEREDFLAG:
    //return "A";
    return "V";
    
    
  case M_SEND:
    //return "Send";
    return "Lhet";
  case M_CANCELSEND:
    //return "Cancel";
    return "Peru";
  case M_SENDMOREFILES:
    //return "Select files to send. Press 'Ctrl' to toggle-select multiple files.";
    return "Valitse lhetettvt tiedostot. Paina 'Ctrl' useiden valitsemiseksi.";
  case M_COMPOSEMAIL:
    //return "Compose mail";
    return "Kirjoita kirje";
  case M_SPELLCHECK:
    return "Oikeinkirjoitus";
  case M_DONTSAVEMAIL:
    //return "Do not save this mail.";
    return "l talleta tt kirjett.";
  case M_ADDFILEASATTACHMENT:
    //return "Add file as attachment";
    return "Lis tiedosto liitteeksi";
  case M_NOATTACHMENTS:
    //return "No attachments";
    return "Ei liitteit";
  case M_ADDATTACHMENT:
    //return "Add attachment...";
    return "Lis liite...";
  case M_REMOVEMARKEDATTACHMENTS:
    //return "Remove marked attachments";
    return "Poista merkitty liite";
  case M_UPLOADATTACHMENT:
    //return "Upload attachment";
    return "Hae liite";
  case M_ADDMARKEDTOATTACHMENTS:
    //return "Add marked to attachments";
    return "Lis merkitty liitteeksi";
  case M_UPLOADTOATTACHMENTS:
    //return "Upload to attachments";
    return "Hae liitteeksi";
  case M_BACKTOCOMPOSE:
    //return "Back to compose";
    return "Takaisin kirjoittamaan";
  case M_NOATTACHFILES:
    //return "No files";
    return "Ei tiedostoja";
  case  M_ATTACHMENTSHEADER:
    return "Liitteit";

  case M_SENDSAVEFAILED:
    //return "Mail was sent successfully, but save in folder failed.";
    return "Viesti lhetettiin, mutta ei voitu tallettaa kansioon.";
  case M_SENDNORECV:
    //return "You must specify a recipient of the mail.";
    return "Sinun tytyy ilmoittaa viestin vastaanottaja.";
  case M_DSN_DELAY:
    //return("Report delayed delivery.");
    return "Rapportoi myhstynyt toimitus.";
  case M_DSN_SUCCESS:
    // return("Report successful delivery.");
    return "Raportoi onnistunut toimitus.";

  case M_DELETEMARKED:
    //return "Delete marked";
    return "Tuhoa merkityt";
  case M_MOVEMARKED:
    //return "Move marked to";
    return "Siirr merkityt kansioon";
  case M_SELECTMBOX:
    //return "(Select a mailbox)";
    return "(Valitse kansio)";
  case M_CHECKNEWMAIL:
    //return "Check for new mail";
    return "Tarkista uusi posti";
  case M_MAILSHOWN:
    // return sprintf("Mail %d-%d of %d", @arg);
    return sprintf("Kirjeet %d-%d/%d", @arg);
  case M_BACKN:
    //return sprintf("[<< Prev %d]", @arg);
    return sprintf("[<< Edelliset %d]", @arg);
  case M_FORWARDN:
    // return sprintf("[Next %d >>]", @arg);
    return sprintf("[Seuraavat %d >>]", @arg);
  case M_NUMBER:
    return "#";
  case M_DELETEMARKEDP:
    //sprintf("Are you sure you want to delete the %d marked message(s)?", 
    return 
      sprintf("Haluatko varmasti poistaa merkityt kirjeet (%d kpl)?", @arg);
  case M_DELETEMARKEDNONE:
    //return "Please mark some messages first.";
    return "Merkitse kirjeet ensin";
  case M_CHANGESORTORDER:
    //return "Change sort order";
    return "Muuta lajittelua";
  case M_MOVETOTRASH:
    //return "Move marked to trash";
    return "Siirr merkityt roskiin";
  case M_DELETEALLTRASH:
    //return "Delete ALL trash";
    return "Tyhjenn roskis";
  case M_NOMAILS:
    // return "[No mail]";
    return "[Ei kirjeit]";
  case M_MARKALL:
    //return "Mark all";
    return "Valitse kaikki";

  case M_MBOXNAME:
    //return "Mailbox";
    return "Kansio";
  case M_DELETEMARKEDMBOX:
    //return "Delete marked";
    return "Tuhoa merkitty";
  case M_CREATEMBOX:
    //return "Create a new mailbox";
    return "Luo uusi kansio";
  case M_NEWMBOXNAME:
    //return "(Name)";
    return "(Nimi)";
  case M_MBOXREMOVEP:
    //return "Are you sure you want to delete the following mailboxes?";
    return "Oletko varma ett haluat tuhota nm kansiot?";
  case M_MBOXMARKONE:
    //return "Mark at least one mailbox.";
    return "Merkitse vhintn yksi kansio.";
  case M_NEWMBOXNONAME:
    // return "Type in a name first.";
    return "Kirjoita nimi ensin.";
  case M_CREATEMBOXERROR:
    //return "Failed to create mailbox. The name may be illegal or the mailbox may exist.";
    return "Kansion luonti eponnistui. Nimi voi olla virheellinen tai jo olemassa.";
  case M_INBOX:
    //return "Inbox";
    return "Saapuva";
  case M_PREVIOUS_LEVEL:
    //return "[Previous level]";
    return "[Seuraava taso]";
  case M_FOLDER_PATH:
    //return "Path:";
    return "Hakupolku:";
	
  case M_FILENAME:
    //return "Filename";
    return "Tiedoston nimi";
  case M_SIZE:
    //return "Size";
    return "Koko";
  case M_MIMETYPE:
    //return "Type";
    return "Tyyppi";
  case M_DELETEMARKEDFILES:
    //return "Delete marked";
    return "Tuhoa merkityt";
  case M_UPLOAD:
    //return "Upload";
    return "Hae";
  case M_AVAILSPACE:
    //return sprintf("You have %d Kb available for upload.",@arg);
    return sprintf("Sinulla on %d Ktavua kytettviss.",@arg);
  case M_WINDOWSBUG :
    //return "Windowsusers: 
    //Due to a bug in some browsers, filenames can be crippled.
    // Avoid this by replacing the last \\ with \\\\ before pressing 'Upload'.";
    return "Windows-kyttjt: Joissakin selaimissa on virhe, tiedostonimet voivat olla vajaita, vlt tm korvaamalla viimeinen '\\' merkinnll '\\\\' ennenkuin valitset 'Hae'.";
  case M_NOFILES:
    //return "You have no uploades files.";
    return "Et ole hakenut yhtn tiedostoa.";

  case M_PNAME:
    //return "Name";
    return "Nimi";
  case M_PMAILADDRESS:
    //return "Mail address";
    return "Postiosoite";
  case M_PMAILPATH:
    //return "Mail searchpath";
    return "Postikansioiden hakupolku";
  case M_PINCLUDEMAIL:
    //return "Include mail when replying";
    return "Ota kirje mukaan vastaukseen";
  case M_PQUOTEPREFIX :
    //return "Prefix";
    return "Prefix";
  case M_PSIGNATURE:
    //return "Signature";
    return "Allekirjoitus";
  case M_PINACTIVELOGOUT:
    //return "Inactive logout (minutes)";
    return "Kyttmttmn yhteyden katkaisu (minuutteja)";
  case M_PSAVEANDUSE:
    //return "Save and use";
    return "Talleta ja kyt";
  case M_PVISIBLEMESSAGES:
    //return "Messages shown in mailbox";
    return "Kirjeiden mr sivulla";
  case M_PSORTORDER:
    //return "Mail sort order";
    return "Kirjeiden lajittelujrjestys";
  case M_PSORTORDERS:
    //return ([ "forward": "forward", "backward":"backward"])[arg[0]];
    return ([ "forward": "eteenpin", "backward":"taaksepin"])[arg[0]];
  case M_PTRASHFOLDER:
    //return "Trash folder";
    return "Roskis";
  case M_PSENTFOLDER:
    //return "Sent mail folder";
    return "Lhetettyjen kansio";
  case M_PDEFAULTBCC:
    //return "Default Bcc address";
    return "Oletus Bcc-osoite";
  case M_PSAVEATTACHMENTS:
    //return "Save attachments";
    return "Talleta liitteet";
  case M_PLANGUAGE:
    //return "Language";
    return "Kieli";
  case M_PUSERINTERFACE:
    //return "User interface";
    return "Kyttliittym";
  case M_PHEADER:
    //return "Extra headers";
    return "Ylimriset otsakkeet";
  case M_PHEADERDESC:
    //return "(Lines with headers in this format: header:value )";
    return "(Otsakerivej muodossa: otsake:arvo )";

  case M_SPELLDONE:
    //return "Done";
    return "Tehty";
  case M_SPELLPREV:
    //return "Previous";
    return "Edellinen";
  case M_SPELLNEXT:
    //return "Next";
    return "Seuraava";
  case  M_SPELLCHANGETO:
    //return "Change to";
    return "Korvaaja";
  case M_SPELLSUGGESTIONS:
    //return "Suggestions";
    return "Ehdotukset";

  case M_LOGOUTMSG:
    //return "You are logged out. Close this browser window to make sure no one can read your mail.<br><br>Reload this page to login.";
    return "<h1>Yhteys postipalvelijaan katkaistu. Sulje ikkuna jotta kirjeesi pysyvt salassa.</h1><br>Lataa sivu uudelleen jos haluat takaisin postin lukuun.";
  case M_LOGGEDOUT:
    //return "Logged out";
    return "Yhteys suljettu";

  case M_QUESTION:
    //return "Question"; 
    return "Kysymys";
  case M_INFO:
    //return "Info"; 
    return "Info";

  case M_REPLY:
    //return "Reply";
    return "Vastaa";
  case M_READPREV:
    //return "Read previous";
    return "Lue edellinen";
  case M_READNEXT:
    //return "Read next";
    return "Lue seuraava";
  case M_ATTACHMENTLINK:
    //return sprintf("%sattachment of type %s",@arg);
    return sprintf("%sliitteen tyyppi %s",@arg);
  case M_MAILMISSING:
    //return "<b>Error:</b> Failed to fetch mail. Try again. <br>";
    return "<b>Virhe:</b> Kirje ei lytynyt. Yrit uudelleen.<br>";
  case M_MAILMISSINGBACK:
    //return "Back";
    return "Takaisin";
  case M_DELETE:
    //return "Delete";
    return "Tuhoa";
  case M_FORWARD:
    //return "Forward";
    return "Lhet edelleen";
  case M_MAIL:
    // return "Mail";
    return "Posti";
  case M_SHOWFULLHEADERS:
    //return "Show full headers";
    return "Nyt headerit";
  case M_HIDEFULLHEADERS:
    //return "Hide full headers";
    return "Piilota headerit";
  case M_MAILTOOBIG:
    // return "Mail is too big to be shown. Click here to download it.";
    return "Viesti liian iso. Klikkaa tst aloittaaksesi siirron koneellesi.";
  case M_REPLYTOALL:
    //return "Reply to all";
    return "Vastaa kaikille";
  case M_MOVETHISTOTRASH:
    //return "Move to trash";
    return "Siirr roskikseen";
  case M_CHARSETWARNING:
    //return sprintf("Warning! Unable to decode the characterset \"%s\". Message is presented undecoded.",@arg);
    return sprintf("Varoitus! Merkistn \"%s\" dekoodaus eponnistui. Viesti esitetn alkuperisess muodossaan.",@arg);

  case M_ADDRESSBOOKTITLE: 
    //return("Address Book");
    return("Osoitekirja");
  case M_ADDRESSBOOK:
    //return("Address book...");
    return("Osoitekirja...");
  case M_INDEXNAMERECIPIENT:
    //return("Intex name (click to add as recipient)");
    return("Luettelon nimi (osoita jos haluat vastaanottajaksi)");
  case M_INDEXNAMEEDIT:
    //return("Index name (click to edit)");
    return("Luettelon nimi (osoita jos haluat muuttaa)");
  case M_ADDRESS:
    //return("Address");
    return("Osoite");
  case M_NOADDRESSES:
    //return("No addresses");
    return("Ei osoitteita");
  case M_NEWADDRESS:
    //return("New address...");
    return("Uusi osoite...");
  case M_EDITADDRESS:
    //return("Edit address");
    return("Muuta osoitetta");
  case M_ADDADDRESS:
    //return("Add to address book");
    return("Lis osoitekirjaan");
  case M_INDEXNAME:
    //return("Index name");
    return("Luettelon nimi");
  case M_ADDRESSFORMAT:
    //return("Address(es), comma separated");
    return("Osoite tai osoitteet, pilkut vliin jos useita");
  case M_SAVEADDRESS:
    //return("Save and use");
    return("Talleta ja kyt");
  case M_DELETEADDRESS:
    //return("Delete address");
    return("Poista osoite");
  case M_CANCELADDRESS:
    //return("Cancel");
    return("Peru");
  case M_CANNOTIMPORT:
    //return("Cannot import this addressbook, since its\nformat is not recognized.");
    return("Ei voi hakea tt osoitekirjaa\nse on tuntematonta muotoa.");
  case M_IMPORTADDRESSBOOKTITLE:
    //return("Import address book");
    return("Hae osoitekirja");
  case M_UPLOADADDRESSBOOK:
    //return("Upload a Pine or exported Netscape (.ldif) address book");
    return("Hae Pine- tai talletettu Netscape (.ldif) osoitekirja");
  case M_PINELOCATION:
    //return("The Pine address book is often in ~/.addressbook");
    return("Pineosoitekirja on yleens ~/.addressbook");
  case M_UPLOADANDIMPORT:
    //return("Upload and import");
    return("Hae ja ota kyttn");
  case M_IMPORTADDRESSBOOK:
    // return("Import address book...");
    return("Hae osoitekirja...");
  case M_GLOBALADDRESSES:
    return("Yhteiset osoitteet:");

  case M_LDAPTITLE:
    //return("LDAP addresses");
    return("LDAP osoitteet");
  case M_LDAP:
    //return("LDAP");
    return("LDAP");
  case M_SEARCHLDAP:
    //return("Search LDAP");
    return("Etsi LDAP");
  case M_NAMECONT:
    //return("Search name containing:");
    return("Etsi nime, joka sislt:");
  case M_OU:
    //return("OU");
    return("OU");

  case M_YES:
    //return "Yes";
    return "Kyll";
  case M_NO:
    //return "No";
    return "Ei";
  case M_DIALOGOK:
    // return "OK";
    return "OK";
  case M_DIALOGCANCEL:
    // return "Cancel";
    return "Peru";
   
  }
  return 0;
}
