
/*
 *  Diverse Bristol audio routines.
 *  Copyright (c) by Nick Copeland <nick.copeland@ntlworld.com> 1996,2002
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*
 * Need to have basic template for an operator. Will consist of
 *
 *	bristolinit()
 *	operate()
 *	param()
 *	reset()
 *
 *	destroy() is in the library.
 *
 * Operate will be called when all the inputs have been loaded, and the result
 * will be an output buffer written to the next operator.
 */

#include "bristol.h"

/*
 * The name of this operator, IO count, and IO names.
 */
#define OPNAME "Template"
#define IOCOUNT 4
static char *IO[] = {"param1", "param2", "param3", "param4"};

/*
 * Reset any local memory information.
 */
static int reset(bristolOP *operator)
{
#ifdef BRISTOL_DBG
	printf("reset(%x)\n", operator);
#endif
}

/*
 * Alter an internal parameter of an operator.
 */
static int param(bristolOP *operator, bristolParam *param)
{
#ifdef BRISTOL_DBG
	printf("param(%x)\n", operator);
#endif
}

static int operate(bristolOP *operator)
{
#ifdef BRISTOL_DBG
	printf("operate(%x)\n", operator);
#endif
}

/*
 * Setup any variables in our OP structure, in our IO structures, and malloc
 * any memory we need.
 */
bristolOP *
bristolinit(bristolOP **operator, int index, int samplerate, int samplecount)
{
#ifdef BRISTOL_DBG
	printf("init(%x(%x), %i, %i, %i)\n",
		operator, *operator, index, samplerate, samplecount);
#endif

	*operator = bristolOPinit(operator, index, samplecount);

	/*
	 * Then the local parameters specific to this operator. These will be
	 * the same for each operator, but must be inited in the local code.
	 */
	(*operator)->operate = operate;
	(*operator)->reset = reset;
	(*operator)->param = param;

	/*
	 * These are specific to this operator, and will need to be altered for
	 * each operator.
	 */
	(*operator)->OPname = OPNAME;
	(*operator)->opcount = IOCOUNT;

	for ((*operator)->local[0] = 0;
		(*operator)->local[0] < (*operator)->opcount;
		((*operator)->local[0])++)
	{
		/*
		 * Init each IO in turn
		 */
		(*operator)->bio[(int) (*operator)->local[0]] =
			bristolIOinit(&((*operator)->bio[(int) (*operator)->local[0]]),
				(int) (*operator)->local[0],
				IO[((int) (*operator)->local[0])],
				samplerate,
				samplecount);
		((*operator)->bio[(int) (*operator)->local[0]])->owner =
			(struct BristolOP *) operator;

		if ((*operator)->local[0] > 0)
		{
			((*operator)->bio[(int) (*operator)->local[0]])->last =
				(*operator)->bio[(int) (*operator)->local[0] - 1];
			((*operator)->bio[(int) (*operator)->local[0] - 1])->next =
				(*operator)->bio[(int) (*operator)->local[0]];
		} else {
			((*operator)->bio[(int) (*operator)->local[0]])->last =
				(struct BristolIO *) NULL;
		}
		((*operator)->bio[(int) (*operator)->local[0]])->next =
			(struct BristolIO *) NULL;
	}

	return(*operator);
}

