#ifndef _KDEMAINEDITOR_H_
#define _KDEMAINEDITOR_H_

#include <kmainwindow.h>
#include <kapp.h>
#include <qstrlist.h>
#include <qscrollview.h>
#include <qsplitter.h>
#include <qpixmap.h>
#include <qtimer.h>

#include "prMainEditor.h"

class KLineEdit;
class QPopupMenu;
class QScrollBar;
class QProgressBar;
class QSpinBox;
class KAccel;
class KToolBar;
class HeadLine;
class TimeBar;
class KAction;
class KURL;
class QBoxLayout;
class KAction;
class KRecentFilesAction;
class KToggleAction;
class KLineEditAction;
class KSpinBoxAction;
class SelectionFrameAction;

enum SelectArea { NONE, TRACKS, PARTS };

class KdeMainEditor : public KMainWindow, public PrMainEditor
{
  Q_OBJECT

 private:
  KApplication * _app;
  int            _argc;
  char **        _argv;
  SelectArea     _select_area;
  KToolBar *     panel;
  QWidget *      _main;
  QBoxLayout *   _mainlayout;
  QSplitter *    _splitter;
  QScrollBar *   _mainvscrollbar;
  QWidget *      _leftmain;
  QBoxLayout *   _leftlayout;
  QScrollView *  _leftscroller;
  QWidget *      _left; 
  QWidget *      _child;
  QScrollView *  _rightscroller;
  QWidget *      _rightmain;
  QBoxLayout *   _rightlayout;
  QWidget *      _right;
  QScrollBar *   _scrollbar;
  QProgressBar * _progressbar;
  HeadLine *     _headline;
  TimeBar *      _timebar;
  int            _tool;
  QPixmap        cropTool;
  QPixmap        glueTool;
  QPixmap        arrTool;
  QCursor *      arrcursor;
  QWidget *      _cursor;

  char * _meter_text;
  char * _caption_text;
  char * _position_text;
  int _grid;
  int _track_width;
  int _track_height;
  double _pixPerTick;
  int _bar_offset;
  int _play_count;
  bool _cycl;
  int _loop;
  bool shftFlag;
  bool ctrlFlag;
  bool suprFlag;

  // Actions:
  KAction * _filesave;
  KRecentFilesAction * _recent;
  KAction * _projectexport;
  KAction * _projectimport;
  KAction * _projectcollect;
  KAction * _editundo;
  KAction * _editredo;
  KAction * _editclearhistory;
  KAction * _editcut;
  KAction * _editcopy;
  KAction * _editpaste;
  KToggleAction * _showtoolbar;
  KToggleAction * _showstatusbar;
  KToggleAction * _showpanel;
  KToggleAction * _showmixer;
  KAction * _play;
  KAction * _playall;
  KAction * _record;
  KAction * _pause;
  KLineEditAction * _songposition;
  KSpinBoxAction * _tempobox;
  KLineEditAction * _meteredit;
  SelectionFrameAction * _selectionframe;

  void initKeyAccel();
  void initStatusBar();
  void initView();
  void initSong();
  
  /**
   * load a BMS file from an URL
   */
  void loadFile( const KURL & );
  
  /**
   * save a BMS file to an URL
   */
  void saveFile( const KURL & );

  /** contains the recently used filenames */
  QStrList recentFiles;
  
  /** the configuration object of the application */
  // KConfig *config;
  /** the key accelerator container */
  KAccel *keyAccel;

  QPopupMenu * undopopup;
  QPopupMenu * redopopup;
  QTimer * timer;

  KToolBar * toolbar;

  QPopupMenu * userDefArr;
  QPopupMenu * globalUserDef;
  QPopupMenu * songUserDef;
  void makeSongMenu(QPopupMenu*);
  void makeGlobalMenu(QPopupMenu*);

 public:
  KdeMainEditor(const char * name, KApplication * app, int argc, char ** argv);
  virtual ~KdeMainEditor();
  virtual void run();
  virtual void update();
  virtual void gui(GuiEvents,bool);
  virtual void startTimer();
  virtual void fatalError(FatalError);
  void updateAddons();

  int trackHeight();
  double pixPerTick();
  int barOffset();
  SelectArea selectArea();
  void selectArea(SelectArea);

  QWidget * left();
  QWidget * right();
  void displaySongProperties();
  void setCursorPosition(long);
  int snap();

  void addRecentFile(const KURL &url);
  int tool();
  bool shft();
  bool ctrl();
  bool supr();

 protected:
  void setupActions();
  virtual void paintEvent( QPaintEvent * );

  public slots:
    //void commandCallback(int id_);
    //void statusCallback(int id_);
    void adjustHistory();
    void slotFileNewWindow();
    void slotFileNew();
    void slotFileOpen();
    void slotFileOpenRecent( const KURL & );
    void slotFileLoadAddon();
    void slotFileSave();
    void slotFileSaveAs();
    void slotFileImportMidi();
    void slotFileExportMidi();
    void slotFileAppend();
    void slotFileAppendMidi();
    void slotFileSpecialEffects();
    void slotFileClose();
    void slotFilePrint();
    void slotFileQuit();
    void slotProjectNew();
    void slotProjectExport();
    void slotProjectImport();
    void slotProjectCollect();
    void slotEditUndo();
    void slotEditRedo();
    void slotEditPlusH();
    void slotEditMinusH();
    void slotEditCut();
    void slotEditCopy();
    void slotEditPaste();
    void slotEditScore();
    void slotEditScore2();
    void slotEditPianoRoll();
    void slotEditMarkLeft();
    void slotEditMarkRight();
	void slotEditMixdown();
    void slotEditBack();
    void slotEditRewind();
    void slotEditForward();
	void slotEditCycle();
	void slotEditRecord();
	void slotEditPlay();
	void slotEditPlayAll();
	void slotEditPause();
    void slotEditPreferences();
    void slotEditShell();
    void slotAddTrack(int);
	void slotAddScoretrack();
	void slotAddDrumtrack();
	void slotAddMastertrack();
	void slotAddAudiotrack();
	void slotAddComment();
    void slotUndoMenu(int);
    void slotRedoMenu(int);
    
    void slotViewToolBar();
    void slotViewPanel();
    void slotViewMixer();
    void slotViewStatusBar();

	void slotSettingsConfigureKeys();
	void slotSettingsConfigureToolbars();
	void slotNewToolbarConfig();

    void slotPosEntered();
    void slotTempoEntered(int);
    void slotMeterEntered();

    void slotSongAddon(int);
    void slotGlobalAddon(int);
    void slotStatusMsg(const QString &text);
    void slotStatusHelpMsg(const QString &text);
    
    //void slotTool(int);
    void slotToolArrow();
    void slotToolCrop();
    void slotToolGlue();
    void slotTimerEvent();
    void slotStop();

    void resizeEvent( QResizeEvent * );
    void keyPressEvent ( QKeyEvent * );
    void keyReleaseEvent ( QKeyEvent * );

protected slots:
	void slotGrid1();
	void slotGrid2();
	void slotGrid4();
	void slotGrid8();
	void slotGrid16();
	void slotGrid32();
	void slotGrid64();
	void slotGridOff();
	void slotClearOplist();

	/*
	 * called when the vertical Scrollbar emits valueChanged( int )
	 */
	void slotVerticalScroll( int );

	void slotLeftScroll( int );
	void slotRightScroll( int );
};

#endif
