#ifndef _SELECTRIGHT_CPP_
#define _SELECTRIGHT_CPP_

#include <iostream.h>

#include "selectRight.h"
#include "element.h"
#include "compound.h"

#include "track.h"
#include "part.h"
#include "song.h"
#include "event.h"
#include "table.h"
#include "reference.h"

extern Song * sonG;
extern Table * selectioN;

SelectRight::SelectRight(Part * pt, Position left) : _part(pt) {
  _type = SELECTRIGHT;
  _description = "select right";
  _to_be_undone = false;
  _oldTable = 0;
  _delete = 0;
  _size = selectioN->size();
  if (_size==0) {                                  // nothing selected -> select left most event or "left" if specified
    Event * ev = (Event*) _part->first();
    if (left!=0) for (;ev!=0 && _part->start(ev)<left;ev = (Event*)Element::next(ev)) {}
    if (!ev) ev = (Event*) _part->first();
    selectioN->add(new Reference(ev));
  } else if (_size==1) {                           // one event selected -> move right
    Reference * r = (Reference*) selectioN->first();
    Element * ev = r->getValue();
    selectioN->remove(r);
    delete r;
    ev = _part->next(ev);
    if (ev==0) ev = _part->first();
    selectioN->add(new Reference(ev));
  } else {                                         // large selection -> select right event from selection
    _oldTable = selectioN;
    _delete = _oldTable;
    selectioN = new Table();
    selectioN->add(new Reference(((Reference*)_oldTable->last())->getValue()));
  }

}


SelectRight::SelectRight(const SelectRight& el) : Operation(el) {
  _type = SELECTRIGHT;
  _part = el._part;
  _oldTable = el._oldTable;
  _delete = el._delete;
  _size = el._size;
}

SelectRight::~SelectRight() {
  if (_oldTable!=0) {
    ((Compound*)_oldTable)->scratch();
    delete _oldTable;
  }
}

void SelectRight::undo() {
  if (_size==0) {
    Reference * r = (Reference*) selectioN->first();
    selectioN->remove(r);
    delete r;
  } else if (_size==1) {
    Reference * r = (Reference*) selectioN->first();
    Element * ev = r->getValue();
    selectioN->remove(r);
    delete r;
    ev = _part->prev(ev);
    if (ev==0) ev = _part->last();
    selectioN->add(new Reference(ev));
  } else {
    Table * tmp = _oldTable;
    _oldTable = selectioN;
    _delete = _oldTable;
    selectioN = tmp;
  }
}

void SelectRight::redo() {
  if (_size==0) {
    selectioN->add(new Reference(_part->first()));
  } else if (_size==1) {
    Reference * r = (Reference*) selectioN->first();
    Element * ev = r->getValue();
    selectioN->remove(r);
    delete r;
    ev = _part->next(ev);
    if (ev==0) ev = _part->first();
    selectioN->add(new Reference(ev));
  } else {
    Table * tmp = _oldTable;
    _oldTable = selectioN;
    _delete = _oldTable;
    selectioN = tmp;
  }
}



// ---------------
// virtuals:
//

ostream & SelectRight::print(int dep, ostream & s) const {
  s << spc(dep) << "<SELECTRIGHT size=\"" << _size << "\" />" << endl;
  return s;
}

void SelectRight::flush(const char * c) const {
  cout << c << "SELECTRIGHT" << endl;
}

Element * SelectRight::copy() const {
  return new SelectRight(*this);
}




#endif
