#ifndef _DRUMTRACK_H_
#define _DRUMTRACK_H_

#include "track.h"

class DrumTrack : public Track
{
 private:
  int _channel;
  int _program;
  int _output;
  int _volume;
  int _delay;
  int _transpose;

 public:
  DrumTrack();
  DrumTrack(const DrumTrack&);
  ~DrumTrack();

  int channel() const { return _channel; }
  int program() const { return _program; }
  int output() const { return _output; }
  int volume() const { return _volume; }
  int delay() const { return _delay; }
  int transpose() const { return _transpose; }

  void setChannel(int);
  void setProgram(int);
  void setOutput(int);
  void setVolume(int);
  void setDelay(int);
  void setTranspose(int);

  virtual ostream & printOptions(int,ostream&) const;
  virtual void flush(const char*) const;
  virtual Element * copy() const;

  void loadOpt(ifstream*&);

};

#endif
