// bbappman.cc for bbappman - an application manager for Blackbox.
//
//  Copyright (c) 1998-1999 by John Kennis, jkennis@chello.nl
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// (See the included file COPYING / GPL-2.0)
//

#include "bbappconf.hh"
#include "version.h"

ToolWindow::ToolWindow(int argc,char **argv, struct CMDOPTIONS *options) :
  Basewindow(argc,argv,options) {
  XrmInitialize();

  iargc=argc;
  iargv=argv;

  resource = new Resource(this);
  wminterface = new WMInterface(this);
  appWindowList = new LinkedList<AppWindow>;

  config_db = XrmGetFileDatabase("config.bb");

	iconic = options->iconic;
  desktop_nr=0;
  current_desktop_nr=-1;
  wm_init=False;
  number_of_icons=0;
  row_last=column_last=0;
  pushed_app=0;
  MakeWindow(False);
  wminterface->moduleInit();
	eventLoop();
}

ToolWindow::~ToolWindow() {
  XUnmapWindow(getXDisplay(),framewin);

  /* destroy pixmaps */
  if (pixmap.frame) getImageControl()->removeImage(pixmap.frame);
//  if (pixmap.desktop) getImageControl()->removeImage(pixmap.desktop);
  XrmDestroyDatabase(config_db);
  /* destroy windows */
  XDestroyWindow(getXDisplay(),framewin);
  /* destroy windows */
  delete appWindowList;
}

int ToolWindow::getWindowGeometry(AppWindow  *appwin) {
/*  unsigned int border_width,depth,width,height;
  Window root_return,child_return;
  int x_return,y_return,x,y;
  int status;

  status = XGetGeometry(getXDisplay(),appwin->getWindow(),
                        &root_return,&x_return,
                        &y_return,&width,&height,
                        &border_width,&depth);
  if (status) {
    XTranslateCoordinates(getXDisplay(),appwin->getWindow(),
                          root_return,x_return,
                          y_return,&x,&y,
                          &child_return);
    appwin->setWindowPosition(x,y,width,height);
    return 1;
  }
  return 0;*/
}


void ToolWindow::reconfigure(void) {
  /* destroy pixmaps */
  getImageControl()->removeImage(pixmap.frame);
  getImageControl()->removeImage(pixmap.appwindow);

  resource->Reload();

  MakeWindow(True);


  desktop_nr=0;

  XClearWindow(getXDisplay(), framewin);
}


void ToolWindow::removeAppWindow(Window win)
{
/*  struct GEOM pos;
  AppWindow *tmp=0;
  number_of_icons--;
  LinkedListIterator<AppWindow> win_it(appWindowList);
  for (; win_it.current(); win_it++) {
    if (tmp) {
      int x=pos.x, y=pos.y, w=pos.width, h=pos.height;
      pos=win_it.current()->getAppWindowPosition();
      win_it.current()->setAppWindowPosition(x,y,w,h);
      XMoveResizeWindow(getXDisplay(),win_it.current()->getAppWindow(),x,y,w,h);
    }
    if (((win_it.current()->getWindow()) == win)) {
      tmp = win_it.current();
      pos=tmp->getAppWindowPosition();
    }
  }
  appWindowList->remove(tmp);
  if (tmp->isFocused()) focuswin=0;
  XDestroyWindow(getXDisplay(),tmp->getAppWindow());
  delete tmp;


  if (resource->position.vertical) {
   if (number_of_icons<resource->columns)
    frame.width=(unsigned int)(resource->desktopSize.width + 
                resource->frame.bevelWidth)*
                (number_of_icons%resource->columns) + 
                resource->frame.bevelWidth;
   else
    frame.width=(unsigned int)(resource->desktopSize.width + 
                 resource->frame.bevelWidth)*
                 resource->columns + resource->frame.bevelWidth;

    frame.height=(unsigned int)(((number_of_icons-1)/
                  resource->columns)+1)*
                  (resource->desktopSize.height + 
                   resource->frame.bevelWidth) +
                   resource->frame.bevelWidth;
  } else {
    frame.width=(unsigned int)((number_of_icons-1)/resource->rows+1) *
                (resource->desktopSize.width +
                 resource->frame.bevelWidth) + 
                 resource->frame.bevelWidth;
   
    if (number_of_icons<resource->rows)
      frame.height=(unsigned int)(resource->desktopSize.height+
                  resource->frame.bevelWidth)*
                  (number_of_icons%resource->rows) + 
                  resource->frame.bevelWidth;
    else
      frame.height=(unsigned int)(resource->desktopSize.height+
                  resource->frame.bevelWidth)*
                  resource->rows + resource->frame.bevelWidth;
  }

  if (resource->position.mask & XNegative) {
    frame.x = getCurrentScreenInfo()->getWidth() +
              resource->position.x - frame.width;
  }
  if (resource->position.mask & YNegative) {
    frame.y = getCurrentScreenInfo()->getHeight() +
              resource->position.y - frame.height;
  }
              
  if (!withdrawn)
    XMoveResizeWindow(getXDisplay(), framewin,frame.x,frame.y,
                      frame.width,frame.height);
  else
    XResizeWindow(getXDisplay(),framewin,frame.width,frame.height);

  if (!shape)
    XSetWindowBackgroundPixmap(getXDisplay(), framewin, pixmap.frame);

  XClearWindow(getXDisplay(),framewin);
  desktop_nr--;*/
}

void ToolWindow::addAppWindow(Window *win,bool reconfigure) {
  Atom real_type;
  int format;
  unsigned long n, extra;
  AppWindow *tmp=0;
  BlackboxHints *net_hint;
  BlackboxHints net_hints;
  XClassHint classhint;
  XTextProperty text_property;
  int count;
  char **name;
  int i;
  bool class_handled=false;
  int handle_class=-1;
  int handle_name=-1;
  if (!reconfigure) {
  // get applciation wm class & name
  if (XGetClassHint(getXDisplay(),*win,&classhint)==0) {
    //fprintf(stderr,"Can't get classhint\n");
    return;
  }
  //get application name
//  if (XGetWMName(getXDisplay(),*win,&text_property)!=0) {
//    if (XTextPropertyToStringList(&text_property, &name, &count)) {
//      fprintf(stderr,"name:%s\n",*name);
//      application_name=*name;
//    }
//  }

  /* find the matching class name */
  for (i=0;i<resource->getNumberOfApps();i++) {
    handle_class=-1;
    handle_name=-1;

    if (resource->getAppConf(i)->getClass()!=0) {
      if (strcmp(resource->getAppConf(i)->getClass(),classhint.res_class)==0) {
        handle_class=1;
      } else {
        handle_class=0;
      }

    }
    if ((resource->getAppConf(i)->getName()!=0)) {
      if (strcmp(resource->getAppConf(i)->getName(),classhint.res_name)==0) {
        handle_name=1;
      } else {
        handle_name=0;
      }
    }

    if ( ((handle_class==-1)&(handle_name==1))|
         ((handle_class==1)&(handle_name==-1))|
         ((handle_class==1)&(handle_name==1)) ) {
        /* set omnipresent ? */
      if (resource->getAppConf(i)->getSticky()) {
        getWMInterface()->setOmniPresent(*win,true);
      }
      /* set decoreless ? */
      if (resource->getAppConf(i)->getDecorless()) {
        getWMInterface()->setDecor(*win,false);
      }
        /* set startondesktop */
      if (resource->getAppConf(i)->getStartOnDesktop()!=0) {
        getWMInterface()->sendWindowToDesktop(*win,
                                resource->getAppConf(i)->getStartOnDesktop()-1);
      }
      /* set window size */
			if (resource->getAppConf(i)->getWidth()>=0 &&
				resource->getAppConf(i)->getHeight()>=0) {
				getWMInterface()->resizeWindow(*win,resource->getAppConf(i)->getWidth(),resource->getAppConf(i)->getHeight());
			}
			/* set window position */
      if (resource->getAppConf(i)->getPositionX()!=-1111 &&
				resource->getAppConf(i)->getPositionY()!=-1111) {
        getWMInterface()->moveWindow(*win,resource->getAppConf(i)->getPositionX(),resource->getAppConf(i)->getPositionY());
      }
      if (resource->getAppConf(i)->getMaxHoriz() ||
         resource->getAppConf(i)->getMaxVert()) {
        if (XGetWindowProperty(getXDisplay(), *win, 
              getBlackboxAttributesAtom(), 0L, 
              PropBlackboxHintsElements, False, 
              getBlackboxAttributesAtom(), 
              &real_type, &format,&n, &extra,  
              (unsigned char**)&net_hint) == Success && net_hint)
          if (n==PropBlackboxHintsElements) {
            if (resource->getAppConf(i)->getMaxHoriz() && 
                resource->getAppConf(i)->getMaxVert()) {
              if (!((net_hint->flags & (AttribMaxHoriz|AttribMaxVert) ) & 
                    (net_hint->attrib& (AttribMaxHoriz|AttribMaxVert) ))) {
                XUnmapWindow(getXDisplay(),*win);
                net_hints.attrib= AttribMaxHoriz|AttribMaxVert;
                net_hints.flags= AttribMaxHoriz|AttribMaxVert;
                XChangeProperty(getXDisplay(), *win, getBlackboxHintsAtom(),
                          getBlackboxHintsAtom(), 32, PropModeReplace,
                          (unsigned char *) &net_hints,  
                          PropBlackboxHintsElements);
                XMapWindow(getXDisplay(),*win);
              } 
            } else {
              /* start maximized horizontal */
              if (resource->getAppConf(i)->getMaxHoriz()) {
                BlackboxHints net_hints;
                if (!((net_hint->flags & AttribMaxHoriz) & 
                   (net_hint->attrib & AttribMaxHoriz))) {
                  XUnmapWindow(getXDisplay(),*win);
                  net_hints.attrib= AttribMaxHoriz;
                  net_hints.flags= AttribMaxHoriz;
                  XChangeProperty(getXDisplay(), *win, getBlackboxHintsAtom(),
                          getBlackboxHintsAtom(), 32, PropModeReplace,
                          (unsigned char *) &net_hints,  
                          PropBlackboxHintsElements);
                  XMapWindow(getXDisplay(),*win);
                }
              }
              /* start maximized vertical */
              if (resource->getAppConf(i)->getMaxVert()) {
                if (!((net_hint->flags & AttribMaxVert) & 
                    (net_hint->attrib & AttribMaxVert))) {
                  XUnmapWindow(getXDisplay(),*win);
                  net_hints.attrib= AttribMaxVert;
                  net_hints.flags= AttribMaxVert;
                  XChangeProperty(getXDisplay(), *win, getBlackboxHintsAtom(),
                        getBlackboxHintsAtom(), 32, PropModeReplace,  
                        (unsigned char *) &net_hints,  
                        PropBlackboxHintsElements);
                  XMapWindow(getXDisplay(),*win);
                }
              }
            }
          }
        }
      }
    }
  }
}

void ToolWindow::MakeWindow(bool reconfigure) {
  XSetWindowAttributes attrib;
  XWMHints wmhints;
  XClassHint classhints;
  XTextProperty windowname;

  unsigned long create_mask = CWBackPixmap|CWBorderPixel|
                              CWOverrideRedirect |CWCursor|CWEventMask;

  frame.width=64;
	frame.height=resource->frame.font->ascent +
             	resource->frame.font->descent+4*resource->frame.bevelWidth;

  frame.x=resource->position.x;
  frame.y=resource->position.y;
  if (resource->position.mask & XNegative) {
    frame.x = getCurrentScreenInfo()->getWidth() +
              resource->position.x - frame.width;
  }

  if (resource->position.mask & YNegative) {
    frame.y = getCurrentScreenInfo()->getHeight() +
              resource->position.y - frame.height;

  }

  if (withdrawn) {
    attrib.override_redirect = False;
    wmhints.initial_state = WithdrawnState;
  } else {
  	attrib.override_redirect = False;
	 	wmhints.initial_state = NormalState;
  }

  attrib.background_pixmap = ParentRelative;
  attrib.border_pixel=resource->desktopwin.activeColor.getPixel();


  pixmap.frame = getImageControl()->renderImage(frame.width, frame.height,
                 &resource->frame.texture);

  pixmap.appwindow =	getImageControl()->renderImage(resource->desktopSize.width,
                   resource->desktopSize.height,
                   &resource->desktopwin.texture);


  attrib.cursor = getSessionCursor();
  attrib.event_mask = ButtonPressMask | ButtonReleaseMask | ExposureMask |
                      FocusChangeMask | StructureNotifyMask|
                      SubstructureRedirectMask;

  if (!reconfigure) {
    framewin = XCreateWindow(getXDisplay(),
                             getCurrentScreenInfo()->getRootWindow(), frame.x,
                             frame.y, frame.width,
                             frame.height, 0,
                             getCurrentScreenInfo()->getDepth(),
                             InputOutput,
                             getCurrentScreenInfo()->getVisual(),
                             create_mask, &attrib);
  } else if (!withdrawn) {
    XMoveResizeWindow(getXDisplay(), framewin, frame.x,frame.y,
                      frame.width,frame.height);

  } else {
    XResizeWindow(getXDisplay(),framewin,frame.width,frame.height);
  }

  char *name=BBTOOL;
  XSizeHints sizehints;

  wmhints.flags = StateHint | InputHint;
  wmhints.input = False;

  classhints.res_name=BBTOOL;
  classhints.res_class="bbtools";

  sizehints.x=frame.x;//getResource()->position.x;
  sizehints.y=frame.y;//getResource()->position.y;

  sizehints.max_width=sizehints.min_width=frame.width;
  sizehints.max_height=sizehints.min_height=frame.height;
  sizehints.flags=USPosition|PMinSize|PMaxSize;

  XStringListToTextProperty(&name,1,&windowname);
  XSetWMProperties(getXDisplay(),framewin,&windowname,NULL,getArgv(),getArgc(),
                  &sizehints,&wmhints,&classhints);
  Atom wmproto[2];
  wmproto[0]=wm_delete_window;
  wmproto[1]=getBlackboxStructureMessagesAtom();
  XSetWMProtocols(getXDisplay(), framewin,wmproto, 3);

  if (!decorated&&!withdrawn) {
    BlackboxHints net_hints;
    net_hints.decoration=DecorNone;
    net_hints.attrib= AttribOmnipresent;
    net_hints.flags=AttribDecoration|AttribOmnipresent;
    XChangeProperty(getXDisplay(), framewin, getBlackboxHintsAtom(),
                getBlackboxHintsAtom(), 32, PropModeReplace,
                (unsigned char *) &net_hints,  PropBlackboxHintsElements);
  }



  if (!shape) {
    XSetWindowBackgroundPixmap(getXDisplay(), framewin, pixmap.frame);
  }

	if (!reconfigure) {

//		gcv.font = resource->menu.font->fid;
//   	gcv.foreground = resource->menu.texture.getColor()->getPixel();
//	  menuGC = XCreateGC(getXDisplay(), framewin,GCFont|GCForeground, &gcv);

//	  gcv.foreground = resource->menu.highlightColor.getPixel();
//    gcv.arc_mode = ArcChord;
// 		gcv.fill_style = FillSolid;
//	 	menuHiBGGC = XCreateGC(getXDisplay(), framewin,GCForeground|
//                           GCFillStyle|GCArcMode, &gcv);

//	  gcv.foreground = resource->menu.hitextColor.getPixel();
//	  menuHiGC = XCreateGC(getXDisplay(), framewin,	GCFont|GCForeground, &gcv);

//	  gcv.foreground = resource->menu.textColor.getPixel();
//		menuFrameGC = XCreateGC(getXDisplay(), framewin,GCFont|GCForeground, &gcv);

  } else {

/*		gcv.font = resource->menu.font->fid;
   	gcv.foreground = resource->menu.texture.getColor()->getPixel();
	  XChangeGC(getXDisplay(), menuGC,GCFont|GCForeground, &gcv);

	  gcv.foreground = resource->menu.highlightColor.getPixel();
  	XChangeGC(getXDisplay(), menuHiBGGC,GCFont|GCForeground, &gcv);

	  gcv.foreground = resource->menu.hitextColor.getPixel();
	  XChangeGC(getXDisplay(), menuHiGC, GCFont|GCForeground, &gcv);

	  gcv.foreground = resource->menu.textColor.getPixel();
		XChangeGC(getXDisplay(), menuFrameGC,GCFont|GCForeground, &gcv);
	*/
	//  appmenu->Reconfigure();
  }


  XClearWindow(getXDisplay(), framewin);
  XMapWindow(getXDisplay(), framewin);
  XMapSubwindows(getXDisplay(), framewin);
  if (iconic) {
    getWMInterface()->setIconicState(framewin, True);
  }

}

void ToolWindow::CheckConfig()
{
	struct stat file_status;

	if (stat(config_filename,&file_status)!=0)
	{
		fprintf(stderr,"Could not open config file %s\n",
        		resource->style.conf_filename);
	}
   	else if (file_status.st_mtime != resource->style.mtime)
	{
		resource->style.mtime=file_status.st_mtime;
		reconfigure();
	}
}

void ToolWindow::process_event(XEvent *Event) {
  static bool moved;
  static Window grabbedWindow;
  static int grabbed_x,grabbed_y,move_x,move_y;

  switch (Event->type) {
    case  PropertyNotify: {
      wminterface->windowAttributeChange(Event->xproperty.window);
    }
    break;
    case ClientMessage: {
      if ((unsigned)Event->xclient.data.l[0]==wm_delete_window) shutdown();
//      if ()(unsigned)Event->xclient.data.l[0]==getWMChangeStateAtom()
      wminterface->handleNETEvents(*Event);
    }
    break;
    case ButtonPress: {
    {
/*      LinkedListIterator<AppWindow> win_it(appWindowList);
      for (; win_it.current(); win_it++) {
        win_it.current()->buttonPressEvent(Event);
      }*/
    }
      if (Event->xbutton.button == LEFT_BUTTON) {
        if (Event->xbutton.window==framewin) {
          reconfigure();
          //XRaiseWindow(getXDisplay(),framewin);
          //lower=False;
        }
      }
      if (Event->xbutton.button == MIDDLE_BUTTON) {
        if (Event->xbutton.window==framewin) {
          //XLowerWindow(getXDisplay(),framewin);
          //lower=True;
        } else {
/*          LinkedListIterator<AppWindow> win_it(appWindowList);
          for (; win_it.current(); win_it++) {
            if (Event->xbutton.window==win_it.current()->getAppWindow()) {
              pushed_app=win_it.current();
              win_it.current()->drawPushed(True);
              break;
            }
          }*/
        }
      }
      if (Event->xbutton.button == RIGHT_BUTTON) {
        LinkedListIterator<AppWindow> win_it(appWindowList);
/*        for (; win_it.current(); win_it++) {
          if (Event->xbutton.window==win_it.current()->getAppWindow()) {
            pushed_app=win_it.current();
            win_it.current()->drawPushed(True);
            break;
          }
        }*/
      }
    }
    break;
    case ButtonRelease: {
    {
/*      LinkedListIterator<AppWindow> win_it(appWindowList);
      for (; win_it.current(); win_it++) {
        win_it.current()->buttonReleaseEvent(Event);
      }*/
    }
      if (Event->xbutton.button == MIDDLE_BUTTON) {
/*        if (pushed_app) {
          if (Event->xbutton.x > 0 &&
              Event->xbutton.x < pushed_app->getAppWindowPosition().width &&
              Event->xbutton.y >0 &&
              Event->xbutton.y < pushed_app->getAppWindowPosition().height ) {
            if (pushed_app->isShaded()) {
                wminterface->setWindowShade(pushed_app->getWindow(),False);
            }
            else {
                wminterface->setWindowShade(pushed_app->getWindow(),True);
            }
            pushed_app=0;
          }
        }*/
      }
      if (Event->xbutton.button == RIGHT_BUTTON) {
       /*        if (pushed_app) {
          if (Event->xbutton.x > 0 &&
              Event->xbutton.x < pushed_app->getAppWindowPosition().width &&
              Event->xbutton.y >0 &&
              Event->xbutton.y < pushed_app->getAppWindowPosition().height ) {
              fprintf(stderr,"released\n");

            if (pushed_app->isIcon())
                wminterface->setIconicState(pushed_app->getWindow(),False);
            else
                wminterface->setIconicState(pushed_app->getWindow(),True);
            pushed_app=0;
          }
        }*/
      }

    }
    break;
    case ConfigureNotify: {
      if (Event->xconfigure.window==framewin && Event->xconfigure.send_event) {
      if (withdrawn)
        reconfigure();
      int parent_x,parent_y;
      Window parent_root;
      unsigned int parent_width;
      unsigned int parent_height;
      unsigned int parent_border_width;
      unsigned int parent_depth;
      frame.x=Event->xconfigure.x;
      frame.y=Event->xconfigure.y;
      if (withdrawn) {
        XGetGeometry(getXDisplay(),Event->xconfigure.above,&parent_root,
                     &parent_x,&parent_y,&parent_width,&parent_height,
                     &parent_border_width,&parent_depth);
                     frame.x=Event->xconfigure.x+parent_x;
        frame.x+=parent_x;
        frame.y+=parent_y;
      } else {
        if (position==NULL) position= new char [13];
          sprintf(position,"+%i+%i",frame.x,frame.y);
      }
    }
    else {
/*      LinkedListIterator<AppWindow> win_it(appWindowList);
      AppWindow *tmp;
      for (; win_it.current(); win_it++)
        if ((win_it.current()->getWindow()) == Event->xconfigure.window) {
          tmp=win_it.current();

          getWindowGeometry(tmp);

        }*/

      }
    }
    break;
    case Expose: {
/*      LinkedListIterator<AppWindow> win_it(appWindowList);
      for (; win_it.current(); win_it++) {
        win_it.current()->exposeEvent(Event);
      }*/
    }
    break;
    case MotionNotify: {
/*     LinkedListIterator<AppWindow> win_it(appWindowList);
      for (; win_it.current(); win_it++) {
        win_it.current()->motionNotifyEvent(Event);
      }*/
    }
    break;
    case EnterNotify: {
/*      LinkedListIterator<AppWindow> win_it(appWindowList);
      for (; win_it.current(); win_it++) {
        win_it.current()->enterNotifyEvent(Event);
      }*/
    }
    break;
    case LeaveNotify: {
/*      LinkedListIterator<AppWindow> win_it(appWindowList);
      for (; win_it.current(); win_it++) {
        win_it.current()->leaveNotifyEvent(Event);
      }*/
    }
    break;
  }
}
