/*
        8534def.inc

        AVA, Uros Platise, Marek Michalkiewicz
        (c) 1. Jul 1999
*/

/* ***** I/O Register Definitions */
#define	SREG	 0x3f
#define SPH	 0x3e
#define	SPL	 0x3d
#define	GIMSK	 0x3b
#define	GIFR	 0x3a
#define	TIMSK	 0x39
#define	TIFR	 0x38

#define	MCUCR	 0x35

#define	TCCR0	 0x33
#define	TCNT0	 0x32

#define	TCCR1	 0x2e
#define	TCNT1H	 0x2d
#define	TCNT1L	 0x2c

#define	EEARH	 0x1f
#define	EEARL	 0x1e
#define	EEDR	 0x1d
#define	EECR	 0x1c
#define	PORTA	 0x1b
#define	DDRA	 0x1a

#define GIPR	 0x10

#define ADMUX    0x07
#define ADCSR    0x06
#define ADCH     0x05
#define ADCL     0x04


/* ***** Bit Definitions */

#define	INT1	 7
#define	INT0	 6

#define	INTF1	 7
#define	INTF0	 6

#define	TOIE1	 2
#define	TOIE0	 0

#define	TOV1	 2
#define	TOV0	 0

#define	SE	 6
#define	SM	 5
#define	ISC1	 2
#define	ISC0	 0

#define	CS02	 2
#define	CS01	 1
#define	CS00	 0

#define CS12	 2
#define CS11	 1
#define CS10	 0

#define	EERIE	 3
#define	EEMWE	 2
#define	EEWE	 1
#define	EERE	 0

#define	PA6	 6
#define	PA5	 5
#define	PA4	 4
#define	PA3	 3
#define	PA2	 2
#define	PA1	 1
#define	PA0	 0

#define	DDA6	 6
#define	DDA5	 5
#define	DDA4	 4
#define	DDA3	 3
#define	DDA2	 2
#define	DDA1	 1
#define	DDA0	 0

#define IPIN1	 3
#define IPIN0	 2

#define	MUX2	 2
#define	MUX1	 1
#define	MUX0	 0

#define	ADEN	 7
#define	ADSC	 6
#define	ADFR	 5
#define	ADIF	 4
#define	ADIE	 3
#define	ADPS2	 2
#define	ADPS1	 1
#define	ADPS0	 0

#define	XL	 r26
#define	XH	 r27
#define	YL	 r28
#define	YH	 r29
#define	ZL	 r30
#define	ZH	 r31

#define RAMEND   0x15F	/* Last On-Chip SRAM location */
#define	XRAMEND  0x15F
#define	E2END	 0x1FF

/* FLASH byte addresses */
#define	FLASHEND 0x1FFF

#define	INT0addr 0x002	/* External Interrupt0 Vector Address */
#define	INT1addr 0x004	/* External Interrupt1 Vector Address */
#define	OVF1addr 0x006	/* Overflow1 Interrupt Vector Address */
#define	OVF0addr 0x008	/* Overflow0 Interrupt Vector Address */
#define	ADCCaddr 0x00A	/* ADC Conversion Complete Interrupt Vector Address */
#define	ERDYaddr 0x00C	/* EEPROM Write Complete Interrupt Vector Address */

#define VECT_SIZE 0x0E	/* interrupt vector table size */

/* eof */
