dnl Available from the GNU Autoconf Macro Archive at:
dnl http://www.gnu.org/software/ac-archive/htmldoc/ax_boost_regex.html
dnl
AC_DEFUN([AX_BOOST_REGEX],
[AC_REQUIRE([AC_CXX_NAMESPACES])dnl
AC_CACHE_CHECK(whether the Boost::Regex library is available,
ax_cv_boost_regex,
[AC_LANG_SAVE
 AC_LANG_CPLUSPLUS
 AC_COMPILE_IFELSE(AC_LANG_PROGRAM([[#include <boost/regex.hpp>]],
			           [[boost::regex r(); return 0;]]),
  	           ax_cv_boost_regex=yes, ax_cv_boost_regex=no)
 AC_LANG_RESTORE
])
if test "$ax_cv_boost_regex" = yes; then
  AC_DEFINE(HAVE_BOOST_REGEX,,[define if the Boost::Regex library is available])
  dnl Now determine the appropriate file names
  AC_ARG_WITH([boost-regex],AS_HELP_STRING([--with-boost-regex],
  [specify the boost regex library or suffix to use]),
  [if test "x$with_boost_regex" != "xno"; then
    ax_regex_lib=$with_boost_regex
    ax_boost_regex_lib=boost_regex-$with_boost_regex
  fi])
  for ax_lib in $ax_regex_lib $ax_boost_regex_lib boost_regex; do
    AC_CHECK_LIB($ax_lib, main, [BOOST_REGEX_LIB=$ax_lib break])
  done
  AC_SUBST(BOOST_REGEX_LIB)
fi
])dnl
