dnl Available from the GNU Autoconf Macro Archive at:
dnl http://www.gnu.org/software/ac-archive/htmldoc/ac_caolan_check_package.html
dnl
AC_DEFUN([AC_caolan_CHECK_PACKAGE],
[

AC_ARG_WITH($1,
[  --with-$1[=DIR]	root directory of $1 installation],
with_$1=$withval
if test "${with_$1}" != yes; then
	$1_include="$withval/include"
	$1_libdir="$withval/lib"
fi
)

AC_ARG_WITH($1-include,
[  --with-$1-include=DIR        specify exact include dir for $1 headers],
$1_include="$withval")

AC_ARG_WITH($1-libdir,
[  --with-$1-libdir=DIR        specify exact library dir for $1 library
  --without-$1        disables $1 usage completely],
$1_libdir="$withval")

if test "${with_$1}" != no ; then
	OLD_LIBS=$LIBS
	OLD_LDFLAGS=$LDFLAGS
	OLD_CFLAGS=$CFLAGS
	OLD_CPPFLAGS=$CPPFLAGS

	if test "${$1_libdir}" ; then
		LDFLAGS="$LDFLAGS -L${$1_libdir}"
	fi
	if test "${$1_include}" ; then
		CPPFLAGS="$CPPFLAGS -I${$1_include}"
		CFLAGS="$CFLAGS -I${$1_include}"
	fi

	no_good=no
	AC_CHECK_LIB($3,$2,,no_good=yes)
	AC_CHECK_HEADER($4,,no_good=yes)
	if test "$no_good" = yes; then
dnl	broken
		ifelse([$6], , , [$6])

		LIBS=$OLD_LIBS
		LDFLAGS=$OLD_LDFLAGS
		CPPFLAGS=$OLD_CPPFLAGS
		CFLAGS=$OLD_CFLAGS
	else
dnl	fixed
		ifelse([$5], , , [$5])

		AC_DEFINE(HAVE_PKG_$1)
	fi

fi

])
