// This file may be redistributed and modified only under the terms of
// the GNU Lesser General Public License (See COPYING for details).
// Copyright 2000-2001 Stefanus Du Toit and Alistair Riddoch.
// Automatically generated using gen_cc.py.

#include <Atlas/Objects/Operation/RootOperation.h>

using Atlas::Message::Element;

namespace Atlas { namespace Objects { namespace Operation { 

RootOperation::RootOperation()
     : Root("", "root_operation"), attr_serialno(0), attr_refno(0), attr_seconds(0.0), attr_future_seconds(0.0)
{
    setObjtype(std::string("op"));
}

RootOperation::RootOperation(const char * id, const char * parent)
     : Root(id, parent), attr_serialno(0), attr_refno(0), attr_seconds(0.0), attr_future_seconds(0.0)
{
    setObjtype(std::string("op"));
}

RootOperation::~RootOperation()
{
}

RootOperation RootOperation::Class()
{
    RootOperation value("root_operation", "root");

    value.setObjtype(std::string("op_definition"));
    
    return value;
}

bool RootOperation::hasAttr(const std::string& name) const
{
    if (name == "serialno") return true;
    if (name == "refno") return true;
    if (name == "from") return true;
    if (name == "to") return true;
    if (name == "seconds") return true;
    if (name == "future_seconds") return true;
    if (name == "time_string") return true;
    if (name == "args") return true;
    return Root::hasAttr(name);
}

Element RootOperation::getAttr(const std::string& name) const
    throw (NoSuchAttrException)
{
    if (name == "serialno") return attr_serialno;
    if (name == "refno") return attr_refno;
    if (name == "from") return attr_from;
    if (name == "to") return attr_to;
    if (name == "seconds") return attr_seconds;
    if (name == "future_seconds") return attr_future_seconds;
    if (name == "time_string") return attr_time_string;
    if (name == "args") return attr_args;
    return Root::getAttr(name);
}

void RootOperation::setAttr(const std::string& name, const Element& attr)
{
    if (name == "serialno") { setSerialno(attr.asInt()); return; }
    if (name == "refno") { setRefno(attr.asInt()); return; }
    if (name == "from") { setFrom(attr.asString()); return; }
    if (name == "to") { setTo(attr.asString()); return; }
    if (name == "seconds") { setSeconds(attr.asFloat()); return; }
    if (name == "future_seconds") { setFutureSeconds(attr.asFloat()); return; }
    if (name == "time_string") { setTimeString(attr.asString()); return; }
    if (name == "args") { setArgs(attr.asList()); return; }
    Root::setAttr(name, attr);
}

void RootOperation::removeAttr(const std::string& name)
{
    if (name == "serialno") return;
    if (name == "refno") return;
    if (name == "from") return;
    if (name == "to") return;
    if (name == "seconds") return;
    if (name == "future_seconds") return;
    if (name == "time_string") return;
    if (name == "args") return;
    Root::removeAttr(name);
}

void RootOperation::sendSerialno(Atlas::Bridge* b) const
{
    if (attr_serialno != 0) {
        b->mapItem("serialno", attr_serialno);
    }
}

void RootOperation::sendRefno(Atlas::Bridge* b) const
{
    if (attr_refno != 0) {
        b->mapItem("refno", attr_refno);
    }
}

void RootOperation::sendFrom(Atlas::Bridge* b) const
{
    if (!attr_from.empty()) {
        b->mapItem("from", attr_from);
    }
}

void RootOperation::sendTo(Atlas::Bridge* b) const
{
    if (!attr_to.empty()) {
        b->mapItem("to", attr_to);
    }
}

void RootOperation::sendSeconds(Atlas::Bridge* b) const
{
    if (attr_seconds != 0.0) {
        b->mapItem("seconds", attr_seconds);
    }
}

void RootOperation::sendFutureSeconds(Atlas::Bridge* b) const
{
    if (attr_future_seconds != 0.0) {
        b->mapItem("future_seconds", attr_future_seconds);
    }
}

void RootOperation::sendTimeString(Atlas::Bridge* b) const
{
    if (!attr_time_string.empty()) {
        b->mapItem("time_string", attr_time_string);
    }
}

void RootOperation::sendArgs(Atlas::Bridge* b) const
{
    if (!attr_args.empty()) {
        Atlas::Message::Encoder e(b);
        e.mapItem("args", attr_args);
    }
}

void RootOperation::sendContents(Bridge* b) const
{
    sendSerialno(b);
    sendRefno(b);
    sendFrom(b);
    sendTo(b);
    sendSeconds(b);
    sendFutureSeconds(b);
    sendTimeString(b);
    sendArgs(b);
    Root::sendContents(b);
}

Element RootOperation::asObject() const
{
    Element::MapType m = Root::asObject().asMap();
    m["serialno"] = Element(attr_serialno);
    m["refno"] = Element(attr_refno);
    m["from"] = Element(attr_from);
    m["to"] = Element(attr_to);
    m["seconds"] = Element(attr_seconds);
    m["future_seconds"] = Element(attr_future_seconds);
    m["time_string"] = Element(attr_time_string);
    m["args"] = Element(attr_args);
    return Element(m);
}

Element::MapType RootOperation::asMap() const
{
    Element::MapType m = Root::asObject().asMap();
    m["serialno"] = Element(attr_serialno);
    m["refno"] = Element(attr_refno);
    m["from"] = Element(attr_from);
    m["to"] = Element(attr_to);
    m["seconds"] = Element(attr_seconds);
    m["future_seconds"] = Element(attr_future_seconds);
    m["time_string"] = Element(attr_time_string);
    m["args"] = Element(attr_args);
    return m;
}

} } } // namespace Atlas::Objects::Operation

#include <Atlas/Objects/Operation/Action.h>

using Atlas::Message::Element;

namespace Atlas { namespace Objects { namespace Operation { 

Action::Action()
     : RootOperation("", "action")
{
}

Action::Action(const char * id, const char * parent)
     : RootOperation(id, parent)
{
}

Action::~Action()
{
}

Action Action::Class()
{
    Action value("action", "root_operation");

    value.setObjtype(std::string("op_definition"));
    
    return value;
}

} } } // namespace Atlas::Objects::Operation

#include <Atlas/Objects/Operation/Create.h>

using Atlas::Message::Element;

namespace Atlas { namespace Objects { namespace Operation { 

Create::Create()
     : Action("", "create")
{
}

Create::Create(const char * id, const char * parent)
     : Action(id, parent)
{
}

Create::~Create()
{
}

Create Create::Class()
{
    Create value("create", "action");

    value.setObjtype(std::string("op_definition"));
    
    return value;
}

} } } // namespace Atlas::Objects::Operation

#include <Atlas/Objects/Operation/Combine.h>

using Atlas::Message::Element;

namespace Atlas { namespace Objects { namespace Operation { 

Combine::Combine()
     : Create("", "combine")
{
}

Combine::Combine(const char * id, const char * parent)
     : Create(id, parent)
{
}

Combine::~Combine()
{
}

Combine Combine::Class()
{
    Combine value("combine", "create");

    value.setObjtype(std::string("op_definition"));
    
    return value;
}

} } } // namespace Atlas::Objects::Operation

#include <Atlas/Objects/Operation/Divide.h>

using Atlas::Message::Element;

namespace Atlas { namespace Objects { namespace Operation { 

Divide::Divide()
     : Create("", "divide")
{
}

Divide::Divide(const char * id, const char * parent)
     : Create(id, parent)
{
}

Divide::~Divide()
{
}

Divide Divide::Class()
{
    Divide value("divide", "create");

    value.setObjtype(std::string("op_definition"));
    
    return value;
}

} } } // namespace Atlas::Objects::Operation

#include <Atlas/Objects/Operation/Communicate.h>

using Atlas::Message::Element;

namespace Atlas { namespace Objects { namespace Operation { 

Communicate::Communicate()
     : Create("", "communicate")
{
}

Communicate::Communicate(const char * id, const char * parent)
     : Create(id, parent)
{
}

Communicate::~Communicate()
{
}

Communicate Communicate::Class()
{
    Communicate value("communicate", "create");

    value.setObjtype(std::string("op_definition"));
    
    return value;
}

} } } // namespace Atlas::Objects::Operation

#include <Atlas/Objects/Operation/Talk.h>

using Atlas::Message::Element;

namespace Atlas { namespace Objects { namespace Operation { 

Talk::Talk()
     : Communicate("", "talk")
{
}

Talk::Talk(const char * id, const char * parent)
     : Communicate(id, parent)
{
}

Talk::~Talk()
{
}

Talk Talk::Class()
{
    Talk value("talk", "communicate");

    value.setObjtype(std::string("op_definition"));
    
    return value;
}

} } } // namespace Atlas::Objects::Operation

#include <Atlas/Objects/Operation/Delete.h>

using Atlas::Message::Element;

namespace Atlas { namespace Objects { namespace Operation { 

Delete::Delete()
     : Action("", "delete")
{
}

Delete::Delete(const char * id, const char * parent)
     : Action(id, parent)
{
}

Delete::~Delete()
{
}

Delete Delete::Class()
{
    Delete value("delete", "action");

    value.setObjtype(std::string("op_definition"));
    
    return value;
}

} } } // namespace Atlas::Objects::Operation

#include <Atlas/Objects/Operation/Set.h>

using Atlas::Message::Element;

namespace Atlas { namespace Objects { namespace Operation { 

Set::Set()
     : Action("", "set")
{
}

Set::Set(const char * id, const char * parent)
     : Action(id, parent)
{
}

Set::~Set()
{
}

Set Set::Class()
{
    Set value("set", "action");

    value.setObjtype(std::string("op_definition"));
    
    return value;
}

} } } // namespace Atlas::Objects::Operation

#include <Atlas/Objects/Operation/Move.h>

using Atlas::Message::Element;

namespace Atlas { namespace Objects { namespace Operation { 

Move::Move()
     : Set("", "move")
{
}

Move::Move(const char * id, const char * parent)
     : Set(id, parent)
{
}

Move::~Move()
{
}

Move Move::Class()
{
    Move value("move", "set");

    value.setObjtype(std::string("op_definition"));
    
    return value;
}

} } } // namespace Atlas::Objects::Operation

#include <Atlas/Objects/Operation/Get.h>

using Atlas::Message::Element;

namespace Atlas { namespace Objects { namespace Operation { 

Get::Get()
     : Action("", "get")
{
}

Get::Get(const char * id, const char * parent)
     : Action(id, parent)
{
}

Get::~Get()
{
}

Get Get::Class()
{
    Get value("get", "action");

    value.setObjtype(std::string("op_definition"));
    
    return value;
}

} } } // namespace Atlas::Objects::Operation

#include <Atlas/Objects/Operation/Perceive.h>

using Atlas::Message::Element;

namespace Atlas { namespace Objects { namespace Operation { 

Perceive::Perceive()
     : Get("", "perceive")
{
}

Perceive::Perceive(const char * id, const char * parent)
     : Get(id, parent)
{
}

Perceive::~Perceive()
{
}

Perceive Perceive::Class()
{
    Perceive value("perceive", "get");

    value.setObjtype(std::string("op_definition"));
    
    return value;
}

} } } // namespace Atlas::Objects::Operation

#include <Atlas/Objects/Operation/Look.h>

using Atlas::Message::Element;

namespace Atlas { namespace Objects { namespace Operation { 

Look::Look()
     : Perceive("", "look")
{
}

Look::Look(const char * id, const char * parent)
     : Perceive(id, parent)
{
}

Look::~Look()
{
}

Look Look::Class()
{
    Look value("look", "perceive");

    value.setObjtype(std::string("op_definition"));
    
    return value;
}

} } } // namespace Atlas::Objects::Operation

#include <Atlas/Objects/Operation/Listen.h>

using Atlas::Message::Element;

namespace Atlas { namespace Objects { namespace Operation { 

Listen::Listen()
     : Perceive("", "listen")
{
}

Listen::Listen(const char * id, const char * parent)
     : Perceive(id, parent)
{
}

Listen::~Listen()
{
}

Listen Listen::Class()
{
    Listen value("listen", "perceive");

    value.setObjtype(std::string("op_definition"));
    
    return value;
}

} } } // namespace Atlas::Objects::Operation

#include <Atlas/Objects/Operation/Sniff.h>

using Atlas::Message::Element;

namespace Atlas { namespace Objects { namespace Operation { 

Sniff::Sniff()
     : Perceive("", "sniff")
{
}

Sniff::Sniff(const char * id, const char * parent)
     : Perceive(id, parent)
{
}

Sniff::~Sniff()
{
}

Sniff Sniff::Class()
{
    Sniff value("sniff", "perceive");

    value.setObjtype(std::string("op_definition"));
    
    return value;
}

} } } // namespace Atlas::Objects::Operation

#include <Atlas/Objects/Operation/Touch.h>

using Atlas::Message::Element;

namespace Atlas { namespace Objects { namespace Operation { 

Touch::Touch()
     : Perceive("", "touch")
{
}

Touch::Touch(const char * id, const char * parent)
     : Perceive(id, parent)
{
}

Touch::~Touch()
{
}

Touch Touch::Class()
{
    Touch value("touch", "perceive");

    value.setObjtype(std::string("op_definition"));
    
    return value;
}

} } } // namespace Atlas::Objects::Operation

#include <Atlas/Objects/Operation/Login.h>

using Atlas::Message::Element;

namespace Atlas { namespace Objects { namespace Operation { 

Login::Login()
     : Get("", "login")
{
}

Login::Login(const char * id, const char * parent)
     : Get(id, parent)
{
}

Login::~Login()
{
}

Login Login::Class()
{
    Login value("login", "get");

    value.setObjtype(std::string("op_definition"));
    
    return value;
}

} } } // namespace Atlas::Objects::Operation

#include <Atlas/Objects/Operation/Logout.h>

using Atlas::Message::Element;

namespace Atlas { namespace Objects { namespace Operation { 

Logout::Logout()
     : Login("", "logout")
{
}

Logout::Logout(const char * id, const char * parent)
     : Login(id, parent)
{
}

Logout::~Logout()
{
}

Logout Logout::Class()
{
    Logout value("logout", "login");

    value.setObjtype(std::string("op_definition"));
    
    return value;
}

} } } // namespace Atlas::Objects::Operation

#include <Atlas/Objects/Operation/Imaginary.h>

using Atlas::Message::Element;

namespace Atlas { namespace Objects { namespace Operation { 

Imaginary::Imaginary()
     : Action("", "imaginary")
{
}

Imaginary::Imaginary(const char * id, const char * parent)
     : Action(id, parent)
{
}

Imaginary::~Imaginary()
{
}

Imaginary Imaginary::Class()
{
    Imaginary value("imaginary", "action");

    value.setObjtype(std::string("op_definition"));
    
    return value;
}

} } } // namespace Atlas::Objects::Operation

#include <Atlas/Objects/Operation/Info.h>

using Atlas::Message::Element;

namespace Atlas { namespace Objects { namespace Operation { 

Info::Info()
     : RootOperation("", "info")
{
}

Info::Info(const char * id, const char * parent)
     : RootOperation(id, parent)
{
}

Info::~Info()
{
}

Info Info::Class()
{
    Info value("info", "root_operation");

    value.setObjtype(std::string("op_definition"));
    
    return value;
}

} } } // namespace Atlas::Objects::Operation

#include <Atlas/Objects/Operation/Perception.h>

using Atlas::Message::Element;

namespace Atlas { namespace Objects { namespace Operation { 

Perception::Perception()
     : Info("", "perception")
{
}

Perception::Perception(const char * id, const char * parent)
     : Info(id, parent)
{
}

Perception::~Perception()
{
}

Perception Perception::Class()
{
    Perception value("perception", "info");

    value.setObjtype(std::string("op_definition"));
    
    return value;
}

} } } // namespace Atlas::Objects::Operation

#include <Atlas/Objects/Operation/Sight.h>

using Atlas::Message::Element;

namespace Atlas { namespace Objects { namespace Operation { 

Sight::Sight()
     : Perception("", "sight")
{
}

Sight::Sight(const char * id, const char * parent)
     : Perception(id, parent)
{
}

Sight::~Sight()
{
}

Sight Sight::Class()
{
    Sight value("sight", "perception");

    value.setObjtype(std::string("op_definition"));
    
    return value;
}

} } } // namespace Atlas::Objects::Operation

#include <Atlas/Objects/Operation/Appearance.h>

using Atlas::Message::Element;

namespace Atlas { namespace Objects { namespace Operation { 

Appearance::Appearance()
     : Sight("", "appearance")
{
}

Appearance::Appearance(const char * id, const char * parent)
     : Sight(id, parent)
{
}

Appearance::~Appearance()
{
}

Appearance Appearance::Class()
{
    Appearance value("appearance", "sight");

    value.setObjtype(std::string("op_definition"));
    
    return value;
}

} } } // namespace Atlas::Objects::Operation

#include <Atlas/Objects/Operation/Disappearance.h>

using Atlas::Message::Element;

namespace Atlas { namespace Objects { namespace Operation { 

Disappearance::Disappearance()
     : Sight("", "disappearance")
{
}

Disappearance::Disappearance(const char * id, const char * parent)
     : Sight(id, parent)
{
}

Disappearance::~Disappearance()
{
}

Disappearance Disappearance::Class()
{
    Disappearance value("disappearance", "sight");

    value.setObjtype(std::string("op_definition"));
    
    return value;
}

} } } // namespace Atlas::Objects::Operation

#include <Atlas/Objects/Operation/Sound.h>

using Atlas::Message::Element;

namespace Atlas { namespace Objects { namespace Operation { 

Sound::Sound()
     : Perception("", "sound")
{
}

Sound::Sound(const char * id, const char * parent)
     : Perception(id, parent)
{
}

Sound::~Sound()
{
}

Sound Sound::Class()
{
    Sound value("sound", "perception");

    value.setObjtype(std::string("op_definition"));
    
    return value;
}

} } } // namespace Atlas::Objects::Operation

#include <Atlas/Objects/Operation/Smell.h>

using Atlas::Message::Element;

namespace Atlas { namespace Objects { namespace Operation { 

Smell::Smell()
     : Perception("", "smell")
{
}

Smell::Smell(const char * id, const char * parent)
     : Perception(id, parent)
{
}

Smell::~Smell()
{
}

Smell Smell::Class()
{
    Smell value("smell", "perception");

    value.setObjtype(std::string("op_definition"));
    
    return value;
}

} } } // namespace Atlas::Objects::Operation

#include <Atlas/Objects/Operation/Feel.h>

using Atlas::Message::Element;

namespace Atlas { namespace Objects { namespace Operation { 

Feel::Feel()
     : Perception("", "feel")
{
}

Feel::Feel(const char * id, const char * parent)
     : Perception(id, parent)
{
}

Feel::~Feel()
{
}

Feel Feel::Class()
{
    Feel value("feel", "perception");

    value.setObjtype(std::string("op_definition"));
    
    return value;
}

} } } // namespace Atlas::Objects::Operation

#include <Atlas/Objects/Operation/Error.h>

using Atlas::Message::Element;

namespace Atlas { namespace Objects { namespace Operation { 

Error::Error()
     : Info("", "error")
{
}

Error::Error(const char * id, const char * parent)
     : Info(id, parent)
{
}

Error::~Error()
{
}

Error Error::Class()
{
    Error value("error", "info");

    value.setObjtype(std::string("op_definition"));
    
    return value;
}

} } } // namespace Atlas::Objects::Operation

