#ifndef MESSAGE_VIEW_H
#define MESSAGE_VIEW_H

#include <Client/GLClient.h>
#include <Client/TerrainView.h>
#include <Client/UIStyle.h>

namespace Client
{
   struct MessageLabel
   {
	 Ark::String m_Msg;
	 Ark::String m_Reply;
	 Ark::TexturePtr m_Image;
	 Ark::Entity *m_MyEntity;
	 Ark::Entity *m_DestEntity;
	 
	 Box m_Box;

      public:
	 MessageLabel ();
	 MessageLabel (const Box &bbox,
		       Ark::Entity *my,
		       const Ark::String &msg,
		       Ark::Entity *dest = NULL);

	 MessageLabel (const Box &bbox, const Ark::TexturePtr& image);

	 ~MessageLabel();
		       
	 void Render(UIRenderer *ui);

	 bool HandleMButton (bool down, int b, int x, int y);
   };

   class MessageView
   {
      public:
	 MessageView (UIRenderer *ui);
	 ~MessageView ();

	 void UpdateChildren (UIRenderer *ui, Ark::Entity *ent);
	 void Render(UIRenderer *ui, Ark::Entity *ent);

	 bool HandleMButton (bool down, int b, int x, int y);

      private:
	 Ark::Timer m_Timer;
	 bool m_HasTimeout;

	 Ark::Entity *m_PlayerEntity;

	 std::vector <MessageLabel> m_Children;
	 Style m_Style;
	 Box m_Box;

	 int m_MaxX, m_MinX, m_MinY, m_MaxY;
	 int m_PaddingX, m_PaddingY;
	 Ark::String m_FontQuestion, m_FontAnswer;

	 void AppendChild (UIRenderer *ui,
			   const Ark::String &text,
			   Ark::FontPtr font,
			   int startx,
			   Ark::Entity *ent,
			   Ark::Entity *dest = NULL);
   };

}

#endif
