<?xml version="1.0" encoding="ISO-8859-1" ?>
<!DOCTYPE manualpage SYSTEM "./style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="./style/manual.fr.xsl"?>
<!-- English Revision: 151405 -->
<!-- French translation by Vincent Deffontaines, review by alain B -->

<!--
 Copyright 2005 The Apache Software Foundation or its licensors, as
 applicable.

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="bind.xml.meta">

  <title>Liaison</title>

  <summary>
    <p>Configuration des adresses et ports sur lesquels Apache coute.</p>
  </summary>

  <seealso><a href="vhosts/">Serveurs Virtuels</a></seealso>
  <seealso><a href="dns-caveats.html">Problmes DNS</a></seealso>

  <section id="overview">
    <title>Informations gnrales</title>

    <related>
      <modulelist>
        <module>core</module>
        <module>mpm_common</module>
      </modulelist>
      <directivelist>
        <directive module="core" type="section">VirtualHost</directive>
        <directive module="mpm_common">Listen</directive>
      </directivelist>
    </related>


    <p>Au moment de son dmarrage, Apache se lie  un port et  une 
    adresse sur la machine et se met en attente de requtes entrantes.
    Par dfaut, toutes les adresses de la machine se retrouvent
     l'coute. Dans tous les cas, Apache accepte d'couter sur un
    ou plusieurs ports spcifiques, ou sur une seule ou plusieurs 
    adresses, ou encore une combinaison des deux.
    Il est frquent d'utiliser ces possibilits avec les fonctionnalits
    de Serveurs Virtuels, qui permettent de faire rpondre Apache de
    manire diffrente en fonction de l'adresse IP, du nom ou du port.</p>

    <p>Le serveur utilise la directive 
    <directive module="mpm_common">Listen</directive>
    pour n'accepter que des requtes provenant de ports spcifiques ou 
    d'une combinaison adresse IP + port passs en argument. 
    Dans le cas o seul un port est spcifi avec la directive 
    <directive module="mpm_common">Listen</directive>,
    le serveur se met  l'coute sur le port spcifi, sur toutes
    les interfaces et adresses de la machine. Si une adresse IP est 
    prcise en plus du port, le serveur n'coute que sur l'adresse 
    et le port spcifis. Il est possible de configurer plusieurs 
    directives <directive module="mpm_common">Listen</directive>, 
    afin qu'Apache coute sur plusieurs adresses 
    et ports. Dans ce cas, le serveur rpondra aux requtes faites 
    sur tous les adresses et ports numrs.</p>
    

    <p>Par exemple, pour que le serveur accepte les connexions  la fois sur
    les ports 80 et 8000, spcifiez&nbsp;:</p>

    <example>
      Listen 80<br />
      Listen 8000
    </example>

    <p>Pour qu'Apache accepte les connexions sur deux combinaisons
    adresses + ports, spcifiez&nbsp;:</p>

    <example>
      Listen 192.170.2.1:80<br />
      Listen 192.170.2.5:8000
    </example>

    <p>Les adresses IPv6 sont acceptes, pourvu qu'elles soient entoures 
    entre crochets de la faon suivante&nbsp;:</p>

    <example>
      Listen [fe80::a00:20ff:fea7:ccea]:80
    </example>
  </section>

  <section id="ipv6">
    <title>Prcisions au sujet d'IPv6</title>

    <p>De plus en plus de plates-formes implmentent IPv6, et APR
    supporte IPv6 sur la plupart d'entre elles, si bien qu'Apache
    peut utiliser des sockets IPv6 et rpondre aux requtes envoyes
    en IPv6.</p>

    <p>Une complication possible pour les administrateurs Apache est de
    savoir si un socket IPv6 est capable de grer les connexions IPv4
    aussi bien qu'IPv6. Grer les connexions IPv4 sur une socket IPv6
    suppose l'utilisation d'adresses IPv6 mappes en IPv4, ce qui est
    le cas sur la plupart des plates-formes, mais pas sur FreeBSD, NetBSD
    et OpenBSD, en raison des politiques systmes de ces plates-formes.
    Mme sur des systmes o cette fonctionnalit n'est pas active par
    dfaut, un paramtre de compilation pour <program>configure</program> 
    permet de changer ce comportement pour Apache.</p>
    
    <p>Pour qu'Apache puisse grer  la fois les connexions IPv4 et IPv6
    avec un minimum de sockets, il faut permettre l'utilisation des adresses 
    IPv6 mappes en IPv4, ce qui est faisable en spcifiant l'option
    de compilation <code>--enable-v4-mapped</code> et en utilisant la
    directive gnrique <directive module="mpm_common">Listen</directive> 
    comme suit&nbsp;:</p>

    <example>
      Listen 80
    </example>

    <p>Si <code>--enable-v4-mapped</code> a t spcifi  la compilation,
    les directives Listen de la configuration par dfaut sont de la forme
    ci-dessus. <code>--enable-v4-mapped</code> est l'option de compilation
    par dfaut sur toutes les plates-formes, sauf pour FreeBSD, NetBSD, et 
    OpenBSD, donc il est probable que votre Apache ait t compil avec
    cette option.</p>

    <p>Pour qu'Apache ne gre que les connexions IPv4, en ignorant l'ventuel
    support IPv6 de la plate-forme ou d'APR, une adresse IPv4 peut tre
    donne dans toutes les directives 
    <directive module="mpm_common">Listen</directive>, comme dans les 
    exemples suivants&nbsp;:</p>

    <example>
      Listen 0.0.0.0:80<br />
      Listen 192.170.2.1:80
    </example>

    <p>Pour qu'Apache gre les connexions IPv4 et IPv6 sur des sockets
    diffrents (i.e., pour ne pas accepter les adresses IPv6 mappes
    en IPv4), spcifiez l'option de compilation 
    <code>--disable-v4-mapped</code> et utilisez des directives 
    Listen spcifiques telles que&nbsp;:</p>

    <example>
      Listen [::]:80<br />
      Listen 0.0.0.0:80
    </example>

    <p>Si le paramtre <code>--disable-v4-mapped</code> a t dfini 
    au moment de la compilation, les directives Listen de la 
    configuration par dfaut sont de la forme ci-dessus.
    <code>--disable-v4-mapped</code> est l'option de 
    compilation par dfaut sous FreeBSD, NetBSD, et OpenBSD.</p>

  </section>

  <section id="virtualhost">
    <title>Faire fonctionner tout ceci avec les Serveurs Virtuels</title>

    <p>La directive <directive module="mpm_common">Listen</directive> 
    n'implmente aucun Serveur Virtuel. Elle sert simplement  
    indiquer au serveur principal sur quels adresses et ports couter.
    Dans le cas o aucune section 
    <directive module="core" type="section">VirtualHost</directive>
    n'est utilise, le serveur rpondra de la mme manire pour toutes
    les requtes qu'il recevra.
    Des sections 
    <directive module="core" type="section">VirtualHost</directive>
    peuvent tre utilises pour qu'Apache ragisse diffremment selon que la
    requte est destine  telle adresse ou  tel port. Avant d'implmenter
    un Serveur Virtuel au moyen de la directive VirtualHost, la directive
    Listen doit tre configure pour que le serveur coute sur l'adresse
    ou le port utilis. Ensuite, une section 
    <directive module="core" type="section">VirtualHost</directive>
    devrait tre utilise pour qu'Apache ragisse diffremment selon
    l'adresse ou le port.
     noter que si un Serveur Virtuel 
    <directive module="core" type="section">VirtualHost</directive> 
    est configur sur une adresse et un port sur lesquels le serveur 
    n'est pas  l'coute, le Serveur Virtuel ne sera pas accessible.</p>
  </section>
</manualpage>


