/* $Id: wmprop.c,v 1.7 2000/10/30 20:25:19 komatsu Exp $ */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <X11/Xproto.h>
#include <X11/Xatom.h>

#include "wmmain.h"
#include "wmprop.h"

gchar *wm_prop_get_WMName(WmClient *client)
{
    XTextProperty xtp;
    gchar         **cl;
    gchar         *title;
    int           n = 0;
    
    if(XGetWMName(GDK_DISPLAY(), client->client, &xtp)) {
	XmbTextPropertyToTextList(GDK_DISPLAY(), &xtp, &cl, &n);
    }
    if(n > 0) {
	title = g_strdup(cl[0]);
	XFreeStringList(cl);
    } else {
	title = g_strdup("NO TITLE");
    }
    if(xtp.value) {
	XFree(xtp.value);
    }
    return title;
}

gchar *wm_prop_get_WMIconName(WmClient *client)
{
    gchar *icon;

    if(XGetIconName(GDK_DISPLAY(), WM_CLIENT_XWINDOW(client), &icon)) {
	return icon;
    } else {
	return g_strdup("NO ICON");
    }
}

Window wm_prop_get_WMClientLeader(WmClient *client)
{
    Window window = client->client;
    Atom actual_type;
    int actual_format;
    unsigned long nitems, bytesafter;
    unsigned char *client_leader;
    Window return_value;

    wm_message("WmProp[%x]: get WMClientLeader\n", window);

    /*
     *  XXX: XGetWindowProperty() Τ褤åѡо줷֤.
     *       gdk_property_get() ϻȤʤۤɤ餷.
     */
    if(XGetWindowProperty(GDK_DISPLAY(), window, wm_atom_wm_client_leader,
			  0L, 1L, False, XA_WINDOW,
			  &actual_type, &actual_format, &nitems, &bytesafter,
			  &client_leader) != Success || !client_leader) {
	return WM_GROUP_NO_LEADER;
    }
    return_value = *(Window *)client_leader;
    XFree(client_leader);
    return return_value;
}

int wm_prop_get_WMState(WmClient *client)
{
    /* WM_STATE ¤ΤΥФ state(CARD32)  icon(WINDOW) 뤬
     * state ͤΤߤ֤. ɬפˤʤä, ؿ̾ޤƻͤѹ
     */
    Window window = client->client;
    Atom actual_type;
    int actual_format;
    unsigned long nitems, bytesafter;
    unsigned char *wm_state;
    int return_value;

    wm_message("WmProp[%x]: get WMState\n", window);

    if(XGetWindowProperty(GDK_DISPLAY(), window, wm_atom_wm_state,
			  0L, 1L, False, wm_atom_wm_state,
			  &actual_type, &actual_format, &nitems, &bytesafter,
			  &wm_state) != Success || !wm_state) {
	/* NormalState ֤⤷ʤ */
	return WithdrawnState;
    }
    return_value = (int)((unsigned long *)wm_state)[0];
    XFree(wm_state);
    return return_value;
}

int wm_prop_init_WMClass(WmClient *client)
{
    XClassHint class_hints;

    if (XGetClassHint(GDK_DISPLAY(), client->client, &class_hints)) {
	client->name  = class_hints.res_name;
	client->class = class_hints.res_class;
	return TRUE;
    } else {
	return FALSE;
    }
}


