# ---------------------------------------------------------------------------
# - t_7007.als                                                              -
# - aleph:net library test module                                           -
# ---------------------------------------------------------------------------
# - This program is free software;  you can redistribute it  and/or  modify -
# - it provided that this copyright notice is kept intact.                  -
# -                                                                         -
# - This program  is  distributed in  the hope  that it will be useful, but -
# - without  any  warranty;  without  even   the   implied    warranty   of -
# - merchantability or fitness for a particular purpose.  In no event shall -
# - the copyright holder be liable for any  direct, indirect, incidental or -
# - special damages arising in any way out of the use of this software.     -
# ---------------------------------------------------------------------------
# - copyright (c) 1999-2003 amaury darsch                                   -
# ---------------------------------------------------------------------------

# @info   tcp option test module
# @author amaury darsch

# get the library
interp:library "aleph-net"
interp:library "aleph-sys"

# check socket enumerated item
assert "DONT-ROUTE"          (aleph:net:Socket:DONT-ROUTE:to-string)
assert "KEEP-ALIVE"          (aleph:net:Socket:KEEP-ALIVE:to-string)
assert "LINGER"              (aleph:net:Socket:LINGER:to-string)
assert "RCV-SIZE"            (aleph:net:Socket:RCV-SIZE:to-string)
assert "SND-SIZE"            (aleph:net:Socket:SND-SIZE:to-string)
assert "HOP-LIMIT"           (aleph:net:Socket:HOP-LIMIT:to-string)
assert "MULTICAST-LOOPBACK"  (aleph:net:Socket:MULTICAST-LOOPBACK:to-string)
assert "MULTICAST-HOP-LIMIT" (aleph:net:Socket:MULTICAST-HOP-LIMIT:to-string)
assert "MAX-SEGMENT-SIZE"    (aleph:net:Socket:MAX-SEGMENT-SIZE:to-string)
assert "NO-DELAY"            (aleph:net:Socket:NO-DELAY:to-string)


# create a tcp socket object
const tcp (aleph:net:TcpSocket)

# set some options
assert true (tcp:set-option aleph:net:Socket:REUSE-ADDRESS true)
assert true (tcp:set-option aleph:net:Socket:DONT-ROUTE    true)
assert true (tcp:set-option aleph:net:Socket:KEEP-ALIVE    true)
assert true (tcp:set-option aleph:net:Socket:LINGER        true 10)
assert true (tcp:set-option aleph:net:Socket:RCV-SIZE      1024)
assert true (tcp:set-option aleph:net:Socket:SND-SIZE      2084)
assert true (tcp:set-option aleph:net:Socket:HOP-LIMIT     10)
assert true (tcp:set-option aleph:net:Socket:NO-DELAY      true)

# create a udp socket
const udp (aleph:net:UdpSocket)

# set some options
assert true (udp:set-option aleph:net:Socket:REUSE-ADDRESS  true)
assert true (udp:set-option aleph:net:Socket:BROADCAST      true)
assert true (udp:set-option aleph:net:Socket:DONT-ROUTE     true)
assert true (udp:set-option aleph:net:Socket:RCV-SIZE       1024)
assert true (udp:set-option aleph:net:Socket:SND-SIZE       2084)
assert true (tcp:set-option aleph:net:Socket:HOP-LIMIT      10)
