//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

//Systemwide includes
#include <qfile.h>
#include <qtextstream.h>
#include <qstringlist.h>
#include <qnamespace.h>
#include <qkeysequence.h>

//Projectwide includes
#include "whatsNew.h"
#include "helpWindow.h"
#include "../../config.h"

//==============================================
QString WhatsNew::filename()
{
  return QString("%1/whatsNew.html").arg(TEMP_DIR);
}
//==============================================
void WhatsNew::generateHTML(QTextStream::Encoding type, QString charSet)
{

  QString whatsNew = HelpWindow::tr("What's New in Album Shaper %1");
  
  //create/open html file
  QFile file( filename() );
  if(file.open(IO_WriteOnly))
  {
    //-----
    QTextStream stream;
    stream.setEncoding( type );
    stream.setDevice( &file );
    //-----
    stream << "<html><head>\n";
    stream << "<meta http-equiv='Content-Type' content='text/html; charset=" << charSet << "'>\n";
    stream << "</head><body>\n";

    
    //-------------------------------------------------------------
    // Album Shaper 2.1 Improvements
    //-------------------------------------------------------------
    stream << "<table cellpadding='4'><tr>\n";
    stream << "  <td><img src='" << IMAGE_PATH << "helpImages/asHelpLogoSmall.png'></td>\n";
    stream << "  <td valign='middle'><font face='Arial, sans-serif' size='+3'>";
    stream << whatsNew.arg(ALBUMSHAPER_VERSION);
    stream << "</font></td>\n";
    stream << "</tr></table>\n";

    
    
    stream << "<font face='Arial, sans-serif'>\n";
    stream << "<table cellspacing='10' cellpadding='0'><tr><td>\n";
    
    stream << "<table width='100%' cellpadding='4' cellspacing='0'><tr><td bgcolor='lightgray'>\n";
    stream << "<font size='+1'><b>" << HelpWindow::tr("New Features / Feature Enhancements:") << "</b></font>\n";
    stream << "</td></tr></table>\n";
    stream << "<ul>\n";
    item( stream, HelpWindow::tr("New mosaic manipulation!"));
    item( stream, HelpWindow::tr("Aspect ratio selection usability improvements (smarter placement with regard to rotating selections, positioning, and support for tall photos)"));
    item( stream, HelpWindow::tr("Improved B/W and Sepia effects (weights now based on modern display phosphor characteristics)"));
    item( stream, HelpWindow::tr("Added French translation"));
    item( stream, HelpWindow::tr("German translation brought up to date"));
    stream << "</ul>\n";

    stream << "<table width='100%' cellpadding='4' cellspacing='0'><tr><td bgcolor='lightgray'>\n";
    stream << "<font size='+1'><b>" << HelpWindow::tr("Minor Improvements:") << "</b></font>\n";
    stream << "</td></tr></table>\n";
    stream << "<ul>\n";
    item( stream, HelpWindow::tr("Rewrote AlbumShaper.pro project file to support changing install location on Unix systems"));
    item( stream, HelpWindow::tr("Changed \"Disable checking for...\" checkbox to \"Check for photo modifications...\" under settings"));
    item( stream, HelpWindow::tr("Cut down window and dialog title text by removing \"Album Shaper: \" prefix"));
    item( stream, HelpWindow::tr("Fixed alert dialogs to handle long message translations"));
    item( stream, HelpWindow::tr("Various spelling mistakes and other minor visible text improvements"));
    item( stream, HelpWindow::tr("Fixed fonts in status area and various dialogs"));
    item( stream, HelpWindow::tr("Cosmetic fixes regarding buttons and layout in Save as dialog"));
    item( stream, HelpWindow::tr("Added missing red color to some button references in help system"));
    stream << "</ul>\n";

    stream << "<table width='100%' cellpadding='4' cellspacing='0'><tr><td bgcolor='lightgray'>\n";
    stream << "<font size='+1'><b>" << HelpWindow::tr("Bug Fixes:") << "</b></font>\n";
    stream << "</td></tr></table>\n";
    stream << "<ul>\n";

    item( stream, HelpWindow::tr("Fixed a bug where dropping objects from the desktop / file browsers on album / collection image caused Album Shaper to crash"));
    item( stream, HelpWindow::tr("Fixed a bug where Album Shaper would crash when trying to edit 8 bit grayscale and color images"));
    item( stream, HelpWindow::tr("Fixed a bug where after removing photos in a collection the edit tab and various buttons below were still enabled"));
    item( stream, HelpWindow::tr("Fixed a threading bug in the file preview feature that could cause the program to hang"));
    item( stream, HelpWindow::tr("Fixed the rare 0kb bug! (reverting a photo sometimes caused the photo to be corrupted)"));
    item( stream, HelpWindow::tr("Disabled user input while loading albums"));
    item( stream, HelpWindow::tr("Fixed a bug where loading recent albums using the keyboard shortcuts could cause Album Shaper to crash"));
    item( stream, HelpWindow::tr("Fixed a bugs where using save-as to copy an album from one location to another did not copy over the original form of an image"));
    item( stream, HelpWindow::tr("Fixed minor bug in Slick theme where carriage returns in photo descriptions caused problems in slide show mode"));
    item( stream, HelpWindow::tr("Fixed a bug in the Metallic theme where collections that had no cover images could not be reached using the navigation bar"));
    item( stream, HelpWindow::tr("Fixed various compiler warnings under Linux / FreeBSD"));
    stream << "</ul>\n";
    
    stream << "</td></tr>\n";
    stream << "</table></font>\n";

    
    
    //-------------------------------------------------------------
    // Album Shaper 2 Improvements
    //-------------------------------------------------------------
    stream << "<table cellpadding='4'><tr>\n";
    stream << "  <td><img src='" << IMAGE_PATH << "helpImages/asHelpLogoSmall.png'></td>\n";
    stream << "  <td valign='middle'><font face='Arial, sans-serif' size='+3'>";
    stream << whatsNew.arg(2);
    stream << "</font></td>\n";
    stream << "</tr></table>\n";

    stream << "<font face='Arial, sans-serif'>\n";
    stream << "<table cellspacing='10' cellpadding='0'><tr><td>\n";

    stream << "<table width='100%' cellpadding='4' cellspacing='0'><tr><td bgcolor='lightgray'>\n";
    stream << "<font size='+1'><b>" << HelpWindow::tr("Importing and Organizing:") << "</b></font>\n";
    stream << "</td></tr></table>\n";
    stream << "<ul>\n";
    item( stream, HelpWindow::tr("Much faster image resizing, enabling you to quickly add photos to your albums"));
    item( stream, HelpWindow::tr("During add photos/batch operations, the number of remaining items is included in a status message"));
    item( stream, HelpWindow::tr("Smaller album sizes and better EXIF support"));
    item( stream, HelpWindow::tr("Add photo preview and detail in add photos dialog"));
    stream << "</ul>\n";

    stream << "<table width='100%' cellpadding='4' cellspacing='0'><tr><td bgcolor='lightgray'>\n";
    stream << "<font size='+1'><b>" << HelpWindow::tr("Rewritten Editing Interface:") << "</b></font>\n";
    stream << "</td></tr></table>\n";
    stream << "<ul>\n";
    item( stream, HelpWindow::tr("Much faster lossless rotating and flipping transformations"));
    item( stream, HelpWindow::tr("Semi-automatic tilt correction tool"));
    item( stream, HelpWindow::tr("Automatic color enhancement tool"));
    item( stream, HelpWindow::tr("Automatic contrast enhancement tool"));
    item( stream, HelpWindow::tr("Sophisticated red-eye reduction tool"));
    item( stream, HelpWindow::tr("Histogram interface for changing brightness, contrast, and color and luminosity levels"));
    item( stream, HelpWindow::tr("Grain editor for blurring and sharpening images"));
    item( stream, HelpWindow::tr("Sepia, oil painting, and color embossing image manipulations"));
    item( stream, HelpWindow::tr("Crop, B+W, and invert manipulations rewritten and significantly faster"));
    item( stream, HelpWindow::tr("Real time previews of image manipulations"));
    item( stream, HelpWindow::tr("Crop to preset aspect ratios or current display resolution"));
    item( stream, HelpWindow::tr("DPI indicated with green/red coloring and text when cropping to preset image sizes"));
    item( stream, HelpWindow::tr("Selected regions can be adjusted by dragging any side, corner, or entire selection around"));
    item( stream, HelpWindow::tr("Selected regions can be rotated and scaled in place while maintaining their aspect ratio"));
    item( stream, HelpWindow::tr("Selected regions can be nudged left/right/up/down using arrow keys"));
    item( stream, HelpWindow::tr("New selection painting system enhances contrast to make selections stand out"));
    item( stream, HelpWindow::tr("Selection resolutions are displayed, letting you crop to exact sizes"));
    item( stream, HelpWindow::tr("Photos can be rotated and flipped within editing interface"));
    item( stream, HelpWindow::tr("Busy indicators and progress bar for all non-instantaneous operations within editing interface"));
    item( stream, HelpWindow::tr("Double click any photo to edit"));
    item( stream, HelpWindow::tr("Switch photos while in editing interface"));
    item( stream, HelpWindow::tr("Photo modifications always reversible"));
    stream << "</ul>\n";

    stream << "<table width='100%' cellpadding='4' cellspacing='0'><tr><td bgcolor='lightgray'>\n";
    stream << "<font size='+1'><b>" << HelpWindow::tr("Loading, Saving, and Exporting:") << "</b></font>\n";
    stream << "</td></tr></table>\n";
    stream << "<ul>\n";
    item( stream, HelpWindow::tr("Quickly load albums using the new <font color='red'>Open Recent</font> menu"));
    item( stream, HelpWindow::tr("Revert to last saved album"));
    item( stream, HelpWindow::tr("Set desktop wallpaper with the click of a button"));
    item( stream, HelpWindow::tr("Export small web galleries"));
    item( stream, HelpWindow::tr("Export images for printing"));
    stream << "</ul>\n";

    stream << "<table width='100%' cellpadding='4' cellspacing='0'><tr><td bgcolor='lightgray'>\n";
    stream << "<font size='+1'><b>" << HelpWindow::tr("Bug Fixes:") << "</b></font>\n";
    stream << "</td></tr></table>\n";
    stream << "<ul>\n";
    item( stream, HelpWindow::tr("Windows 95, 98 and ME now experimentally supported"));
    item( stream, HelpWindow::tr("Files ending with .HTM are now removed during save"));
    item( stream, HelpWindow::tr("qmake does not need to be run a second time before doing a make install on Linux/FreeBSD"));
    item( stream, HelpWindow::tr("Close button on the Album Statistics window now displayed properly"));
    item( stream, HelpWindow::tr("Support for Norwegian variant of Windows"));
    item( stream, HelpWindow::tr("Expanding and contracting a photo with an empty description no longer trips album modified bit"));
    item( stream, HelpWindow::tr("Fixed bug involving progress messages erratically disappearing next to progress bar"));
    item( stream, HelpWindow::tr("Flip vertical and flip horizontal button images swapped to properly reflect these actions"));
    item( stream, HelpWindow::tr("Selection bugs in editing interface fixed with complete rewrite of selection system"));
    item( stream, HelpWindow::tr("Albums can now be loaded/saved to paths that contain spaces"));
    item( stream, HelpWindow::tr("Command-M now minimizes application to the Dock on Mac OSX"));
    item( stream, HelpWindow::tr("Plugged various memory leaks"));
    item( stream, HelpWindow::tr("Fixed horizontal scrollbars showing when expanding photos"));
    item( stream, HelpWindow::tr("Fixed hang when user expands photo then switches to a different apps"));
    item( stream, HelpWindow::tr("Fixed minor painting mistakes when editing photo descriptions"));
    item( stream, HelpWindow::tr("Photos added to collections through drag and drop are now inserted in the correct order."));
    item( stream, HelpWindow::tr("Fixed many problems which resulted from photo and album paths including accented characters."));
    item( stream, HelpWindow::tr("Fixed various glitches that occured when rearranging photos within collections."));
    
    stream << "</ul>\n";
    
    stream << "</td></tr>\n";
    stream << "</table></font>\n";

    
    //-------------------------------------------------------------
    stream << "</body></html>\n";
    file.close();
  }
}
//==============================================
void WhatsNew::item( QTextStream& stream, QString item )
{
  stream << "<li>" << item << "\n";
}
//==============================================


