//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

//Systemwide includes
#include <qfile.h>
#include <qstringlist.h>

//Projectwide includes
#include "contents.h"
#include "../../config.h"

#define LINK_COLOR "#0a92dd"
#define CURR_COLOR "#0e3980"

//==============================================
Contents::Contents( QTextStream::Encoding type, 
                    QString saveCharSet, QMimeSourceFactory* loadingMimeSource,
                    QWidget* parent, const char* name ) : QTextBrowser(parent,name)
{
  this->type = type;
  this->saveCharSet = saveCharSet;
  this->setMimeSourceFactory( loadingMimeSource );
  
  //generate HTML
  currentPage = BILLBOARD;
  generateHTML(type, saveCharSet);
  //--
  //set browser and load contents
  setHScrollBarMode( QScrollView::AlwaysOff );
  setVScrollBarMode( QScrollView::AlwaysOff );
  setFrameStyle( QFrame::NoFrame );
  setSource( filename() );
  
  //------
  //determine optimal size
  int minH = heightForWidth( 1000 );
  int w;
  for(w=1; w<1000; w++)
  {
    if(heightForWidth(w) == minH ) break;
  }
  
  optimalSize = QSize( w, heightForWidth(w) ); 
  //------
  //handle anchor clicks
  connect( this, SIGNAL(anchorClicked(const QString&, const QString&)),
           this, SLOT(handleAnchorClick(const QString&, const QString&)) );
  //------
}
//==============================================
QSize Contents::minimumSizeHint() const
{
  return optimalSize;
}
//==============================================                              
void Contents::handleAnchorClick(const QString &name, const QString&)
{
  HELP_PAGE nextPage = INVALID;  

  //only handle clicking on anchors with actual names
  if( name.isNull() ) return;
  else if(name.compare("WHATS_NEW") == 0) 
    nextPage = WHATS_NEW;
  else if(name.compare("IMPORTING_AND_ORGANIZING") == 0) 
    nextPage = IMPORTING_AND_ORGANIZING;
  else if(name.compare("ANNOTATING_ALBUMS") == 0) 
    nextPage = ANNOTATING_ALBUMS;
  else if(name.compare("FRAMING") == 0) 
    nextPage = FRAMING;
  else if(name.compare("ENHANCING") == 0) 
    nextPage = ENHANCING;
  else if(name.compare("PRO_TOOLS") == 0) 
    nextPage = PRO_TOOLS;
  else if(name.compare("MANIPULATING") == 0) 
    nextPage = MANIPULATING;
  else if(name.compare("SAVING_AND_LOADING") == 0) 
    nextPage = SAVING_AND_LOADING;
  else if(name.compare("KEYBOARD_SHORTCUTS") == 0) 
    nextPage = KEYBOARD_SHORTCUTS;

  if(nextPage != INVALID)
  {
    currentPage = nextPage;
    generateHTML(type, saveCharSet);
    reload();
    emit setPage( currentPage );
  }
}
//==============================================
QString Contents::filename()
{
  return QString("%1/helpContents.html").arg(TEMP_DIR);
}
//==============================================                              
void Contents::generateHTML(QTextStream::Encoding type, QString charSet)
{
  //create/open html file
  QFile file( filename() );
  if(file.open(IO_WriteOnly))
  {
    //-----
    QTextStream stream;
    stream.setEncoding( type );
    stream.setDevice( &file );
    //-----
    stream << "<html><head>\n";
    stream << "<meta http-equiv='Content-Type' content='text/html; charset=" << charSet << "'>\n";
    stream << "</head><body>\n";
    stream << "<center><table><tr><td>\n";
    stream << "<font face='Arial, sans-serif' size='+1'><b>\n";
    //-----    
    printLink( stream, QString(tr("What's New")), WHATS_NEW, "WHATS_NEW" );
    //-----    
    stream << "<p>" << tr("Tutorials:") << "\n";
    //------    
    stream << "<font size='+0'><ul>\n";

    stream << "<li>\n";
    printLink( stream, QString(tr("Import & Organize")), 
               IMPORTING_AND_ORGANIZING, "IMPORTING_AND_ORGANIZING" );
    //------    
    stream << "<li>\n";
    printLink( stream, QString(tr("Annotating Albums")), 
               ANNOTATING_ALBUMS, "ANNOTATING_ALBUMS" );
    //------    
    stream << "<li>" << tr("Editing Photos:") << "\n";

    stream << "<ol>\n";
    stream << "<li>\n";
    printLink( stream, QString(tr("Framing")), 
               FRAMING, "FRAMING" );
    
    stream << "<li>\n";
    printLink( stream, QString(tr("Fix it Fast")), 
               ENHANCING, "ENHANCING" );
    
    stream << "<li>\n";
    printLink( stream, QString(tr("Pro Tools")), 
               PRO_TOOLS, "PRO_TOOLS" );

    stream << "<li>\n";
    printLink( stream, QString(tr("Manipulations")), 
               MANIPULATING, "MANIPULATING" );
    stream << "</ol>\n";
    //------    
    stream << "<li>\n";
    printLink( stream, QString(tr("Saving & Loading")), 
               SAVING_AND_LOADING, "SAVING_AND_LOADING" );
    //------    
    stream << "</ul></font>\n";
    //------    
    printLink( stream, QString(tr("Keyboard Shortcuts")), KEYBOARD_SHORTCUTS, "KEYBOARD_SHORTCUTS" );
    //------    
    stream << "</b></font>\n";
    stream << "</td></tr></table></center>\n";
    stream << "</body></html>\n";
    file.close();
  }
}
//==============================================
void Contents::printLink( QTextStream& stream, QString text, HELP_PAGE anchor, QString anchorString )
{
  if( currentPage != anchor ) 
  {
    stream << "<font color='" << LINK_COLOR << "'>";
    stream << "<a name='" << anchorString << "'>";
  }
  else
  {
    stream << "<font color='" << CURR_COLOR << "'>";
  }

  stream << text << "\n";
  
  if( currentPage != anchor ) 
  {
    stream << "</a>";
  }
  stream << "</font>\n";
}
//==============================================                              
