	<xsl:stylesheet
     xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
     version="1.0">

<!-- ####################################### -->
<!-- ####################################### -->
<!-- Creates an HTML coverpage for the album -->
<xsl:template match="album" mode="coverpage">
<xsl:variable name="albumAuthor" select="author"/>

<xsl:document method="html" indent="yes" href="{concat($outputPath, '/Album.html')}"> 
<html>
  <head>
    <meta name="generator" content="Album Shaper (c.) Will Stokes"/>
    <meta name="theme" content="{$themeString}" />
    <meta name="author" content="{$albumAuthor}" />

    <link rel="stylesheet" href="resources/style.css" type="text/css" />
    
    <title><xsl:value-of select="name"/></title>
  </head>
  <body bgcolor="white" text="black" link="#0000FF" vlink="#0000FF" alink="#FF0000">
<center>
    <table border="0" cellpadding="0" cellspacing="0">

<!-- ####################################### -->
<!-- Begin border, place rounded left, then horizontal, then rounded right corners on -->
<!-- ####################################### -->
<tr>
  <td style="background-image: url(resources/topLeft.png);" width="16" height="16"></td>
  <td style="background-image: url(resources/horizontal.png); background-repeat:repeat-x;" height="16"></td>
  <td style="background-image: url(resources/topRight.png);" width="16" height="16"></td>
</tr>

<!-- ####################################### -->
<!-- Next place a vertical border left, then the center region with album -->
<!-- image and description, then a vertical border right -->
<!-- ####################################### -->
<tr>
  <td style="background-image: url(resources/vertical.png); background-repeat:repeat-y;" width="16"></td>
  <td width="600">
    <xsl:if test="thumb">
      <xsl:variable name="albumThumbnail" select="thumb/@path"/>
      <center>       
        <img src="{$albumThumbnail}" alt="Representative Album Image"/>
      </center>
    </xsl:if>
    <center>

<table border="0"><tr>
<td width="180"><div class="title"><xsl:value-of select="name"/></div></td>
<td><div class="subtitle"><xsl:value-of select="description"/></div></td>
</tr></table>

    </center>
  </td>
  <td style="background-image: url(resources/vertical.png); background-repeat:repeat-y;" width="16"> </td>
</tr>

<!-- ####################################### -->
<!-- now place all subalbum images with appropriate borders around them -->
<!-- ####################################### -->
<tr>
  <td style="background-image: url(resources/vertical.png); background-repeat:repeat-y;" width="16"></td>
  <td><table border="0" width="100%" cellpadding="0"><tr valign="middle">

<xsl:variable name="thumbWidth" select="substring-before(thumbnailDimensions, ' ')"/>
<xsl:variable name="thumbHeight" select="substring-after(thumbnailDimensions, ' ')"/> 
  
 <xsl:for-each select="subalbum">
   <xsl:variable name="subalbumNumber" select="position()"/>
          <td width="220" align="center">                  
            <table border="0" cellpadding="0">
              <tr>
                <td valign="top" align="center">
                  <xsl:if test="thumb">
                    <xsl:variable name="subalbumThumbnail" select="thumb/@path"/>
                    <center>
                      <script type="text/javascript" language="JavaScript">
                        <![CDATA[
                        <!-- HIDE FROM OLD BROWSERS
                        ]]>
                        
                        <xsl:if test="count(photo)">
                        <![CDATA[                                              
                        document.write("<a href=\"subalbum_]]><xsl:value-of select="position()"/><![CDATA[_slideshow.html\">")
                        ]]>
                        </xsl:if>
                        
                        <![CDATA[                                              
                        document.write("  <img border=\"2\" alt=\"Subalbum ]]><xsl:value-of select="position()"/><![CDATA[\" src=\"]]><xsl:value-of select="$subalbumThumbnail"/><![CDATA[\"/>")
                        ]]>
                        
                        <xsl:if test="count(photo)">
                        <![CDATA[                                                                      
                        document.write("</a>")
                        ]]>
                        </xsl:if>
                        
                        <![CDATA[                                                                                            
                        -->
                        ]]>
                      </script>

                      <noscript>
                        <xsl:if test="count(photo)">                                                                 
                          <a href="subalbum_{$subalbumNumber}_thumbs.html"><img border="2" src="{$subalbumThumbnail}"/></a>
                        </xsl:if>
                        <xsl:if test="count(photo)=0">                                                                 
                          <img src="{$subalbumThumbnail}"/>
                        </xsl:if>                
                      </noscript>

                    </center>
                  </xsl:if>
                </td>
              </tr>
              <tr>
                <td valign="bottom" align="center">
                  <center>
                    <script type="text/javascript" language="JavaScript">
                      <![CDATA[
                          <!-- HIDE FROM OLD BROWSERS
                        ]]>
                                      
                      <xsl:if test="count(photo)">                       
                      <![CDATA[ document.write("<a href=\"subalbum_]]><xsl:value-of select="position()"/><![CDATA[_slideshow.html\">")  ]]>
                     </xsl:if>
                      
                      <![CDATA[ document.write("<div class=\"item\">]]><xsl:value-of select="name"/><![CDATA[</div>") ]]>
                        
                      <xsl:if test="count(photo)">                       
                        <![CDATA[ document.write("</a>") ]]>
                     </xsl:if>                  
                      
                      <![CDATA[ --> ]]>
                    </script>
                    <noscript>
                      <div class="item">
                        <xsl:if test="count(photo)"><a href="subalbum_{$subalbumNumber}_thumbs.html"><xsl:value-of select="name"/></a></xsl:if>
                        <xsl:if test="count(photo)=0"><xsl:value-of select="name"/></xsl:if>                
                      </div>
                    </noscript>
                  </center>
                </td>
              </tr>
            </table>
          </td>

          <xsl:if test="not(position() mod 3)">
            <xsl:text disable-output-escaping="yes"> &lt;/tr&gt;&lt;tr valign="middle"&gt;</xsl:text>
          </xsl:if>

        </xsl:for-each>

        <xsl:call-template name="endRow">
          <xsl:with-param name="cellsLeft" select="(3 - (count(subalbum) mod 3))"/>
        </xsl:call-template>

        </tr></table></td>
        <td style="background-image: url(resources/vertical.png); background-repeat:repeat-y;" width="16"></td>
        </tr>

<!-- ####################################### -->
<!-- Now place a horizontal separator border. Depending on -->
<!-- how many subalbums there are the splitters will need to be adjusted -->
<!-- ####################################### -->
<tr>
  <td style="background-image: url(resources/leftJoint.png);" width="16" height="16"></td>
  <td style="background-image: url(resources/horizontal.png); background-repeat:repeat-x;" height="16"></td>
  <td style="background-image: url(resources/rightJoint.png);" width="16" height="16"></td>
</tr>

<tr height="40">
  <td style="background-image: url(resources/vertical.png); background-repeat:repeat-y;" width="16"></td>
  <td width="600" valign="middle" align="center">

  <table border="0"><tr>
    <td>
      <div class="pageDetails">
      <xsl:variable name="Cyear" select="substring-before(created, ' ')"/>
      <xsl:variable name="Cmonth" select="substring-before( substring-after(created, ' '), ' ')"/>
      <xsl:variable name="Cday" select="substring-after( substring-after(created, ' '), ' ')"/>
      <xsl:variable name="Myear" select="substring-before(modified, ' ')"/>
      <xsl:variable name="Mmonth" select="substring-before( substring-after(modified, ' '), ' ')"/>
      <xsl:variable name="Mday" select="substring-after( substring-after(modified, ' '), ' ')"/>
      Generated on <xsl:value-of select="$Mmonth"/>/<xsl:value-of select="$Mday"/>/<xsl:value-of select="$Myear"/>
      for <xsl:value-of select="author"/> by
      </div>
    </td>
    <td>
      <table border="0">
        <tr>
          <td rowspan="2">
            <a href="http://albumshaper.sourceforge.net">
              <img src="resources/asLogo.png" border="0"/>
            </a>
           </td>
           <td><div class="pageDetails"><a href="http://albumshaper.sourceforge.net">Album Shaper</a></div></td>
        </tr>
        <tr>
          <td><div class="pageDetails">Slick theme</div></td>
        </tr>
      </table>
    </td>
  </tr></table>


  </td>
  <td style="background-image: url(resources/vertical.png); background-repeat:repeat-y;" width="16"></td>
</tr>

<!-- ####################################### -->
<!-- Now place a bottom border. -->
<!-- ####################################### -->
<tr>
  <td style="background-image: url(resources/bottomLeft.png);" width="16" height="16"></td>
  <td style="background-image: url(resources/horizontal.png); background-repeat:repeat-x;" height="16"></td>
  <td style="background-image: url(resources/bottomRight.png);" width="16" height="16"></td>
</tr>

      </table>
    </center>
  </body>
</html>
</xsl:document>
</xsl:template>
<!-- ####################################### -->
<!-- ####################################### -->

</xsl:stylesheet>
