#include "Agenda.h"

@class CalendarEventModel;
@class CalendarEventModelManager;

@protocol CalendarEventModel
- (void) calendarEventModel:(CalendarEventModel *)model
		 didUpdateStartDate:(NSCalendarDate *)startDate
			   timeInterval:(NSTimeInterval)time;
- (void) calendarEventModelWillBeFreed:(id)model;
@end

@protocol CalendarEventModelManager
- (void) calendarEventModelManager:(CalendarEventModelManager *)manager
					   didAddModel:(CalendarEventModel *)model;
@end

@interface CalendarEventModel : NSObject
{
	NSMutableSet *_observers;

	NSCalendarDate *_startDate;
	NSTimeInterval _stopTime;
	NSCalendarDate *_createDate;
	NSCalendarDate *_modifyDate;

	NSString *_string;
}

- (void) addObserver:(id)observer;
- (void) removeObserver:(id)observer;

- (void) setStartDate:(NSCalendarDate *)startDate
		 timeInterval:(NSTimeInterval)stopTime;
- (void) setTimeInterval:(NSTimeInterval)stopTime;
- (NSCalendarDate *) startDate;
- (NSTimeInterval) timeInterval;
- (NSCalendarDate *) stopDate;
- (NSCalendarDate *) modifyDate;
- (NSCalendarDate *) createDate;
- (NSComparisonResult) compare:(CalendarEventModel *)otherModel;
- (void) setStringValue:(NSString *)string;
- (NSString *) stringValue;
@end

@interface CalendarEventModelManager : NSObject
{
	NSMutableArray *_events;
	NSMutableSet *_observers;
}

- (CalendarEventModel *) modelWithStartDate:(NSCalendarDate *)startDate
								   stopTime:(NSTimeInterval)stopTime
								   observer:(id)observer;

- (void) addObserver:(id <CalendarEventModelManager>)observer;
- (void) removeObserver:(id)observer;

- (NSArray *) allEvents;
- (NSArray *) allEventsWithString:(NSString *)str;
- (NSArray *) allEventsDuringDate:(NSCalendarDate *)startDate
						  andDate:(NSCalendarDate *)stopDate;
@end
