#include "CalendarController.h"
#include "CalendarEventView.h"

@interface MyBrowserCell : NSBrowserCell
{
	id event;
}
@end

@implementation MyBrowserCell
- (void) setEvent:(id)ev
{
	ASSIGN(event, ev);
}

- (id) event
{
	return event;
}

- (void) dealloc
{
	RELEASE(event);
	[super dealloc];
}
@end

@implementation CalendarController

- (void) dealloc
{
	[_modelMan removeObserver:self];

	RELEASE(_eventView);
	RELEASE(dateText);
	RELEASE(eventBrowser);
	RELEASE(scrollView);
	RELEASE(calendarView);
	RELEASE(searchTextView);
	RELEASE(_modelMan);
	RELEASE(_eventList);
	RELEASE(deleteMenuButton);

	[super dealloc];
}

- (id) modelMan
{
	return _modelMan;
}

- (void) calendarEventModel:(id)model
	   didUpdateStringValue:(NSString *)string
{
}

- (void) applicationWillFinishLaunching: (NSNotification *)not
{
	NSRect r;

	_eventList = [NSArray new];
	[eventBrowser setCellClass:[MyBrowserCell class]];
	_dockView = [[DockView alloc] initWithFrame:NSMakeRect(1,1,62,62)
									   modelMan:_modelMan];
	[[[NSApp iconWindow] contentView] addSubview:_dockView];

	[NSApp setApplicationIconImage:nil];
	[_modelMan addObserver:_dockView];

	[_modelMan addObserver:self];

	r = [_eventView frame];
	[_eventView setDelegate:self];

	[_eventView setDate:[NSCalendarDate date]];
	[dateText setStringValue:[[_eventView startDate] description]];
	[_eventView setFrame:NSMakeRect(NSMinX(r),NSMinY(r),NSWidth([[_eventView superview] bounds]),800)];
	[_eventView viewDay];
	[eventBrowser setMaxVisibleColumns:1];

	[_eventView _scrollToDayStart];//DIRTY TODO
}

- (void) applicationWillTerminate:(NSNotification *)aNotification;
{
	[_modelMan saveEventsToDisk];
}


- (void) reloadSearchBrowser
{
	ASSIGN(_eventList, nil);

	if ([searchTextView stringValue] != nil &&
			[[searchTextView stringValue] isEqualToString:@"."])
	{
		ASSIGN(_eventList, [_modelMan allEvents]);
	}
	else if ([searchTextView stringValue] != nil &&
			![[searchTextView stringValue] isEqualToString:@""])
	{
		ASSIGN(_eventList, [_modelMan allEventsWithString:[searchTextView stringValue]]);
	}

	[eventBrowser reloadColumn:0];
}

- (id) createEventWithStartDate:(NSCalendarDate *)startDate
					 timeInterval:(NSTimeInterval)stopTime
{
	return [_modelMan createModelWithStartDate:startDate
								  timeInterval:stopTime];
}

- (void) calendarEventModelManager:(CalendarEventModelManager *)man
					   didUpdateModel:(CalendarEventModel *)model
{
}

- (void) calendarEventModelManager:(CalendarEventModelManager *)man
					   didAddModel:(CalendarEventModel *)model
{
	[_eventView update];
	/* reload search browser if neccessary -- TODO */
}

- (NSArray *) allEventsDuringDate:(NSCalendarDate *)startDate
						  andDate:(NSCalendarDate *)stopDate
{
	return [_modelMan allEventsDuringDate:startDate
								  andDate:stopDate];
}

- (void) calendarEventView:(id)sender
			didSelectModel:(id)model
{
}

- (void) deleteEvent:(id)sender
{
	// FIXME better keep selected model in controller

	[_modelMan removeModel:_selectedModel];
//	[_eventView removeEvent:[_eventView selectedCell]];
}

- (void) selectModel:(id)model
{
	if (model != _selectedModel)
	{
		[_selectedModel removeObserver:self];
		_selectedModel = model;
		[_selectedModel addObserver:self];

		if (model != nil)
		{
			[deleteMenuButton setAction:@selector(deleteEvent:)];
		}
		else
		{
			[deleteMenuButton setAction:(SEL)0];
		}

		[_eventView selectModel:model];
	}
}

- (id) selectedModel
{
	return _selectedModel;
}

- (void) calendarEventModelWillBeFreed:(id)model
{
	if (model == _selectedModel)
	{
		_selectedModel = nil;
	}
}

- (void) calendarEventModel:(CalendarEventModel *)model
		 didUpdateStartDate:(NSCalendarDate *)startDate
			   timeInterval:(NSTimeInterval)time
{
}

- (void) setDate:(id)date
{
	[_eventView setDate:date];
	[calendarView viewCalendarDate:date];
	[dateText setStringValue:[[_eventView startDate] description]];
}

- (void) viewDay:(id)sender
{
	/*
	NSRect r;
	r = [_eventView frame];
	[_eventView setFrame:NSMakeRect(NSMinX(r),NSMinY(r),NSWidth([[_eventView superview] bounds]),800)];
	*/
	[_eventView viewDay];
	[dateText setStringValue:[[_eventView startDate] description]];
}
- (void) viewWeek:(id)sender
{
	[_eventView viewWeek];
	[dateText setStringValue:[[_eventView startDate] description]];
}
- (void) viewMonth:(id)sender
{
	[_eventView viewMonth];
	[dateText setStringValue:[[_eventView startDate] description]];
}
- (void) viewYear:(id)sender
{
	[_eventView viewYear];
	[dateText setStringValue:[[_eventView startDate] description]];
}

- (void) nextDate:(id)sender
{
	[_eventView nextDate];
	[_eventView viewSelectedCell];
	[dateText setStringValue:[[_eventView startDate] description]];
}

- (void) previousDate:(id)sender
{
	[_eventView previousDate];
	[_eventView viewSelectedCell];
	[dateText setStringValue:[[_eventView startDate] description]];
}

- (void) chooseEvent:(id)sender
{
	id event = [[sender selectedCell] event];
	NSPoint newPoint = NSZeroPoint;
	
	[_eventView setDate:[event startDate]];
	[self selectModel:event];
	/*
	[_eventView selectCell:event];

	*/

	[_eventView viewSelectedCell];
}

- (void) searchTextChanged:(id)sender
{
	[self reloadSearchBrowser];
}

- (int) browser:(NSBrowser *)sender numberOfRowsInColumn:(int)column
{
	return [_eventList count];
}

- (void) browser: (NSBrowser *)sender
 willDisplayCell: (NSBrowserCell *)cell
		   atRow: (int)row
		  column: (int)column
{
	int n;
	id event = [_eventList objectAtIndex:row];

	id content = [event stringValue];
	if (content != nil)
	{
		content = [content componentsSeparatedByString:@"\n"];
		if ([content count] > 0)
		{
			content = [content objectAtIndex:0];
		}
	}
	if (content == nil)
	{
		content = @"";
	}

	[cell setTitle:[NSString stringWithFormat:@"%@ (%@...)",[event description],content]];
	[cell setEvent:event];
	[cell setLeaf:YES];

}
@end
