/* All Rights reserved */

#include <AppKit/AppKit.h>
#include "AppController.h"

@implementation AppController
static NSUserDefaults *defaults;

+ (void) initialize
{
	defaults = [NSUserDefaults standardUserDefaults];
}

- (void) setSecondHandColor: (id)sender
{

	NSColor *col = [sender color];
	[_clock setSecondHandColor:col];
	[bigClock setSecondHandColor:col];
	[defaults setObject:[col description] forKey:@"SecondHandColor"];
	[defaults synchronize];
}

- (void) setHandColor: (id)sender
{
	NSColor *col = [sender color];
	[_clock setHandsColor:col];
	[bigClock setHandsColor:col];
	[defaults setObject:[col description] forKey:@"HandsColor"];
	[defaults synchronize];
}


- (void) setShowAMPM: (id)sender
{
	[_clock setShowAMPM:[sender intValue]?YES:NO];
	[bigClock setShowAMPM:[sender intValue]?YES:NO];
	[defaults setObject:[sender intValue]?@"YES":@"NO" forKey:@"ShowAMPM"];
	[defaults synchronize];
}

- (void) setNumberType: (id)sender
{
	[_clock setNumberType:[sender indexOfSelectedItem]];
	[bigClock setNumberType:[sender indexOfSelectedItem]];
	[defaults setObject:[NSString stringWithFormat:@"%d",[sender indexOfSelectedItem]] forKey:@"NumberType"];
	[defaults synchronize];
}

- (void) setSecond: (id)sender
{
	[_clock setSecond:[sender intValue]?YES:NO];
	[bigClock setSecond:[sender intValue]?YES:NO];
	[defaults setObject:[sender intValue]?@"YES":@"NO" forKey:@"Second"];
	[defaults synchronize];
}

- (void) setShadow:(id)sender
{
	[_clock setShadow:[sender intValue]?YES:NO];
	[bigClock setShadow:[sender intValue]?YES:NO];
	[defaults setObject:[sender intValue]?@"YES":@"NO" forKey:@"Shadow"];
	[defaults synchronize];
}


- (void) setFaceTransparency: (id)sender
{
	[_clock setFaceTransparency:[sender floatValue]];
	[bigClock setFaceTransparency:[sender floatValue]];
	[defaults setObject:[sender stringValue] forKey:@"FaceTransparency"];
	[defaults synchronize];
}


- (void) setFaceColor: (id)sender
{
	NSColor *col = [sender color];
	[_clock setFaceColor:col];
	[bigClock setFaceColor:col];
	[defaults setObject:[col description] forKey:@"FaceColor"];
	[defaults synchronize];
}

- (void) setMarkColor: (id)sender
{
	NSColor *col = [sender color];
	[_clock setMarksColor:col];
	[bigClock setMarksColor:col];
	[defaults setObject:[col description] forKey:@"MarksColor"];
	[defaults synchronize];
}


- (void) setFrameColor: (id)sender
{
	NSColor *col = [sender color];
	[_clock setFrameColor:col];
	[bigClock setFrameColor:col];
	[defaults setObject:[col description] forKey:@"FrameColor"];
	[defaults synchronize];
}

- (void) clockUpdate: (id)sender
{
	double st,et;
	id src,des;

	if (sender == bigClock)
	{
		src = bigClock;
		des = _clock;
	}
	else
	{
		src = _clock;
		des = bigClock;
	}

	st = [src arcStartTime];
	et = [src arcEndTime];
	if (et < st)
	{
		[alarmWindow makeKeyAndOrderFront: self];
	}

	[des setArcEndTime:[src arcEndTime]];
	[des setShowsArc:[src showsArc]];

}


- (void) openPreferences: (id)sender
{
	[prefPanel orderFront: self];
}

-(void) applicationWillFinishLaunching: (NSNotification *)not
{
	NSMenu *menu, *m;
	NSWindow *win;
	unsigned int width, height;
	menu = [NSMenu new];
	m = [NSMenu new];

	/* Info */
	[m addItemWithTitle: _(@"Info...")
		action: @selector(orderFrontStandardInfoPanel:)
		keyEquivalent: nil];
	[m addItemWithTitle: _(@"Preferences...")
		action: @selector(openPreferences:)
		keyEquivalent: nil];
	[menu setSubmenu: m forItem: [menu addItemWithTitle: _(@"Info") action:NULL keyEquivalent:nil]];
	[m release];

	[menu addItemWithTitle: _(@"Quit")
		action: @selector(terminate:)
		keyEquivalent: @"q"];

	[NSApp setMainMenu: menu];
	[menu release];
        
	win = [NSApp iconWindow];
	width = [[win contentView] bounds].size.width;
	height = [[win contentView] bounds].size.height;

	_clock = [[Clock alloc] initWithFrame: NSMakeRect(1, 1, width - 2, height - 2)];
	[[win contentView] addSubview:_clock];

	[_clock setTarget:self];
	[_clock setAction:@selector(clockUpdate:)];

	{ /* initialize the clock so it won't flick */
		NSCalendarDate *d = [NSCalendarDate date];
		NSTimeInterval g = [d timeIntervalSinceReferenceDate];
		double time;
		time = [d hourOfDay] * 3600 + [d minuteOfHour] * 60 + [d secondOfMinute];

		[_clock setHandsTime: time];
		[_clock setArcStartTime: time];
		[_clock setArcEndTime: time];

		[bigClock setHandsTime: time];
		[bigClock setArcStartTime: time];
		[bigClock setArcEndTime: time];
	}

	[[NSUserDefaults standardUserDefaults]
	    registerDefaults:[NSDictionary dictionaryWithObject:@"0.1" forKey:@"RefreshRate"]];
	    
		/*
	[[NSUserDefaults standardUserDefaults]
	    registerDefaults:[NSDictionary dictionaryWithObjectsAndKeys: @"YES", @"SmoothSeconds", nil]];
		*/
}

- (void) tick
{
	NSCalendarDate *d = [NSCalendarDate date];
	NSTimeInterval g = [d timeIntervalSinceReferenceDate];
	double time;
	if (doFloor)
	{
		time = [d hourOfDay] * 3600 + [d minuteOfHour] * 60 + [d secondOfMinute];
		[_clock setHandsTime: time];
		[bigClock setHandsTime: time];

		[_clock setArcStartTime: time];
		[bigClock setArcStartTime: time];
	
	}
	else
	{
		time = [d hourOfDay] * 3600 + [d minuteOfHour] * 60 + [d secondOfMinute] + (g - floor(g));
		[_clock setHandsTime: time];
		[bigClock setHandsTime: time];

		[_clock setArcStartTime: time];
		[bigClock setArcStartTime: time];
	}
}

- (void) setFrequency: (id)sender
{
	NSInvocation *inv;
	inv = [NSInvocation invocationWithMethodSignature:
		[self methodSignatureForSelector:@selector(tick)]];
	[inv setSelector:@selector(tick)];
	[inv setTarget:self];

	RELEASE(timer);
	timer=[NSTimer scheduledTimerWithTimeInterval:[sender floatValue] invocation:inv repeats:YES];

	[defaults setObject:[sender stringValue] forKey:@"RefreshRate"];
	if ([defaults floatForKey: @"RefreshRate"] > 15.0)
	{
		[secondSwitch setIntValue:0];
		[self setSecond:secondSwitch];
		doFloor = YES;
	}
	else if ([defaults floatForKey: @"RefreshRate"] >= 1.0)
	{
		doFloor = YES;
	}
	else
	{
		doFloor = NO;
	}
	[defaults synchronize];
}


- (void) applicationDidFinishLaunching: (NSNotification *)not
{
	id defaults = [NSUserDefaults standardUserDefaults];
	NSInvocation *inv;

	inv = [NSInvocation invocationWithMethodSignature:
		[self methodSignatureForSelector:@selector(tick)]];
	[inv setSelector:@selector(tick)];
	[inv setTarget:self];

	[faceColorW setColor:[_clock faceColor]];
	[ampmSwitch setIntValue:[_clock showAMPM]];
	[shadowSwitch setIntValue:[_clock shadow]];
	[transSlider setFloatValue:[_clock faceTransparency]];
	[handColorW setColor:[_clock handsColor]];
	[secColorW setColor:[_clock secondHandColor]];
	[frameColorW setColor:[_clock frameColor]];
	[markColorW setColor:[_clock marksColor]];
	[secondSwitch setIntValue:[_clock second]];
	[numberPopUp selectItemAtIndex:[_clock numberType]];

	[freqText setStringValue:[defaults stringForKey: @"RefreshRate"]];

	timer=[NSTimer scheduledTimerWithTimeInterval:[defaults floatForKey: @"RefreshRate"] invocation:inv repeats:YES];
	if ([defaults floatForKey: @"RefreshRate"] >= 1.0)
	{
		doFloor = YES;
	}
	else
	{
		doFloor = NO;
	}
	
	if ([defaults boolForKey: @"autolaunch"]) {
	    [NSApp hide: self];
	}
}


@end
