(in-package "ACL2")

;one of these is still broken


;don't need everything in this book!
(local (include-book "numerator"))
(local (include-book "denominator"))
(local (include-book "nniq"))
(local (include-book "arith2"))
(local (include-book "type"))
(local (include-book "ground-zero"))
(local (include-book "flooreric"))
(local (include-book "integerp"))
(local (include-book "rationalp"))
(local (include-book "unary-divide"))
(local (include-book "expt"))
(local (include-book "expt2"))
(local (include-book "expo"))
(local (include-book "expo2"))
(local (include-book "power2p"))
(local (include-book "fl-expt"))
(local (include-book "mod2"))

(DEFUN FL (X) (FLOOR X 1))



(defthm fl-shift-pull-inside-mod
  (implies (and ;(rationalp x)
                (<= j i) ;what if not?
                (case-split (integerp i))
                (case-split (integerp j))
                )
           (equal (FL (* (/ (EXPT 2 J))
                         (MOD x (EXPT 2 i))))
                  (mod (FL (* x (/ (EXPT 2 J))))
                       (expt 2 (- i j)))))
  :hints (("Goal" :in-theory (enable mod expt-split))))



(in-theory (disable fl-shift-pull-inside-mod))





(defthm mod-integerp-when-y-is-power-of-2
  (implies (integerp x)
           (integerp (mod x (expt 2 i))))
  :rule-classes (:rewrite :type-prescription)
  :hints (("Goal" :cases ((< i 0)))))


(encapsulate
 ()
 (local (defthm mod-pull-inside-fl-shift-usual-case
          (implies (and (<= 0 i) ;this case
;                (rationalp x)
                        (case-split (integerp i)) ;may be droppable
                        (case-split (integerp j))
                        )
                   (equal (mod (FL (* x (/ (EXPT 2 J))))
                               (expt 2 i))
                          (FL (* (/ (EXPT 2 J))
                                 (MOD x (EXPT 2 (+ i j)))))))
          :otf-flg t
          :hints (("Goal" :use ((:instance fl-def-linear-part-1 (x (* X (/ (EXPT 2 I))
                                                                      (/ (EXPT 2 J)))))
                                (:instance fl-def-linear-part-2 (x (* X (/ (EXPT 2 I))
                                                                      (/ (EXPT 2 J))))))
                   :in-theory (set-difference-theories
                               (enable mod expt-split)
                               '(  FL-WEAK-MONOTONE
                                   fl-def-linear-part-1
                                   fl-def-linear-part-2)
                               )))))


 (local (defthm mod-pull-inside-fl-shift-other-case
          (implies (and (< i 0) ;this case
;                (rationalp x)
                        (case-split (integerp i))
                        (case-split (integerp J))

                        )
                   (equal (mod (FL (* x (/ (EXPT 2 J))))
                               (expt 2 i))
                          (FL (* (/ (EXPT 2 J))
                                 (MOD x (EXPT 2 (+ i j)))))))
          :otf-flg t
          :hints (("Goal" :use ((:instance <-transitive 
                                           (a x)
                                           (b (+ (* (EXPT 2 I) (EXPT 2 J))
                                                 (* (EXPT 2 I)
                                                    (EXPT 2 J)
                                                    (FL (* X (/ (EXPT 2 I)) (/ (EXPT 2 J)))))))
                                           (c (+ (EXPT 2 J)
                                                 (* (EXPT 2 I)
                                                    (EXPT 2 J)
                                                    (FL (* X (/ (EXPT 2 I))
                                                           (/ (EXPT 2 J))))))))
                                (:instance fl-def-linear-part-1 (x (* X (/ (EXPT 2 I))
                                                                      (/ (EXPT 2 J)))))
                                (:instance fl-def-linear-part-2 (x (* X (/ (EXPT 2 I))
                                                                      (/ (EXPT 2 J))))))
                   :in-theory (set-difference-theories
                               (enable mod expt-split)
                               '(FL-WEAK-MONOTONE
;                         expt-compare
                                 fl-def-linear-part-1
                                 fl-def-linear-part-2)
                               )))))



 (defthm mod-pull-inside-fl-shift
   (implies (and ;no hyp about x
             (case-split (integerp i))
             (case-split (integerp J))
             )
            (equal (mod (FL (* x (/ (EXPT 2 J))))
                        (expt 2 i))
                   (FL (* (/ (EXPT 2 J))
                          (MOD x (EXPT 2 (+ i j)))))))
   :otf-flg t
   :hints (("Goal" :cases ( (<= 0 i)))))
 )


(defthm mod-pull-inside-fl-shift-alt
  (implies (and ;(rationalp x)
                (integerp i)
                (integerp j)
                )
           (equal (mod (FL (* (/ (EXPT 2 J)) x))
                       (expt 2 i))
                  (FL (* (/ (EXPT 2 J))
                         (MOD x (EXPT 2 (+ i j))))))))

(defthm mod-pull-inside-fl-shift-alt-alt
  (implies (and ;(rationalp x)
                (integerp i)
                (integerp j)
                )
           (equal (mod (FL (* (/ (EXPT 2 J)) x))
                       (* 2 (expt 2 i)))
                  (FL (* (/ (EXPT 2 J))
                         (MOD x (EXPT 2 (+ i 1 j)))))))
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable expt-split)
                              '(MOD-PULL-INSIDE-FL-SHIFT
                                mod-pull-inside-fl-shift-alt))
           :use (:instance mod-pull-inside-fl-shift
                           (i (+ i 1))))))

(defthm mod-pull-inside-fl-shift-alt-alt-alt
  (implies (and ;(rationalp x)
                (integerp j)
                )
           (equal (mod (FL (* (/ (EXPT 2 J)) x))
                       2)
                  (FL (* (/ (EXPT 2 J))
                         (MOD x (EXPT 2 (+ 1 j)))))))
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable expt-split)
                              '( MOD-PULL-INSIDE-FL-SHIFT
                                 mod-pull-inside-fl-shift-alt
                                 mod-pull-inside-fl-shift-alt-alt))
           :use (:instance mod-pull-inside-fl-shift-alt-alt
                           (i 0)))))

(defthm mod-pull-inside-fl-shift-alt-alt-alt-alt
  (implies (and ;(rationalp x)
                (integerp j)
                )
           (equal (mod (FL (* x (/ (EXPT 2 J)))) ;factors commuted
                       2)
                  (FL (* (/ (EXPT 2 J))
                         (MOD x (EXPT 2 (+ 1 j)))))))
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable expt-split)
                              '( MOD-PULL-INSIDE-FL-SHIFT
                                 mod-pull-inside-fl-shift-alt
                                 mod-pull-inside-fl-shift-alt-alt
                                 mod-pull-inside-fl-shift-alt-alt-alt))
           :use (:instance mod-pull-inside-fl-shift-alt-alt
                           (i 0)))))



(defthm fl-mod-zero
  (implies (and (<= i2 i1)
                (integerp i1)
                (integerp i2)
                )
           (equal (FL (* (/ (EXPT 2 i1))
                         (MOD X (EXPT 2 i2))))
                  0))

  )



;generalize?
(defthm mod-pull-inside-fl-shift-alt-5
  (implies (and; (rationalp x)
                (integerp i)
                (integerp j)
                )
           (equal (mod (FL (* (/ (EXPT 2 J)) x))
                       (* 2 (expt 2 i)))
                  (FL (* (/ (EXPT 2 J))
                         (MOD x (EXPT 2 (+ 1 i j)))))))
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable expt-split)
                              '(
                               MOD-PULL-INSIDE-FL-SHIFT
                               mod-pull-inside-fl-shift-alt
                               mod-pull-inside-fl-shift-alt-alt
                               mod-pull-inside-fl-shift-alt-alt-alt))
           :use (:instance  mod-pull-inside-fl-shift-alt (i (+ i 1))))))


(defthm mod-pull-inside-fl-shift-alt-6
  (implies (and; (case-split (rationalp x))
                (integerp i)
                (integerp j)
                (integerp k)
                )
           (equal (mod (FL (* x (/ (EXPT 2 J))))
                       (* 2 (expt 2 i) (/ (expt 2 k))))
                  (FL (* (/ (EXPT 2 J))
                         (MOD x (EXPT 2 (+ 1 (- k) i j)))))))
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable expt-split)
                              '(
                               MOD-PULL-INSIDE-FL-SHIFT
                               mod-pull-inside-fl-shift-alt
                               mod-pull-inside-fl-shift-alt-alt
                               mod-pull-inside-fl-shift-alt-alt-alt
                               ))
           :use (:instance  mod-pull-inside-fl-shift-alt (i (+ i (- k) 1))))))
