/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stylebook.parsers;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.stylebook.BasicParameters;
import org.apache.stylebook.ComponentFactory;
import org.apache.stylebook.CreationException;
import org.apache.stylebook.Engine;
import org.apache.stylebook.InitializationException;
import org.apache.stylebook.Parameters;
import org.apache.stylebook.Parser;
import org.apache.stylebook.parsers.AbstractParser;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class CachingParser
extends AbstractParser
implements Parser {
    private Parser parser = null;
    private int cachesize = 10;
    private Hashtable cache = new Hashtable();

    public void init(Engine engine, Parameters parameters) throws InitializationException {
        super.init(engine, parameters);
        String string = parameters.getParameter("parserclass");
        if (string == null) {
            throw new InitializationException("Parameter \"parserclass\" not specified");
        }
        this.parser = ComponentFactory.getParser(string);
        BasicParameters basicParameters = new BasicParameters();
        Enumeration enumeration = parameters.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = parameters.getParameter(string2);
            if (!string2.startsWith("parser.")) continue;
            string2 = string2.substring(7);
            basicParameters.setParameter(string2, string3);
        }
        this.parser.init(engine, basicParameters);
        try {
            this.cachesize = Integer.parseInt(parameters.getParameter("cachesize"));
        }
        catch (Exception exception) {
            this.debug("Cache size not specified (default=10)");
            this.cachesize = 10;
        }
    }

    public Document create() {
        return this.parser.create();
    }

    public Document parse(InputSource inputSource) throws IOException, CreationException {
        String string = inputSource.getSystemId();
        if (string == null) {
            return this.parser.parse(inputSource);
        }
        CachedEntry cachedEntry = (CachedEntry)this.cache.get(string);
        Document document = null;
        if (cachedEntry == null) {
            document = this.parser.parse(inputSource);
            cachedEntry = new CachedEntry(document);
            this.cache.put(string, cachedEntry);
        } else {
            ++cachedEntry.hits;
            document = cachedEntry.document;
            if (document == null) {
                document = this.parser.parse(inputSource);
            } else {
                this.log("Serving cached document \"" + string + "\" (" + cachedEntry.hits + ")");
            }
            cachedEntry.document = document;
        }
        this.purge();
        return document;
    }

    private void purge() {
    }

    private class CachedEntry {
        public Document document = null;
        public int hits = 0;

        public CachedEntry(Document document) {
            this.document = document;
        }
    }
}

