/*

    @author DanielD

    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

package com.sap.dbtech.procserver;

/**
 *
 */
public class SQLJCallable
    implements Callable
{
    /**
     * creates a new SQLJCallable
     */
    public 
    SQLJCallable (
        String id)
    {
    }
    /**
     *
     */
    public void 
    call (
        ProcParameterList parameterList)
    throws Stop, Throwable
        
    {
        final String [] modeNames = {
            "unknown", "in", "in/out", "???", "out",
        };
        java.sql.ParameterMetaData metaData = parameterList.getParameterMetaData ();
        int count = metaData.getParameterCount ();
        for (int i = 1; i <= count; ++i) {
            Log.log ("P " + i + ": " + metaData.getParameterTypeName (i)
                    + " (" 
                    + metaData.getPrecision (i) + ", " 
                    + metaData.getScale (i) + ") "
                    + modeNames [metaData.getParameterMode (i)]);
            switch (metaData.getParameterMode (i)) {
                case java.sql.ParameterMetaData.parameterModeIn:
                case java.sql.ParameterMetaData.parameterModeInOut:
                    Log.log ("   => " + parameterList.getString (i));
            }
        }
        parameterList.setString (2, "back");          
        // throw new Stop (-4711, "call not implemented");
    }
    /**
     *
     */
    public static class SQLJCallableFactory
        implements CallableFactory
    {
        /**
         * creates a new SQLJCallableFactory
         */
        public 
        SQLJCallableFactory ()
        {
        }
        /**
         *
         */
        public Callable 
        create (
            String id, 
            String date)
        {
            return new SQLJCallable (id);
        }
    }
}
