/*!
	========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end
*/
package com.sap.dbtech.jdbc.translators;

import java.sql.SQLException;

import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.util.MessageKey;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.vsp00.StreamHandle;

/**
 * Getval instance for simple ASCII OMS Streams.
 */
public class BinaryABAPStreamGetval 
	extends AbstractABAPStreamGetval {
	
	public BinaryABAPStreamGetval(ABAPStreamTranslator translator) {
		super(translator);
		addColumn(StreamHandle.Stream_OUT_C,
				  StreamHandle.StreamType_Char_C,
				  1,
				  0,
				  1,
				  0);
	}

	public byte[] getBytes() 
		throws SQLException {
		if(data == null) {
			throw new SQLExceptionSapDB(MessageTranslator.translate(MessageKey.ERROR_STREAM_NODATA));
		}
		return data.bytes();	
	}


	public Object getObject() 
		throws SQLException {
		return getBytes();	
	}
}
