<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:template match="/">	
	 <project default="getcorelibs" basedir="." name="getcorelibs">
      
       <description>		 
         Autogenerated Ant build file that downloads core libs for the project.
       </description>
      	 
	   <target name="getcorelibs">
	     <xsl:attribute name="depends">
	       <xsl:for-each select = "module/project/depend">
	         <xsl:value-of select="@project"/>-present,
           </xsl:for-each>
	       <xsl:for-each select = "module/project/depend">
	         <xsl:value-of select="@project"/>-target,
           </xsl:for-each>dummy-target
        </xsl:attribute> 
       </target>	   

       <xsl:apply-templates/>
       
	   <target name="dummy-target">
	     <echo message="core libs fetch finished"/>
       </target> 
              
     </project>  
	</xsl:template>
	  	

	<xsl:template match="properties">	
	
	<xsl:variable name = "repository" select = "@project" />	 
      
      <xsl:for-each select = "module/project/depend">
       
	   <target>
	      <xsl:attribute name="name"><xsl:value-of select="@project"/>-target</xsl:attribute>
	      <xsl:attribute name="unless"><xsl:value-of select="@project"/>.present</xsl:attribute>
	      <xsl:attribute name="depends"><xsl:value-of select="@project"/>-present</xsl:attribute> 
	      	      
        <antipede-jjar>
         
         <xsl:attribute name="package"><xsl:value-of select="@project"/></xsl:attribute> 
         <xsl:attribute name="repository"><xsl:value-of select="$repository"/></xsl:attribute>   
         <xsl:attribute name="localrepository">${xlayout.lib.core.dir}</xsl:attribute>    
         <xsl:attribute name="pathrefid">dummy.classpath</xsl:attribute>
         <!--            
         <xsl:attribute name="version"></xsl:attribute> 
         <xsl:attribute name="pathrefid"></xsl:attribute> 
         <xsl:attribute name="classpath"></xsl:attribute> 
         <xsl:attribute name="onlyDependencies"></xsl:attribute> 
         <xsl:attribute name="verifyignore"></xsl:attribute> -->
      
        </antipede-jjar>
       </target>       
      </xsl:for-each>

      <xsl:for-each select = "module/project/depend">
       
	   <target>
	      <xsl:attribute name="name"><xsl:value-of select="@project"/>-present</xsl:attribute>

          <available>
            <xsl:attribute name="file">${cents.dir}/<xsl:value-of select="@project"/>.cent.jar</xsl:attribute>          
	        <xsl:attribute name="property"><xsl:value-of select="@project"/>.present</xsl:attribute>
          </available>

          <echo><xsl:value-of select="@project"/>.jar is present: ${<xsl:value-of select="@project"/>.present}</echo> 
 
       </target>       
      </xsl:for-each>
            	  
	</xsl:template>
		
</xsl:stylesheet>