/***************************************************************************
                          transferscreen.cpp  -  description
                             -------------------
    begin                : Thu Apr 4 2002
    copyright            : (C) 2002 by Sebastian Schildt
    email                : sebastian@frozenlight.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "transferscreen.h"

TransferScreen::TransferScreen(){
}
TransferScreen::~TransferScreen(){
}

bool TransferScreen::paintScreen(QPainter *p, paintHelpers *ph,  SetiLocation *sl) {

	ph->clearScreen(p);
	ph->drawMainHeader(p,"Transferring");
	
	p->setFont(ph->headerfont);

	p->drawText(32, 330, "Exchanging data with main server" );
	p->flush();

	p->setPen(ph->dgray);
	for (int i = 1; i <= 32; i++) {
  	p->fillRect(32+(i-1)*30,350,27,27,ph->dgray);
	}
	p->flush();

	
	bool finished = false;
	int size;	
  bool display = true;

	//Waiting for connect...
	p->fillRect(0,270,1024,70,Qt::black);
	for (int i = 0; i <= 60; i++) {
		if (display) {
    	display=false;
			p->setPen(ph->lcarsOrange);
			p->drawText( 32, 330, "Waiting for connection..." );
			p->flush();
		}
		else {
    	display = true;
			p->fillRect(0,270,1024,70,Qt::black);
			p->flush();
		}
    if (sl->getState() == sl->TRANSFER) {
    	i = 70;
			finished = true;
		}
		sleep(1);
	}


	//When failed
	if (!finished) {
			p->fillRect(0,270,1024,70,Qt::black);
			p->drawText( 32, 330, "Unable to contact server..." );
			sleep(2);
			return finished;
	}

	QFileInfo qwtmp(sl->getPath()+"/wtemp.sah");
	qwtmp.setCaching(false);
	//cout << "Monitoring " <<
	QFileInfo qstat(sl->getPath()+"/work_unit.sah");
	qstat.setCaching(false);

  display = true;
	finished=false;
	p->fillRect(0,270,1024,70,Qt::black);
  for (int i = 0; i <= 300; i++) {
		qwtmp.refresh();
  	size=qwtmp.size();
		//cout << "Size is " << size << endl;
		for (int x = 1; x <= size/11250; x++) {
					//cout << "Paint " << x << endl;
			  	p->fillRect(32+(x-1)*30,350,27,27,ph->lcarsOrange);
		}
		cout << flush;
		p->flush();
		if (display) {
    	display=false;
			p->setPen(ph->lcarsOrange);
			p->drawText( 32, 330, "Exchanging data with main server" );
		}
		else {
    	display = true;
			p->fillRect(0,270,1024,70,Qt::black);
		}
		p->flush();
		if (qstat.exists()) {
    	i=500;
			finished=true;
		}
		sleep(1);
	}
	
	return finished;

}

