/*
 * HPTalx
 * A PC<->HP48/49 communication program for Linux
 *
 * (C) 1999 by Bruno Barberi Gnecco
 *
 * rev 0.1:	Initial testing
 * rev 0.1.1:	Added status bar
 *		Minor corrections
 * rev 0.2:	Left button pops a menu in FILES
 *		Added column sort
 *		Added binary/ascii file transfer
 * rev 1.0:	Changed pipes to pseudo terminals (thanks to ckermit support)
 *		Fixed double click bug
 *		Added un/select all
 *		Fixed bin/ascii bug
 *		Fixed choose_dir
 * rev 1.1.0:	Added protocol choice in menus
 *		Added unpack
 */

/*
    Copyright note:

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "hptalx.h"
#include "icons.h"
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <fcntl.h>

GtkWidget *dir_pc, *dir_hp;
GtkWidget *files_pc, *files_hp;
GtkItemFactory *item_factory;
struct data data_pc, data_hp;
HPANED whereami;
VPANED panel;
CALCULATOR calc = UNKNOWN_CALC;
CONNECTION connected;
TRANSFER_TYPE ttype = AUTO;

static GtkItemFactoryEntry items[] = {
{ "/_File",			NULL,		NULL, 0, "<Branch>" },
{ "/File/_Transfer",		"<control>T",	transfer, 0, NULL },
{ "/File/_Move",		"<control>M",	move, 0, NULL },
{ "/File/sep1",			NULL,		NULL, 0, "<Separator>" },
{ "/File/_Edit",		"<control>E",	edit, 0, NULL },
{ "/File/_Copy...",		"<control>C",	copy, 0, NULL },
{ "/File/_Rename...",		"<control>R",	renamew, 0, NULL },
{ "/File/_Unpack",		"<control>P",	unpack, 0, NULL },
{ "/File/_Delete",		"<control>L",	delete, 0, NULL },
{ "/File/sep2",			NULL,		NULL, 0, "<Separator>" },
{ "/File/Select _all",		"<control>A",	select_all, 0, NULL },
{ "/File/_Unselect all",	"<control>U",	unselect_all, 0, NULL },
{ "/File/sep3",			NULL,		NULL, 0, "<Separator>" },
{ "/File/Re_fresh",		"<control>F",	refreshall, 0, NULL },
{ "/File/_Setup...",		"<control>N",	setup, 0, NULL },
{ "/File/sep4",			NULL,		NULL, 0, "<Separator>" },
{ "/File/_Quit",		"<control>Q",	gtk_main_quit, 0, NULL },

{ "/_Directories",		NULL,		NULL, 0, "<Branch>" },
{ "/Directories/C_reate dir...",NULL,		create_dir, 0, NULL },
{ "/Directories/C_hange dir",	NULL,		change_dir, 0, NULL },
{ "/Directories/_Remove dir",	NULL,		remove_dir, 0, NULL },

{ "/_Utilities",		NULL,		NULL, 0, "<Branch>" },
{ "/Utilities/_Command...",	NULL,		command, 0, NULL },
#ifdef UPDATE_ROM
{ "/Utilities/_Update ROM",	NULL,		update_rom, 0, NULL },
#endif
{ "/Utilities/sep1",		NULL,		NULL, 0, "<Separator>" },
{ "/Utilities/_Backup...",	NULL,		backup, 0, NULL },
{ "/Utilities/_Restore",	NULL,		restore, 0, NULL },
{ "/Utilities/sep1",		NULL,		NULL, 0, "<Separator>" },

{ "/Utilities/_Transfer type",	NULL,		NULL, 0, "<Branch>" },
{ "/Utilities/Transfer type/Auto",NULL,		NULL, 0, "<RadioItem>" },
{ "/Utilities/Transfer type/Binary",NULL,	NULL, 0, "<RadioItem>" },
{ "/Utilities/Transfer type/ASCII",NULL,	NULL, 0, "<RadioItem>" },

{ "/Utilities/_Protocol",	NULL,		NULL, 0, "<Branch>" },
{ "/Utilities/Protocol/Kermit",	NULL,		NULL, 0, "<RadioItem>" },
{ "/Utilities/Protocol/XModem",	NULL,		NULL, 0, "<RadioItem>" },


{ "/_Connect",			NULL,		NULL, 0, "<Branch>" },
{ "/Connect/_Connect",		"<control>B",	hp_connect, 0, NULL },
{ "/Connect/_Disconnect",	"<control>D",	disconnect, 0, NULL },

{ "/_Help",			NULL,		NULL, 0, "<LastBranch>" },
{ "/Help/How to use",		NULL,		howtouse, 0, NULL },
{ "/Help/About",		NULL,		about, 0, NULL }
};

static void set_transfer_type ( GtkWidget *w, gpointer data ) {
	/* this only sets everything up. We need the file transfer to be 
	automatic to get dir listings, etc, so we force the transfer type
	only when needed */
	ttype = GPOINTER_TO_INT(data);
	switch ( ttype ) {
	  case AUTO:
		set_status( "Transfer file type set to automatic" );
		break;
	  case BINARY:
		set_status( "Transfer file type set to Binary" );
		break;
	  case ASCII:
		set_status( "Transfer file type set to ASCII" );
		break;
	}
}

static void set_protocol_type ( GtkWidget *w, gpointer data ) {
	preferences.protocol = (PROTOCOL_TYPE)GPOINTER_TO_INT(data);
	switch ( preferences.protocol ) {
	  case KERMIT:
		set_status( "Protocol set to Kermit" );
		break;
	  case XMODEM:
		set_status( "Protocol set to XModem" );
		break;
	}
}

/* this function has been adapted from GTK's tutorial. */
static void get_main_menu ( GtkWidget *window, GtkWidget **menubar ) {
	GtkAccelGroup *accel_group;
	GtkWidget *aut, *bin, *ascii, *ker, *xmodem;
	int prot;
	gint nmenu_items = sizeof(items)/sizeof(items[0]);

	accel_group = gtk_accel_group_new();

	/* This function initializes the item factory.
	   Param 1: The type of menu - can be GTK_TYPE_MENU_BAR, GTK_TYPE_MENU,
		    or GTK_TYPE_OPTION_MENU.
	   Param 2: The path of the menu.
	   Param 3: A pointer to a gtk_accel_group.  The item factory sets up
		    the accelerator table while generating menus.
	*/
	item_factory = gtk_item_factory_new(GTK_TYPE_MENU_BAR, "<main>",
					     accel_group);

	/* This function generates the menu items. Pass the item factory,
	   the number of items in the array, the array itself, and any
	   callback data for the the menu items. */
	gtk_item_factory_create_items(item_factory, nmenu_items, items, NULL);

	/* Attach the new accelerator group to the window. */
	gtk_window_add_accel_group(GTK_WINDOW(window), accel_group);

	/* connect signals and lists to radio menu items */
	/* transfer type */
	aut = gtk_item_factory_get_widget( item_factory, 
			"<main>/Utilities/Transfer type/Auto" );
	gtk_signal_connect (GTK_OBJECT(aut), "toggled",
		      GTK_SIGNAL_FUNC(set_transfer_type), GINT_TO_POINTER(AUTO) );
	bin = gtk_item_factory_get_widget(item_factory, 
			"<main>/Utilities/Transfer type/Binary" );
	gtk_radio_menu_item_set_group( GTK_RADIO_MENU_ITEM(bin), 
			gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(aut)));
	gtk_signal_connect (GTK_OBJECT(bin), "toggled",
		      GTK_SIGNAL_FUNC(set_transfer_type), GINT_TO_POINTER(BINARY) );
	ascii = gtk_item_factory_get_widget(item_factory, 
			"<main>/Utilities/Transfer type/ASCII" );
	gtk_radio_menu_item_set_group( GTK_RADIO_MENU_ITEM(ascii), 
			gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(bin)));
	gtk_signal_connect (GTK_OBJECT(ascii), "toggled",
		      GTK_SIGNAL_FUNC(set_transfer_type), GINT_TO_POINTER(ASCII) );
	gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(bin), FALSE );
	gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(ascii), FALSE );
	gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(aut), TRUE );
	ttype = AUTO;

	/* protocol type */
	ker = gtk_item_factory_get_widget( item_factory, 
			"<main>/Utilities/Protocol/Kermit" );
	gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(ker), 
			(preferences.protocol == KERMIT ? KERMIT : XMODEM) );
	gtk_signal_connect (GTK_OBJECT(ker), "toggled",
		      GTK_SIGNAL_FUNC(set_protocol_type), GINT_TO_POINTER(KERMIT) );
	xmodem = gtk_item_factory_get_widget(item_factory, 
			"<main>/Utilities/Protocol/XModem" );
	gtk_radio_menu_item_set_group( GTK_RADIO_MENU_ITEM(xmodem), 
			gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(ker)));
	gtk_signal_connect (GTK_OBJECT(xmodem), "toggled",
		      GTK_SIGNAL_FUNC(set_protocol_type), GINT_TO_POINTER(XMODEM) );
	prot = preferences.protocol;
	gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(ker), FALSE );
	gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(xmodem), FALSE );
	gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM
			(prot == KERMIT ? ker : xmodem), TRUE );
	preferences.protocol = prot;

	if (menubar)
	  /* Finally, return the actual menu bar created by the item factory. */
		*menubar = gtk_item_factory_get_widget(item_factory, "<main>");
}

void get_pop_menu ( GtkWidget *popmenu ) {
	static int loaded = 0;
	static GtkWidget *transfer_item, *move_item;
	GtkWidget *menu_items;

	if ( loaded == 0 ) {
		transfer_item = gtk_menu_item_new_with_label( "Transfer" );
		gtk_menu_append( GTK_MENU(popmenu), transfer_item );
		gtk_signal_connect( GTK_OBJECT (transfer_item), "activate",
				GTK_SIGNAL_FUNC(transfer), NULL);
		gtk_widget_set_sensitive( transfer_item, FALSE );
		gtk_widget_show (transfer_item);

		move_item = gtk_menu_item_new_with_label( "Move" );
		gtk_menu_append( GTK_MENU(popmenu), move_item );
		gtk_signal_connect( GTK_OBJECT (move_item), "activate",
				GTK_SIGNAL_FUNC(move), NULL);
		gtk_widget_set_sensitive( move_item, FALSE );
		gtk_widget_show (move_item);

		menu_items = gtk_menu_item_new( );
		gtk_menu_append( GTK_MENU(popmenu), menu_items );
		gtk_widget_show (menu_items);

		menu_items = gtk_menu_item_new_with_label( "Edit" );
		gtk_menu_append( GTK_MENU(popmenu), menu_items );
		gtk_signal_connect( GTK_OBJECT (menu_items), "activate",
				GTK_SIGNAL_FUNC(edit), NULL);
		gtk_widget_show (menu_items);

		menu_items = gtk_menu_item_new_with_label( "Copy..." );
		gtk_menu_append( GTK_MENU(popmenu), menu_items );
		gtk_signal_connect( GTK_OBJECT (menu_items), "activate",
				GTK_SIGNAL_FUNC(copy), NULL);
		gtk_widget_show (menu_items);

		menu_items = gtk_menu_item_new_with_label( "Rename..." );
		gtk_menu_append( GTK_MENU(popmenu), menu_items );
		gtk_signal_connect( GTK_OBJECT (menu_items), "activate",
				GTK_SIGNAL_FUNC(renamew), NULL);
		gtk_widget_show (menu_items);

		menu_items = gtk_menu_item_new_with_label( "Unpack" );
		gtk_menu_append( GTK_MENU(popmenu), menu_items );
		gtk_signal_connect( GTK_OBJECT (menu_items), "activate",
				GTK_SIGNAL_FUNC(unpack), NULL);
		gtk_widget_show (menu_items);

		menu_items = gtk_menu_item_new_with_label( "Delete" );
		gtk_menu_append( GTK_MENU(popmenu), menu_items );
		gtk_signal_connect( GTK_OBJECT (menu_items), "activate",
				GTK_SIGNAL_FUNC(delete), NULL);
		gtk_widget_show (menu_items);

		menu_items = gtk_menu_item_new( );
		gtk_menu_append( GTK_MENU(popmenu), menu_items );
		gtk_widget_show (menu_items);

		menu_items = gtk_menu_item_new_with_label( "Create dir..." );
		gtk_menu_append( GTK_MENU(popmenu), menu_items );
		gtk_signal_connect( GTK_OBJECT (menu_items), "activate",
				GTK_SIGNAL_FUNC(create_dir), NULL);
		gtk_widget_show (menu_items);
		loaded = 1;
	}
	else if ( connected == ONLINE ) {
		gtk_widget_set_sensitive( move_item, TRUE );
		gtk_widget_set_sensitive( transfer_item, TRUE );
	}			
	else {
		gtk_widget_set_sensitive( move_item, FALSE );
		gtk_widget_set_sensitive( transfer_item, FALSE );
	}
}

/* adapted from GTK's docs/examples */
static gint pop_menu (GtkWidget *widget, GdkEvent *event) {
	if ( event->type == GDK_BUTTON_PRESS ) {
		GdkEventButton *bevent = (GdkEventButton *) event;
		if ( bevent->button == 3 ) /* left */
			gtk_menu_popup (GTK_MENU(widget), NULL, NULL, NULL, NULL,
				bevent->button, bevent->time);
	}
	return FALSE;
}


GtkWidget *status;
void set_status ( char *message ) {
	if ( !status ) /* many happen during startup */
		return;
	gtk_frame_set_label( GTK_FRAME(status), message );
	while ( gtk_events_pending() )
		gtk_main_iteration();
}

/* functions to deal with lists */
static void dir_select_row ( GtkWidget *widget, gint row, gint column, 
		GdkEventButton *bevent, gpointer which ) {
	gchar *temp;
	struct data *d;

	if ( (whereami = (VPANED)GPOINTER_TO_INT(which)) == PC )
		d = &data_pc;
	else
		d = &data_hp;
	panel = DIRS;
		
	gtk_clist_get_text(GTK_CLIST (widget), row, 0, &temp);
	g_free( d->dir );
	d->dir = g_strdup(temp);
	d->last_dir_row = row;

	if ( d->dir != NULL && bevent != NULL )
		if ( bevent->type == GDK_2BUTTON_PRESS )
			change_dir( widget, d->dir );
}

static void file_select_row ( GtkWidget *widget, gint row, gint column, 
		GdkEventButton *bevent, gpointer which ) {
	gchar *temp;
	struct data *d;

	if ( (whereami = (VPANED)GPOINTER_TO_INT(which)) == PC )
		d = &data_pc;
	else
		d = &data_hp;
		
	panel = FILES;
	
	gtk_clist_get_text(GTK_CLIST (widget), row, 1, &temp);
	g_free( d->filename );
	d->filename = g_strdup(temp);
	d->last_file_row = row;

	if ( d->filename != NULL && bevent != NULL )
		if ( bevent->type == GDK_2BUTTON_PRESS ) {
			char *t = (char *)gtk_clist_get_row_data( 
					GTK_CLIST(widget), row );
			if ( strstr( t, "Dir" ) )
				change_dir( widget, d->filename );
			else if ( connected == ONLINE )
				transfer( NULL, NULL );
			else
				edit( NULL, NULL );
		}
}

static gint type_compare ( GtkCList *clist, gconstpointer ptr1, 
		gconstpointer ptr2) {
	GtkCListRow *row1 = (GtkCListRow *) ptr1;
	GtkCListRow *row2 = (GtkCListRow *) ptr2;
 
	return strcmp( (char *)row1->data, (char *)row2->data);
}

static gint size_compare ( GtkCList *clist, gconstpointer ptr1, 
		gconstpointer ptr2) {
	double size1, size2, ret;
	GtkCListRow *row1 = (GtkCListRow *) ptr1;
	GtkCListRow *row2 = (GtkCListRow *) ptr2;
 
	size1 = atof(GTK_CELL_TEXT(row1->cell[clist->sort_column])->text);
	size2 = atof(GTK_CELL_TEXT(row2->cell[clist->sort_column])->text);
	ret = size1-size2;
	/* to avoid problems in the int conversion */
	if ( ret > 0 )			return 1;
	else if ( ret < 0 )		return -1;
	else				return 0;
}

static void sort_files ( GtkWidget *widget, gint column, gpointer which ) {
	if ( GTK_CLIST(widget)->sort_column == column ) {
		gtk_clist_set_sort_type( GTK_CLIST(widget), 
				(GTK_CLIST(widget)->sort_type == GTK_SORT_ASCENDING ?
				GTK_SORT_DESCENDING : GTK_SORT_ASCENDING) );
		gtk_clist_sort( GTK_CLIST(widget) );
		return;
	}
	gtk_clist_freeze( GTK_CLIST(widget) );
	gtk_clist_set_sort_column( GTK_CLIST(widget), column );
	switch ( column ) {
	   case 0: /* by type */
		gtk_clist_set_compare_func( GTK_CLIST(widget), 
				(GtkCListCompareFunc)type_compare );
		break;
	   case 1: /* by name */
		gtk_clist_set_compare_func( GTK_CLIST(widget), 
				(GtkCListCompareFunc)NULL );
		break;
	   case 2: /* by size */
		gtk_clist_set_compare_func( GTK_CLIST(widget), 
				(GtkCListCompareFunc)size_compare );
		break;
	}
	gtk_clist_sort( GTK_CLIST(widget) );
	gtk_clist_thaw( GTK_CLIST(widget) );
}

int main ( int argc, char *argv[] ) {
	GtkWidget *window;
	GtkWidget *main_vbox;
	GtkWidget *vpaned, *hpaned;
	GtkWidget *scrolled_win;
	GtkWidget *menubar;
	GtkWidget *popmenu;

	gtk_init(&argc, &argv);

	load_prefs();

	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_signal_connect(GTK_OBJECT(window), "destroy", 
			GTK_SIGNAL_FUNC(disconnect), NULL );
	gtk_signal_connect(GTK_OBJECT(window), "destroy", 
			GTK_SIGNAL_FUNC(close_pixmaps), NULL );
	gtk_signal_connect(GTK_OBJECT(window), "destroy", 
			GTK_SIGNAL_FUNC(gtk_main_quit), "WM destroy" );
	gtk_window_set_title(GTK_WINDOW(window), "HP Talx" );
	gtk_widget_set_usize(window, 640, 480);
	main_vbox = gtk_vbox_new(FALSE, 1);
	gtk_container_border_width(GTK_CONTAINER(main_vbox), 1);
	gtk_container_add(GTK_CONTAINER(window), main_vbox);
	gtk_widget_show(main_vbox);

	/* menu */
	get_main_menu(window, &menubar);
	gtk_box_pack_start(GTK_BOX(main_vbox), menubar, FALSE, TRUE, 0);
	gtk_widget_show(menubar);

	/* popmenu */
	popmenu = gtk_menu_new();
	get_pop_menu( popmenu );
	
	/* toolbar */
	
	/* file selectors */
	vpaned = gtk_vpaned_new();
	gtk_container_add(GTK_CONTAINER(main_vbox), vpaned);
	gtk_paned_set_handle_size(GTK_PANED(vpaned), 10);
	gtk_paned_set_gutter_size(GTK_PANED(vpaned), 10);
	gtk_widget_show(vpaned);

	/* first pc */	
	hpaned = gtk_hpaned_new();
	gtk_paned_set_handle_size(GTK_PANED(hpaned), 10);
	gtk_paned_set_gutter_size(GTK_PANED(hpaned), 10);
	gtk_paned_add1(GTK_PANED(vpaned), hpaned);
	gtk_widget_show(hpaned);

	/* The directories clist */
	dir_pc = gtk_clist_new( 1 );
	gtk_clist_set_column_title( GTK_CLIST(dir_pc), 0, "PC Directories" );
	gtk_clist_set_selection_mode( GTK_CLIST(dir_pc), GTK_SELECTION_BROWSE );
	gtk_signal_connect( GTK_OBJECT(dir_pc), "select_row",
	        	    (GtkSignalFunc)dir_select_row, GINT_TO_POINTER(PC) );
	gtk_clist_column_titles_show( GTK_CLIST(dir_pc) );
	gtk_signal_connect( GTK_OBJECT(dir_pc), "click_column",
	        	    GTK_SIGNAL_FUNC(choose_dir), GINT_TO_POINTER(PC) );
	gtk_widget_set_usize(dir_pc, 200, 200);   

	scrolled_win = gtk_scrolled_window_new(NULL, NULL);
	gtk_container_add(GTK_CONTAINER (scrolled_win), dir_pc);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
	        			GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);
	gtk_container_set_border_width (GTK_CONTAINER (scrolled_win), 0);
	gtk_paned_add1(GTK_PANED(hpaned), scrolled_win );
	gtk_widget_show(dir_pc);
	gtk_widget_show(scrolled_win);

	/* The files clist */
	files_pc = gtk_clist_new(3);
	gtk_clist_set_column_title( GTK_CLIST(files_pc), 0, "Type" );
	gtk_clist_set_column_width( GTK_CLIST(files_pc), 0, 20 );
	gtk_clist_set_column_title( GTK_CLIST(files_pc), 1, "Filename" );
	gtk_clist_set_column_width( GTK_CLIST(files_pc), 1, 250 );
	gtk_clist_set_column_title( GTK_CLIST(files_pc), 2, "Size" );
	gtk_clist_column_titles_show( GTK_CLIST(files_pc) );
	gtk_clist_set_selection_mode( GTK_CLIST(files_pc), GTK_SELECTION_MULTIPLE );
	gtk_clist_set_sort_column( GTK_CLIST(files_pc), 1 );
	gtk_signal_connect (GTK_OBJECT(files_pc), "click_column",
	        		   GTK_SIGNAL_FUNC(sort_files), GINT_TO_POINTER(PC) );
	gtk_signal_connect( GTK_OBJECT(files_pc), "select_row",
	        	    (GtkSignalFunc)file_select_row, GINT_TO_POINTER(PC) );
	gtk_signal_connect_object( GTK_OBJECT(files_pc), "event",
			    GTK_SIGNAL_FUNC(pop_menu), GTK_OBJECT (popmenu));
	
	scrolled_win = gtk_scrolled_window_new (NULL, NULL);
	gtk_container_add(GTK_CONTAINER(scrolled_win), files_pc);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
	        			GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);
	gtk_container_set_border_width (GTK_CONTAINER (scrolled_win), 0);
	gtk_paned_add2(GTK_PANED(hpaned), scrolled_win);
	gtk_widget_show(files_pc);
	gtk_widget_show(scrolled_win);

	/* now HP */	
	hpaned = gtk_hpaned_new();
	gtk_paned_set_handle_size(GTK_PANED(hpaned), 10);
	gtk_paned_set_gutter_size(GTK_PANED(hpaned), 10);
	gtk_paned_add2(GTK_PANED(vpaned), hpaned);
	gtk_widget_show(hpaned);

	/* The directories clist */
	dir_hp = gtk_clist_new( 1 );
	gtk_clist_set_column_title( GTK_CLIST(dir_hp), 0, "HP Directories" );
	gtk_clist_set_selection_mode( GTK_CLIST(dir_hp), GTK_SELECTION_BROWSE );
	gtk_signal_connect( GTK_OBJECT(dir_hp), "select_row",
	        	    (GtkSignalFunc)dir_select_row, GINT_TO_POINTER(HP) );
	gtk_clist_column_titles_show( GTK_CLIST(dir_hp) );
	gtk_signal_connect(GTK_OBJECT(dir_hp), "click_column",
	        		   GTK_SIGNAL_FUNC(choose_dir), GINT_TO_POINTER(HP) );
	gtk_widget_set_usize(dir_hp, 200, 0);
	  
	scrolled_win = gtk_scrolled_window_new(NULL, NULL);
	gtk_container_add(GTK_CONTAINER (scrolled_win), dir_hp);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
	        			GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);
	gtk_container_set_border_width (GTK_CONTAINER (scrolled_win), 0);
	gtk_paned_add1(GTK_PANED(hpaned), scrolled_win );
	gtk_widget_show(dir_hp);
	gtk_widget_show(scrolled_win);

	/* The files clist */
	files_hp = gtk_clist_new(3);
	gtk_clist_set_column_title( GTK_CLIST(files_hp), 0, "Type" );
	gtk_clist_set_column_width( GTK_CLIST(files_hp), 0, 20 );
	gtk_clist_set_column_title( GTK_CLIST(files_hp), 1, "Filename" );
	gtk_clist_set_column_width( GTK_CLIST(files_hp), 1, 250 );
	gtk_clist_set_column_title( GTK_CLIST(files_hp), 2, "Size" );
	gtk_clist_set_selection_mode( GTK_CLIST(files_hp), GTK_SELECTION_MULTIPLE );
	gtk_clist_set_sort_column( GTK_CLIST(files_hp), 1 );
	gtk_signal_connect(GTK_OBJECT(files_hp), "click_column",
	        		   GTK_SIGNAL_FUNC(sort_files), GINT_TO_POINTER(HP) );
	gtk_signal_connect (GTK_OBJECT(files_hp), "select_row",
	        	    (GtkSignalFunc)file_select_row, GINT_TO_POINTER(HP) );
	gtk_signal_connect_object( GTK_OBJECT(files_hp), "event",
			    GTK_SIGNAL_FUNC(pop_menu), GTK_OBJECT (popmenu));
	gtk_clist_column_titles_show( GTK_CLIST(files_hp) );

	scrolled_win = gtk_scrolled_window_new (NULL, NULL);
	gtk_container_add(GTK_CONTAINER(scrolled_win), files_hp);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
	        			GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);
	gtk_container_set_border_width (GTK_CONTAINER (scrolled_win), 0);
	gtk_paned_add2(GTK_PANED(hpaned), scrolled_win);
	gtk_widget_show(files_hp);
	gtk_widget_show(scrolled_win);

	/* status bar */
	status = gtk_frame_new( "Status:" );
	gtk_widget_set_usize(status, 0, 15);
	gtk_box_pack_start(GTK_BOX(main_vbox), status, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type( GTK_FRAME(status), GTK_SHADOW_NONE );
	gtk_widget_show(status);

	data_pc.current = NULL;		data_hp.current = NULL;

	/* call disconnect to make menu correct */
	connected = ONLINE;
	disconnect( NULL, GINT_TO_POINTER(1) );
	
	gtk_widget_show(window);

	/* init icons */
	init_pixmaps( window );

	data_pc.current = getcwd( NULL, 0 );
	refresh( NULL, GINT_TO_POINTER(PC) );
	
	/* make lists show correctly */
	gtk_clist_moveto( GTK_CLIST(dir_pc), 0, 0, 0, 0 );
	gtk_clist_select_row( GTK_CLIST(dir_pc), 0, 0 );
	whereami = PC;

//	if ( preferences.start_connected == TRUE )
//		hp_connect( NULL, NULL );
	
	gtk_main();

	return 0;
}		
