#!/usr/bin/perl
#
# Copyright 2007 Red Hat Inc.
# This crappy script written by Dave Airlie to avoid hassle of adding
# ids in every place.
#
use strict;
use warnings;
use Text::CSV_XS;

my $file = $ARGV[0];

my $atioutfile = 'ati_pciids_gen.h';
my $amdgpupcichipsetfile = 'amdgpu_pci_chipset_gen.h';
my $amdgpupcidevicematchfile = 'amdgpu_pci_device_match_gen.h';
my $amdgpuchipsetfile = 'amdgpu_chipset_gen.h';
my $amdgpuchipinfofile  = 'amdgpu_chipinfo_gen.h';

my %uniquechipsets;
my @uniquearray;
my $numunique = 0;

my $csv = Text::CSV_XS->new();

open (CSV, "<", $file) or die $!;

open (ATIOUT, ">", $atioutfile) or die;
open (PCICHIPSET, ">", $amdgpupcichipsetfile) or die;
open (PCIDEVICEMATCH, ">", $amdgpupcidevicematchfile) or die;
open (AMDGPUCHIPSET, ">", $amdgpuchipsetfile) or die;
open (AMDGPUCHIPINFO, ">", $amdgpuchipinfofile) or die;

print AMDGPUCHIPSET "/* This file is autogenerated please do not edit */\n";
print AMDGPUCHIPSET "SymTabRec AMDGPUChipsets[] = {\n";
print PCICHIPSET "/* This file is autogenerated please do not edit */\n";
print PCICHIPSET "static PciChipsets AMDGPUPciChipsets[] = {\n";
print PCIDEVICEMATCH "/* This file is autogenerated please do not edit */\n";
print PCIDEVICEMATCH "static const struct pci_id_match amdgpu_device_match[] = {\n";
print AMDGPUCHIPINFO "/* This file is autogenerated please do not edit */\n";
print AMDGPUCHIPINFO "static AMDGPUCardInfo AMDGPUCards[] = {\n";
while (<CSV>) {
  if ($csv->parse($_)) {
    my @columns = $csv->fields();

    if ((substr($columns[0], 0, 1) ne "#")) {

      print ATIOUT "#define PCI_CHIP_$columns[1] $columns[0]\n";

      if (($columns[2] ne "R128") && ($columns[2] ne "MACH64") && ($columns[2] ne "MACH32")) {
	print PCICHIPSET " { PCI_CHIP_$columns[1], PCI_CHIP_$columns[1], RES_SHARED_VGA },\n";
	
	print PCIDEVICEMATCH " ATI_DEVICE_MATCH( PCI_CHIP_$columns[1], 0 ),\n";

	print AMDGPUCHIPSET "  { PCI_CHIP_$columns[1], \"$columns[3]\" },\n";
	if (!$uniquechipsets{$columns[3]}) {
	    $uniquearray[$numunique] = $columns[3];
	    $uniquechipsets{$columns[3]} = ++$numunique;
	}

	print AMDGPUCHIPINFO " { $columns[0], CHIP_FAMILY_$columns[2] },\n";
      }
    }
  } else {
    my $err = $csv->error_input;
    print "Failed to parse line: $err";
  }
}

print AMDGPUCHIPINFO "};\n";
print AMDGPUCHIPSET "  { -1,                 NULL }\n};\n\nSymTabRec AMDGPUUniqueChipsets[] = {\n";
foreach (@uniquearray) {
	print AMDGPUCHIPSET "  { 0, \"$_\" },\n";
}
print AMDGPUCHIPSET "  { -1,                 NULL }\n};\n";
print PCICHIPSET " { -1,                 -1,                 RES_UNDEFINED }\n};\n";
print PCIDEVICEMATCH " { 0, 0, 0 }\n};\n";
close CSV;
close ATIOUT;
close PCICHIPSET;
close PCIDEVICEMATCH;
close AMDGPUCHIPSET;
close AMDGPUCHIPINFO;
