/*
  Copyright (C) 2000-2007

  Code contributed by Greg Collecutt, Joseph Hope and the xmds-devel team

  This file is part of xmds.

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/*
  $Id: xmds_integrate_rk4ex.h 1507 2007-08-15 09:47:34Z paultcochrane $
*/

/*! @file xmds_integrate_rk4ex.h
  @brief 

  More detailed explanation...
*/

#ifndef XMDS_INTEGRATE_RK4EX_H
#define XMDS_INTEGRATE_RK4EX_H

#include <xmds_integrate_ex.h>
#include <xmds_integrate_rk4.h>

// *****************************************************************************
// *****************************************************************************
//                              xmdsIntegrateRK4EX
// *****************************************************************************
// *****************************************************************************

//! Class to integrate equations using the fourth order Runge-Kutta method in the explicit picture
class xmdsIntegrateRK4EX : public xmdsIntegrateEX,
                           public xmdsIntegrateRK4 {

  public :

    //! Constructor of an xmdsIntegrateRK4EX object
    xmdsIntegrateRK4EX(
           const xmdsSimulation *const yourSimulation,
           const bool& yourVerboseMode);

  //! Destructor
  ~xmdsIntegrateRK4EX();

  //! Processes an element
  void processElement(
                      const Element *const yourElement);

  private :

    //! Write the integrate RK4EX prototypes to file
    void writePrototypes(
       FILE *const outfile) const;

  //! Write the integrate RK4EX routines to file
  void writeRoutines(
                     FILE *const outfile) const;

  //! Write the integrate RK4EX single step code to file
  void writeSingleStepCode(
                           FILE *const outfile,
                           const stepCaseEnum& stepCase) const;
};


#endif // XMDS_INTEGRATE_RK4EX_H
