// Resizes the window to a custom size
function webdeveloper_customResizeWindow()
{
    var contentWindow = webdeveloper_getContentWindow();

    window.openDialog("chrome://webdeveloper/content/dialogs/resize.xul", "webdeveloper-resize-dialog", "centerscreen,chrome,modal", contentWindow.outerWidth, contentWindow.outerHeight, contentWindow.innerWidth, contentWindow.innerHeight);
}

// Displays the current window size
function webdeveloper_displayWindowSize()
{
    var contentWindow = webdeveloper_getContentWindow();
    var stringBundle  = document.getElementById("webdeveloper-string-bundle");

    webdeveloper_message(stringBundle.getString("webdeveloper_windowSize"), stringBundle.getFormattedString("webdeveloper_displayWindowSizeResult", [contentWindow.outerWidth, contentWindow.outerHeight, contentWindow.innerWidth, contentWindow.innerHeight]));
}

// Displays the current window size in the title bar
function webdeveloper_displayWindowSizeInTitle(element)
{
    var contentDocument = webdeveloper_getContentDocument();

    // If the menu is checked
    if(webdeveloper_convertToBoolean(element.getAttribute("checked")))
    {
        var contentWindow = webdeveloper_getContentWindow();

        contentDocument.title += " - " + contentWindow.outerWidth + "x" + contentWindow.outerHeight + " [" + contentWindow.innerWidth + "x" + contentWindow.innerHeight + "]";

        window.addEventListener("resize", webdeveloper_updateWindowSizeInTitle, false);
    }
    else
    {
        var title = contentDocument.title;

        contentDocument.title = title.substring(0, title.lastIndexOf(" - "));

        // Try to remove the event listener
        try
        {
            window.removeEventListener("resize", webdeveloper_updateWindowSizeInTitle, false);
        }
        catch(exception)
        {
            // Do nothing
        }
    }

    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/empty.css", "webdeveloper-display-window-size-title");
}

// Resizes the window or viewport to the given width and height
function webdeveloper_resizeWindow(width, height, viewport)
{
    var windowX = window.screenX;
    var windowY = window.screenY;

    // If resizing the viewport
    if(viewport)
    {
        var contentWindow = webdeveloper_getContentWindow();

        contentWindow.innerHeight = height;
        contentWindow.innerWidth  = width;
    }
    else
    {
        window.resizeTo(width, height);
    }

    window.screenX = windowX;
    window.screenY = windowY;
}

// Updates the resize menu
function webdeveloper_updateResizeMenu(menu, suffix)
{
    var contentWindow         = webdeveloper_getContentWindow();
    var description           = null;
    var descriptionPreference = null;
    var height                = null;
    var heightPreference      = null;
    var menuItem              = document.createElement("menuitem");
    var resizeCount           = webdeveloper_getIntegerPreference("webdeveloper.resize.count", true);
    var resizeSeparator       = menu.getElementsByAttribute("id", "webdeveloper-resize-separator3-" + suffix)[0];
    var viewport              = null;
    var viewportHeight        = contentWindow.innerHeight;
    var viewportPreference    = false;
    var viewportWidth         = contentWindow.innerWidth;
    var width                 = null;
    var widthPreference       = null;
    var windowHeight          = contentWindow.outerHeight;
    var windowWidth           = contentWindow.outerWidth;

    webdeveloper_configureElementByAppliedStyle(document.getElementById("webdeveloper-display-window-size-title-" + suffix), "checked", "webdeveloper-display-window-size-title");
    webdeveloper_removeGeneratedMenuItems(menu);

    // Loop through the possible resize options
	for(var i = 1; i <= resizeCount; i++)
	{
        description = "webdeveloper.resize." + i + ".description";
        height      = "webdeveloper.resize." + i + ".height";
        viewport    = "webdeveloper.resize." + i + ".viewport";
        width       = "webdeveloper.resize." + i + ".width";

        // If the description, width and height are set
        if(webdeveloper_isPreferenceSet(description) && webdeveloper_isPreferenceSet(width) && webdeveloper_isPreferenceSet(height))
        {
    	    descriptionPreference = webdeveloper_getStringPreference(description, true);

            // If the description is not blank
            if(descriptionPreference != "")
            {
                heightPreference   = webdeveloper_getIntegerPreference(height, true);
                menuItem           = document.createElement("menuitem");
                viewportPreference = webdeveloper_getBooleanPreference(viewport, true);
                widthPreference    = webdeveloper_getIntegerPreference(width, true);

                // If the resize attributes match the current size
                if((viewportPreference && viewportWidth == widthPreference && viewportHeight == heightPreference) || (!viewportPreference && windowWidth == widthPreference && windowHeight == heightPreference))
                {
                    menuItem.setAttribute("checked", true);
                }

                menuItem.setAttribute("class", "webdeveloper-generated-menu");
                menuItem.setAttribute("label", descriptionPreference);
                menuItem.setAttribute("oncommand", "webdeveloper_resizeWindow(" + widthPreference + ", " + heightPreference + ", " + viewportPreference + ")");
                menuItem.setAttribute("type", "radio");

                menu.insertBefore(menuItem, resizeSeparator);
            }
        }
	}
}

// Updates the window size in the title bar
function webdeveloper_updateWindowSizeInTitle()
{
    var contentDocument = webdeveloper_getContentDocument();
    var contentWindow   = webdeveloper_getContentWindow();
    var title           = contentDocument.title;

    contentDocument.title = title.substring(0, title.lastIndexOf(" - ")) + " - " + contentWindow.outerWidth + "x" + contentWindow.outerHeight + " [" + contentWindow.innerWidth + "x" + contentWindow.innerHeight + "]";
}

// Zooms the content
function webdeveloper_zoom(zoomIn)
{
    var documentList   = webdeveloper_getDocuments(webdeveloper_getContentWindow());
    var documentLength = documentList.length;
    var factor         = 1.5;
    var imageList      = null;
    var pageDocument   = null;

    // Loop through the documents
    for(var i = 0; i < documentLength; i++)
    {
        pageDocument = documentList[i];
        imageList    = pageDocument.images;

        webdeveloper_zoomText(pageDocument.documentElement, zoomIn, factor);
        webdeveloper_zoomImages(imageList, zoomIn, factor);
    }
}

// Zooms the images
function webdeveloper_zoomImages(imageList, zoomIn, factor)
{
    var height      = null;
    var image       = null;
    var imageLength = imageList.length;
    var width       = null;

    // Loop through the images
    for(var i = 0; i < imageLength; i++)
    {
        image  = imageList[i];
        height = image.height;
        width  = image.width;

        // If the width and height are set
        if(width && height)
        {
            // If zooming in
            if(zoomIn)
            {
                image.setAttribute("width", (width * factor));
                image.setAttribute("height", (height * factor));
            }
            else
            {
                image.setAttribute("width", (width / factor));
                image.setAttribute("height", (height / factor));
            }
        }

        height = null;
        width  = null;
    }
}

// Zooms the text
function webdeveloper_zoomText(node, zoomIn, factor)
{
    var computedStyle = node.ownerDocument.defaultView.getComputedStyle(node, null);

    // If the computed style is set
    if(computedStyle)
    {
        var childNode       = null;
        var childNodeList   = node.childNodes;
        var childNodeLength = childNodeList.length;
        var fontSize        = computedStyle.getPropertyCSSValue("font-size");
        var lineHeight      = computedStyle.getPropertyCSSValue("line-height");

        // Loop through the child nodes
        for(var i = 0; i < childNodeLength; i++)
        {
            childNode = childNodeList[i];

            // If this is an element
            if(childNode.nodeType == Node.ELEMENT_NODE)
            {
                webdeveloper_zoomText(childNode, zoomIn, factor);
            }
        }

        // If the font size is set and is in pixels
        if(fontSize && fontSize.primitiveType == CSSPrimitiveValue.CSS_PX)
        {
            // If zooming in
            if(zoomIn)
            {
                node.style.fontSize = (fontSize.getFloatValue(CSSPrimitiveValue.CSS_PX) * factor) + "px";
            }
            else
            {
                node.style.fontSize = (fontSize.getFloatValue(CSSPrimitiveValue.CSS_PX) / factor) + "px";
            }
        }

        // If the line height is set and is in pixels
        if(lineHeight && lineHeight.primitiveType == CSSPrimitiveValue.CSS_PX)
        {
            // If zooming in
            if(zoomIn)
            {
                node.style.lineHeight = (lineHeight.getFloatValue(CSSPrimitiveValue.CSS_PX) * factor) + "px";
            }
            else
            {
                node.style.lineHeight = (lineHeight.getFloatValue(CSSPrimitiveValue.CSS_PX) / factor) + "px";
            }
        }
    }
}
