declare variable $respVar external;
declare variable $predictorName external;

<root>
{
for $x in distinct-values(root()/root/row/elem[@name="x"])
    order by $x
return
    let $rows := for $row in root()/root/row
                 where $row/elem[@name="x"] = $x
                 return $row

    let $ys := for $y in distinct-values($rows/elem[@name="y"])
               order by $y
               return $y

    for $y in $ys
    return
        let $yrows := for $r in $rows
                      where $r/elem[@name="y"]=$y
                      return $r

        return
            for $row in $yrows
            where $row/elem[@name=$respVar] = 1
            return
                <row>
                <elem name="predictor">{$predictorName}</elem>
                <elem name="x">{string($row/elem[@name="x"])}</elem>
                <elem name="y">{string($row/elem[@name="y"])}</elem>

                {
                    for $e in $row/elem
                    where $e[@name!="x"]        and 
                          $e[@name!="y"]        and
                          $e[@name!="pres_abs"]
                    return
                        <elem name="{replace($e/@name, "categorical:", "")}">{string($e)}</elem>
                }
                </row>
}
</root>