/**
 * This file is a part of VideoCut package.
 * ---------------------------------------------------------------------- 
 * Copyright (C) 2007-2008 troorl
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * ---------------------------------------------------------------------- 
 *
 * @author troorl <troorl@gmail.com>
 */

#ifndef _TPAGES_H_
#define _TPAGES_H_

#include <QtGui>
#include <QWidget>
#include "TFontChoser.h"
#include "TColorChoser.h"

class TMainPage : public QWidget
{
	Q_OBJECT
	public:
		TMainPage(QWidget *parent = 0, Qt::WindowFlags f = 0);
		
		// Result picture parametres
		QSpinBox *countFrames;
		QSpinBox *countHor;
		QSpinBox *indentBorder;
		QSpinBox *indentItems;
		QSpinBox *scale;
		
		// indents
		QTimeEdit *indentTimeStart;
		QTimeEdit *indentTimeFinish;
		
		//style
		QComboBox *styleBox;
		
		//quality
		QSpinBox *quality;
		
		// default image format
		QComboBox *formatImg;
		
		// show logo
		QCheckBox *logo;
};

class TFileInfoPage : public QWidget
{
	Q_OBJECT
	public:
		TFileInfoPage(QWidget *parent = 0);
		
		QCheckBox *infoName;
		QCheckBox *infoSize;
		QCheckBox *infoDuration;
		QCheckBox *infoResolution;
		QCheckBox *infoVideo;
		QCheckBox *infoAudio;	
};

class TFontsPage : public QWidget
{
	Q_OBJECT
	public:
		TFontsPage(QWidget *parent = 0);
	
		//GUI
		TFontChoser *f1; // font for metainfo
		TFontChoser *f2; // font for time
		
};

class TColorPage : public QWidget
{
	Q_OBJECT
	public:
		TColorPage(QWidget *parent = 0);
		
		//GUI
		TColorChoser *colorInfoText;
		TColorChoser *colorInfoInfo;
		TColorChoser *colorBackground;
};

#endif
