/* vtgprojectexecuter.c generated by valac 0.12.1.1-323029-dirty, the Vala compiler
 * generated from vtgprojectexecuter.vala, do not modify */

/*
 *  vtgprojectexecuter.vala - Vala developer toys for GEdit
 *  
 *  Copyright (C) 2008 - Andrea Del Signore <sejerpz@tin.it>
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *   
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330,
 *  Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <vbf.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/wait.h>


#define VTG_TYPE_PROJECT_EXECUTER (vtg_project_executer_get_type ())
#define VTG_PROJECT_EXECUTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PROJECT_EXECUTER, VtgProjectExecuter))
#define VTG_PROJECT_EXECUTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PROJECT_EXECUTER, VtgProjectExecuterClass))
#define VTG_IS_PROJECT_EXECUTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PROJECT_EXECUTER))
#define VTG_IS_PROJECT_EXECUTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PROJECT_EXECUTER))
#define VTG_PROJECT_EXECUTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PROJECT_EXECUTER, VtgProjectExecuterClass))

typedef struct _VtgProjectExecuter VtgProjectExecuter;
typedef struct _VtgProjectExecuterClass VtgProjectExecuterClass;
typedef struct _VtgProjectExecuterPrivate VtgProjectExecuterPrivate;

#define VTG_TYPE_PLUGIN_INSTANCE (vtg_plugin_instance_get_type ())
#define VTG_PLUGIN_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstance))
#define VTG_PLUGIN_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstanceClass))
#define VTG_IS_PLUGIN_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PLUGIN_INSTANCE))
#define VTG_IS_PLUGIN_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PLUGIN_INSTANCE))
#define VTG_PLUGIN_INSTANCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstanceClass))

typedef struct _VtgPluginInstance VtgPluginInstance;
typedef struct _VtgPluginInstanceClass VtgPluginInstanceClass;

#define VTG_TYPE_OUTPUT_VIEW (vtg_output_view_get_type ())
#define VTG_OUTPUT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_OUTPUT_VIEW, VtgOutputView))
#define VTG_OUTPUT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_OUTPUT_VIEW, VtgOutputViewClass))
#define VTG_IS_OUTPUT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_OUTPUT_VIEW))
#define VTG_IS_OUTPUT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_OUTPUT_VIEW))
#define VTG_OUTPUT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_OUTPUT_VIEW, VtgOutputViewClass))

typedef struct _VtgOutputView VtgOutputView;
typedef struct _VtgOutputViewClass VtgOutputViewClass;

#define VTG_TYPE_OUTPUT_TYPES (vtg_output_types_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _VtgProjectExecuter {
	GObject parent_instance;
	VtgProjectExecuterPrivate * priv;
};

struct _VtgProjectExecuterClass {
	GObjectClass parent_class;
};

struct _VtgProjectExecuterPrivate {
	VtgPluginInstance* _plugin_instance;
	guint _child_watch_id;
	GPid child_pid;
};

typedef enum  {
	VTG_OUTPUT_TYPES_MESSAGE,
	VTG_OUTPUT_TYPES_ERROR,
	VTG_OUTPUT_TYPES_CHILD_PROCESS,
	VTG_OUTPUT_TYPES_BUILD,
	VTG_OUTPUT_TYPES_AUTO_BUILD,
	VTG_OUTPUT_TYPES_SEARCH
} VtgOutputTypes;


static gpointer vtg_project_executer_parent_class = NULL;
static GType vtg_project_executer_type_id = 0;

GType vtg_project_executer_get_type (void) G_GNUC_CONST;
GType vtg_project_executer_register_type (GTypeModule * module);
GType vtg_plugin_instance_get_type (void) G_GNUC_CONST;
GType vtg_plugin_instance_register_type (GTypeModule * module);
#define VTG_PROJECT_EXECUTER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VTG_TYPE_PROJECT_EXECUTER, VtgProjectExecuterPrivate))
enum  {
	VTG_PROJECT_EXECUTER_DUMMY_PROPERTY,
	VTG_PROJECT_EXECUTER_IS_EXECUTING
};
VtgProjectExecuter* vtg_project_executer_new (VtgPluginInstance* plugin_instance);
VtgProjectExecuter* vtg_project_executer_construct (GType object_type, VtgPluginInstance* plugin_instance);
gboolean vtg_project_executer_execute (VtgProjectExecuter* self, VbfProject* project, const gchar* command_line);
GType vtg_output_view_get_type (void) G_GNUC_CONST;
GType vtg_output_view_register_type (GTypeModule * module);
VtgOutputView* vtg_plugin_instance_get_output_view (VtgPluginInstance* self);
void vtg_output_view_clean_output (VtgOutputView* self);
GType vtg_output_types_get_type (void) G_GNUC_CONST;
void vtg_output_view_log_message (VtgOutputView* self, VtgOutputTypes output_type, const gchar* message);
static void vtg_project_executer_on_child_watch (VtgProjectExecuter* self, GPid pid, gint status);
static void _vtg_project_executer_on_child_watch_gchild_watch_func (GPid pid, gint status, gpointer self);
void vtg_output_view_start_watch (VtgOutputView* self, VtgOutputTypes output_type, guint id, gint stdo, gint stde, gint stdi);
void vtg_output_view_activate (VtgOutputView* self);
void vtg_project_executer_kill_last (VtgProjectExecuter* self);
void vtg_output_view_stop_watch (VtgOutputView* self, guint id);
gboolean vtg_project_executer_get_is_executing (VtgProjectExecuter* self);
static void vtg_project_executer_finalize (GObject* obj);
static void _vala_vtg_project_executer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


VtgProjectExecuter* vtg_project_executer_construct (GType object_type, VtgPluginInstance* plugin_instance) {
	VtgProjectExecuter * self = NULL;
	g_return_val_if_fail (plugin_instance != NULL, NULL);
	self = (VtgProjectExecuter*) g_object_new (object_type, NULL);
	self->priv->_plugin_instance = plugin_instance;
	return self;
}


VtgProjectExecuter* vtg_project_executer_new (VtgPluginInstance* plugin_instance) {
	return vtg_project_executer_construct (VTG_TYPE_PROJECT_EXECUTER, plugin_instance);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _vtg_project_executer_on_child_watch_gchild_watch_func (GPid pid, gint status, gpointer self) {
	vtg_project_executer_on_child_watch (self, pid, status);
}


gboolean vtg_project_executer_execute (VtgProjectExecuter* self, VbfProject* project, const gchar* command_line) {
	gboolean result = FALSE;
	gchar* _tmp0_;
	gchar* working_dir;
	gint stdo = 0;
	gint stde = 0;
	gint stdi = 0;
	VtgOutputView* _tmp1_ = NULL;
	VtgOutputView* _tmp2_;
	VtgOutputView* log;
	gchar* cmd = NULL;
	gchar** cmds = NULL;
	gint cmds_length1 = 0;
	gint _cmds_size_ = 0;
	gchar** _tmp8_ = NULL;
	gint _tmp9_;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* start_message;
	gint _tmp12_;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_;
	GPid _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (project != NULL, FALSE);
	g_return_val_if_fail (command_line != NULL, FALSE);
	if (self->priv->_child_watch_id != 0) {
		result = FALSE;
		return result;
	}
	_tmp0_ = g_strdup (project->id);
	working_dir = _tmp0_;
	_tmp1_ = vtg_plugin_instance_get_output_view (self->priv->_plugin_instance);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	log = _tmp2_;
	vtg_output_view_clean_output (log);
	if (command_line == NULL) {
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		_tmp3_ = g_strdup_printf ("No command line specified for project %s", project->name);
		_tmp4_ = _tmp3_;
		vtg_output_view_log_message (log, VTG_OUTPUT_TYPES_MESSAGE, _tmp4_);
		_g_free0 (_tmp4_);
		result = FALSE;
		_g_free0 (cmd);
		_g_object_unref0 (log);
		_g_free0 (working_dir);
		return result;
	} else {
		gboolean _tmp5_;
		_tmp5_ = g_str_has_prefix (command_line, "/");
		if (!_tmp5_) {
			gchar* _tmp6_ = NULL;
			_tmp6_ = g_build_filename (project->id, command_line, NULL);
			_g_free0 (cmd);
			cmd = _tmp6_;
		} else {
			gchar* _tmp7_;
			_tmp7_ = g_strdup (command_line);
			_g_free0 (cmd);
			cmd = _tmp7_;
		}
	}
	g_shell_parse_argv (cmd, &_tmp9_, &_tmp8_, &_inner_error_);
	cmds = (_vala_array_free (cmds, cmds_length1, (GDestroyNotify) g_free), NULL);
	cmds = _tmp8_;
	cmds_length1 = _tmp9_;
	if (_inner_error_ != NULL) {
		cmds = (_vala_array_free (cmds, cmds_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (cmd);
		_g_object_unref0 (log);
		goto __catch26_g_error;
	}
	_tmp10_ = _ ("Starting from project %s executable: %s\n");
	_tmp11_ = g_strdup_printf (_tmp10_, project->name, cmd);
	start_message = _tmp11_;
	vtg_output_view_log_message (log, VTG_OUTPUT_TYPES_MESSAGE, start_message);
	_tmp12_ = strlen (start_message);
	_tmp13_ = g_strnfill ((gsize) (_tmp12_ - 1), '-');
	_tmp14_ = _tmp13_;
	_tmp15_ = g_strdup_printf ("%s\n\n", _tmp14_);
	_tmp16_ = _tmp15_;
	vtg_output_view_log_message (log, VTG_OUTPUT_TYPES_MESSAGE, _tmp16_);
	_g_free0 (_tmp16_);
	_g_free0 (_tmp14_);
	g_spawn_async_with_pipes (working_dir, cmds, NULL, G_SPAWN_SEARCH_PATH | G_SPAWN_DO_NOT_REAP_CHILD, NULL, NULL, &_tmp17_, &_tmp18_, &_tmp19_, &_tmp20_, &_inner_error_);
	self->priv->child_pid = _tmp17_;
	stdi = _tmp18_;
	stdo = _tmp19_;
	stde = _tmp20_;
	if (_inner_error_ != NULL) {
		_g_free0 (start_message);
		cmds = (_vala_array_free (cmds, cmds_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (cmd);
		_g_object_unref0 (log);
		goto __catch26_g_error;
	}
	if (self->priv->child_pid != ((GPid) 0)) {
		guint _tmp21_;
		_tmp21_ = g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, self->priv->child_pid, _vtg_project_executer_on_child_watch_gchild_watch_func, g_object_ref (self), g_object_unref);
		self->priv->_child_watch_id = _tmp21_;
		vtg_output_view_start_watch (log, VTG_OUTPUT_TYPES_CHILD_PROCESS, self->priv->_child_watch_id, stdo, stde, stdi);
		vtg_output_view_activate (log);
		g_signal_emit_by_name (self, "process-start");
	} else {
		vtg_output_view_log_message (log, VTG_OUTPUT_TYPES_ERROR, "error spawning process\n");
	}
	result = TRUE;
	_g_free0 (start_message);
	cmds = (_vala_array_free (cmds, cmds_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (cmd);
	_g_object_unref0 (log);
	_g_free0 (working_dir);
	return result;
	_g_free0 (start_message);
	cmds = (_vala_array_free (cmds, cmds_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (cmd);
	_g_object_unref0 (log);
	goto __finally26;
	__catch26_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("vtgprojectexecuter.vala:89: Error spawning build process: %s", err->message);
		result = FALSE;
		_g_error_free0 (err);
		_g_free0 (working_dir);
		return result;
	}
	__finally26:
	_g_free0 (working_dir);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return FALSE;
}


void vtg_project_executer_kill_last (VtgProjectExecuter* self) {
	g_return_if_fail (self != NULL);
	if (((gint) self->priv->child_pid) != 0) {
		gint _tmp0_;
		_tmp0_ = kill ((gint) self->priv->child_pid, 9);
		if (_tmp0_ != 0) {
			g_warning ("vtgprojectexecuter.vala:98: exec error: kill failed");
		}
	}
}


static void vtg_project_executer_on_child_watch (VtgProjectExecuter* self, GPid pid, gint status) {
	VtgOutputView* _tmp0_ = NULL;
	VtgOutputView* _tmp1_;
	VtgOutputView* log;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gint _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vtg_plugin_instance_get_output_view (self->priv->_plugin_instance);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	log = _tmp1_;
	g_spawn_close_pid (self->priv->child_pid);
	vtg_output_view_stop_watch (log, self->priv->_child_watch_id);
	_tmp2_ = _ ("\nprocess terminated with exit status %d\n");
	_tmp3_ = g_strdup_printf (_tmp2_, status);
	_tmp4_ = _tmp3_;
	vtg_output_view_log_message (log, VTG_OUTPUT_TYPES_MESSAGE, _tmp4_);
	_g_free0 (_tmp4_);
	self->priv->_child_watch_id = (guint) 0;
	_tmp5_ = WEXITSTATUS (status);
	g_signal_emit_by_name (self, "process-exit", _tmp5_);
	self->priv->child_pid = (GPid) 0;
	_g_object_unref0 (log);
}


gboolean vtg_project_executer_get_is_executing (VtgProjectExecuter* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_child_watch_id != 0;
	return result;
}


static void vtg_project_executer_class_init (VtgProjectExecuterClass * klass) {
	vtg_project_executer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (VtgProjectExecuterPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_vtg_project_executer_get_property;
	G_OBJECT_CLASS (klass)->finalize = vtg_project_executer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_PROJECT_EXECUTER_IS_EXECUTING, g_param_spec_boolean ("is-executing", "is-executing", "is-executing", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("process_start", VTG_TYPE_PROJECT_EXECUTER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("process_exit", VTG_TYPE_PROJECT_EXECUTER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
}


static void vtg_project_executer_instance_init (VtgProjectExecuter * self) {
	self->priv = VTG_PROJECT_EXECUTER_GET_PRIVATE (self);
	self->priv->_plugin_instance = NULL;
	self->priv->_child_watch_id = (guint) 0;
	self->priv->child_pid = (GPid) 0;
}


static void vtg_project_executer_finalize (GObject* obj) {
	VtgProjectExecuter * self;
	self = VTG_PROJECT_EXECUTER (obj);
	G_OBJECT_CLASS (vtg_project_executer_parent_class)->finalize (obj);
}


GType vtg_project_executer_get_type (void) {
	return vtg_project_executer_type_id;
}


GType vtg_project_executer_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (VtgProjectExecuterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vtg_project_executer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VtgProjectExecuter), 0, (GInstanceInitFunc) vtg_project_executer_instance_init, NULL };
	vtg_project_executer_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "VtgProjectExecuter", &g_define_type_info, 0);
	return vtg_project_executer_type_id;
}


static void _vala_vtg_project_executer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	VtgProjectExecuter * self;
	self = VTG_PROJECT_EXECUTER (object);
	switch (property_id) {
		case VTG_PROJECT_EXECUTER_IS_EXECUTING:
		g_value_set_boolean (value, vtg_project_executer_get_is_executing (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



