/* vtgplugininstance.c generated by valac 0.12.1.1-323029-dirty, the Vala compiler
 * generated from vtgplugininstance.vala, do not modify */

/*
 *  vtgplugininstance.vala - Vala developer toys for GEdit
 *  
 *  Copyright (C) 2008 - Andrea Del Signore <sejerpz@tin.it>
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *   
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNaESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330,
 *  Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gedit/gedit-window.h>
#include <valagee.h>
#include <gedit/gedit-view.h>
#include <gedit/gedit-document.h>
#include <vbf.h>
#include <libpeas-gtk/peas-gtk.h>
#include <girepository.h>
#include <gmodule.h>
#include <libpeas/peas.h>
#include <gedit/gedit-tab.h>
#include <stdlib.h>
#include <string.h>
#include <gedit/gedit-app.h>
#include <gtk/gtk.h>
#include <afrodite.h>
#include <gio/gio.h>
#include <gedit/gedit-encodings.h>


#define VTG_TYPE_PLUGIN_INSTANCE (vtg_plugin_instance_get_type ())
#define VTG_PLUGIN_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstance))
#define VTG_PLUGIN_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstanceClass))
#define VTG_IS_PLUGIN_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PLUGIN_INSTANCE))
#define VTG_IS_PLUGIN_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PLUGIN_INSTANCE))
#define VTG_PLUGIN_INSTANCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstanceClass))

typedef struct _VtgPluginInstance VtgPluginInstance;
typedef struct _VtgPluginInstanceClass VtgPluginInstanceClass;
typedef struct _VtgPluginInstancePrivate VtgPluginInstancePrivate;

#define VTG_TYPE_PROJECT_MANAGER_UI (vtg_project_manager_ui_get_type ())
#define VTG_PROJECT_MANAGER_UI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PROJECT_MANAGER_UI, VtgProjectManagerUi))
#define VTG_PROJECT_MANAGER_UI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PROJECT_MANAGER_UI, VtgProjectManagerUiClass))
#define VTG_IS_PROJECT_MANAGER_UI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PROJECT_MANAGER_UI))
#define VTG_IS_PROJECT_MANAGER_UI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PROJECT_MANAGER_UI))
#define VTG_PROJECT_MANAGER_UI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PROJECT_MANAGER_UI, VtgProjectManagerUiClass))

typedef struct _VtgProjectManagerUi VtgProjectManagerUi;
typedef struct _VtgProjectManagerUiClass VtgProjectManagerUiClass;

#define VTG_TYPE_SOURCE_OUTLINER (vtg_source_outliner_get_type ())
#define VTG_SOURCE_OUTLINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_SOURCE_OUTLINER, VtgSourceOutliner))
#define VTG_SOURCE_OUTLINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_SOURCE_OUTLINER, VtgSourceOutlinerClass))
#define VTG_IS_SOURCE_OUTLINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_SOURCE_OUTLINER))
#define VTG_IS_SOURCE_OUTLINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_SOURCE_OUTLINER))
#define VTG_SOURCE_OUTLINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_SOURCE_OUTLINER, VtgSourceOutlinerClass))

typedef struct _VtgSourceOutliner VtgSourceOutliner;
typedef struct _VtgSourceOutlinerClass VtgSourceOutlinerClass;

#define VTG_TYPE_OUTPUT_VIEW (vtg_output_view_get_type ())
#define VTG_OUTPUT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_OUTPUT_VIEW, VtgOutputView))
#define VTG_OUTPUT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_OUTPUT_VIEW, VtgOutputViewClass))
#define VTG_IS_OUTPUT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_OUTPUT_VIEW))
#define VTG_IS_OUTPUT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_OUTPUT_VIEW))
#define VTG_OUTPUT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_OUTPUT_VIEW, VtgOutputViewClass))

typedef struct _VtgOutputView VtgOutputView;
typedef struct _VtgOutputViewClass VtgOutputViewClass;

#define VTG_TYPE_PROJECT_VIEW (vtg_project_view_get_type ())
#define VTG_PROJECT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PROJECT_VIEW, VtgProjectView))
#define VTG_PROJECT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PROJECT_VIEW, VtgProjectViewClass))
#define VTG_IS_PROJECT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PROJECT_VIEW))
#define VTG_IS_PROJECT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PROJECT_VIEW))
#define VTG_PROJECT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PROJECT_VIEW, VtgProjectViewClass))

typedef struct _VtgProjectView VtgProjectView;
typedef struct _VtgProjectViewClass VtgProjectViewClass;

#define VTG_TYPE_SOURCE_BOOKMARKS (vtg_source_bookmarks_get_type ())
#define VTG_SOURCE_BOOKMARKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_SOURCE_BOOKMARKS, VtgSourceBookmarks))
#define VTG_SOURCE_BOOKMARKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_SOURCE_BOOKMARKS, VtgSourceBookmarksClass))
#define VTG_IS_SOURCE_BOOKMARKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_SOURCE_BOOKMARKS))
#define VTG_IS_SOURCE_BOOKMARKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_SOURCE_BOOKMARKS))
#define VTG_SOURCE_BOOKMARKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_SOURCE_BOOKMARKS, VtgSourceBookmarksClass))

typedef struct _VtgSourceBookmarks VtgSourceBookmarks;
typedef struct _VtgSourceBookmarksClass VtgSourceBookmarksClass;

#define VTG_TYPE_SYMBOL_COMPLETION (vtg_symbol_completion_get_type ())
#define VTG_SYMBOL_COMPLETION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_SYMBOL_COMPLETION, VtgSymbolCompletion))
#define VTG_SYMBOL_COMPLETION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_SYMBOL_COMPLETION, VtgSymbolCompletionClass))
#define VTG_IS_SYMBOL_COMPLETION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_SYMBOL_COMPLETION))
#define VTG_IS_SYMBOL_COMPLETION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_SYMBOL_COMPLETION))
#define VTG_SYMBOL_COMPLETION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_SYMBOL_COMPLETION, VtgSymbolCompletionClass))

typedef struct _VtgSymbolCompletion VtgSymbolCompletion;
typedef struct _VtgSymbolCompletionClass VtgSymbolCompletionClass;

#define VTG_TYPE_BRACKET_COMPLETION (vtg_bracket_completion_get_type ())
#define VTG_BRACKET_COMPLETION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_BRACKET_COMPLETION, VtgBracketCompletion))
#define VTG_BRACKET_COMPLETION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_BRACKET_COMPLETION, VtgBracketCompletionClass))
#define VTG_IS_BRACKET_COMPLETION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_BRACKET_COMPLETION))
#define VTG_IS_BRACKET_COMPLETION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_BRACKET_COMPLETION))
#define VTG_BRACKET_COMPLETION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_BRACKET_COMPLETION, VtgBracketCompletionClass))

typedef struct _VtgBracketCompletion VtgBracketCompletion;
typedef struct _VtgBracketCompletionClass VtgBracketCompletionClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))

#define VTG_TYPE_PLUGIN (vtg_plugin_get_type ())
#define VTG_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PLUGIN, VtgPlugin))
#define VTG_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PLUGIN, VtgPluginClass))
#define VTG_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PLUGIN))
#define VTG_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PLUGIN))
#define VTG_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PLUGIN, VtgPluginClass))

typedef struct _VtgPlugin VtgPlugin;
typedef struct _VtgPluginClass VtgPluginClass;

#define VTG_TYPE_PROJECTS (vtg_projects_get_type ())
#define VTG_PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PROJECTS, VtgProjects))
#define VTG_PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PROJECTS, VtgProjectsClass))
#define VTG_IS_PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PROJECTS))
#define VTG_IS_PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PROJECTS))
#define VTG_PROJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PROJECTS, VtgProjectsClass))

typedef struct _VtgProjects VtgProjects;
typedef struct _VtgProjectsClass VtgProjectsClass;

#define VTG_TYPE_PROJECT_MANAGER (vtg_project_manager_get_type ())
#define VTG_PROJECT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PROJECT_MANAGER, VtgProjectManager))
#define VTG_PROJECT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PROJECT_MANAGER, VtgProjectManagerClass))
#define VTG_IS_PROJECT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PROJECT_MANAGER))
#define VTG_IS_PROJECT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PROJECT_MANAGER))
#define VTG_PROJECT_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PROJECT_MANAGER, VtgProjectManagerClass))

typedef struct _VtgProjectManager VtgProjectManager;
typedef struct _VtgProjectManagerClass VtgProjectManagerClass;

#define VTG_TYPE_SOURCE_BOOKMARK (vtg_source_bookmark_get_type ())
#define VTG_SOURCE_BOOKMARK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_SOURCE_BOOKMARK, VtgSourceBookmark))
#define VTG_SOURCE_BOOKMARK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_SOURCE_BOOKMARK, VtgSourceBookmarkClass))
#define VTG_IS_SOURCE_BOOKMARK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_SOURCE_BOOKMARK))
#define VTG_IS_SOURCE_BOOKMARK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_SOURCE_BOOKMARK))
#define VTG_SOURCE_BOOKMARK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_SOURCE_BOOKMARK, VtgSourceBookmarkClass))

typedef struct _VtgSourceBookmark VtgSourceBookmark;
typedef struct _VtgSourceBookmarkClass VtgSourceBookmarkClass;
typedef struct _VtgSourceBookmarkPrivate VtgSourceBookmarkPrivate;
#define _vtg_source_bookmark_unref0(var) ((var == NULL) ? NULL : (var = (vtg_source_bookmark_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _VtgProjectManagerPrivate VtgProjectManagerPrivate;

#define VTG_TYPE_VCS_TYPES (vtg_vcs_types_get_type ())

#define VTG_TYPE_CONFIGURATION (vtg_configuration_get_type ())
#define VTG_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_CONFIGURATION, VtgConfiguration))
#define VTG_CONFIGURATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_CONFIGURATION, VtgConfigurationClass))
#define VTG_IS_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_CONFIGURATION))
#define VTG_IS_CONFIGURATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_CONFIGURATION))
#define VTG_CONFIGURATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_CONFIGURATION, VtgConfigurationClass))

typedef struct _VtgConfiguration VtgConfiguration;
typedef struct _VtgConfigurationClass VtgConfigurationClass;
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))

struct _VtgPluginInstance {
	GObject parent_instance;
	VtgPluginInstancePrivate * priv;
};

struct _VtgPluginInstanceClass {
	GObjectClass parent_class;
};

struct _VtgPluginInstancePrivate {
	GeditWindow* _window;
	VtgProjectManagerUi* _project_manager_ui;
	VtgSourceOutliner* _source_outliner;
	VtgOutputView* _output_view;
	VtgProjectView* _project_view;
	VtgSourceBookmarks* _bookmarks;
	ValaList* _scs;
	ValaHashMap* _bcs;
	GeditView* _last_created_view;
	gulong _tab_add_sig_id;
	gulong _tab_removed_sig_id;
	ValaHashMap* open_docs;
};

struct _VtgSourceBookmark {
	GTypeInstance parent_instance;
	volatile int ref_count;
	VtgSourceBookmarkPrivate * priv;
	gchar* uri;
	gint line;
	gint column;
};

struct _VtgSourceBookmarkClass {
	GTypeClass parent_class;
	void (*finalize) (VtgSourceBookmark *self);
};

typedef enum  {
	VTG_VCS_TYPES_NONE,
	VTG_VCS_TYPES_GIT,
	VTG_VCS_TYPES_BZR,
	VTG_VCS_TYPES_SVN
} VtgVcsTypes;

struct _VtgProjectManager {
	GObject parent_instance;
	VtgProjectManagerPrivate * priv;
	gchar* filename;
	gboolean is_default;
	ValaList* exec_targets;
	ValaList* all_vala_sources;
	VtgVcsTypes vcs_type;
	gchar* changelog_uri;
};

struct _VtgProjectManagerClass {
	GObjectClass parent_class;
};


static gpointer vtg_plugin_instance_parent_class = NULL;
extern VtgPlugin* vtg_plugin_main_instance;
static GType vtg_plugin_instance_type_id = 0;

GType vtg_plugin_instance_get_type (void) G_GNUC_CONST;
GType vtg_plugin_instance_register_type (GTypeModule * module);
GType vtg_project_manager_ui_get_type (void) G_GNUC_CONST;
GType vtg_project_manager_ui_register_type (GTypeModule * module);
GType vtg_source_outliner_get_type (void) G_GNUC_CONST;
GType vtg_source_outliner_register_type (GTypeModule * module);
GType vtg_output_view_get_type (void) G_GNUC_CONST;
GType vtg_output_view_register_type (GTypeModule * module);
GType vtg_project_view_get_type (void) G_GNUC_CONST;
GType vtg_project_view_register_type (GTypeModule * module);
GType vtg_source_bookmarks_get_type (void) G_GNUC_CONST;
GType vtg_source_bookmarks_register_type (GTypeModule * module);
GType vtg_symbol_completion_get_type (void) G_GNUC_CONST;
GType vtg_symbol_completion_register_type (GTypeModule * module);
GType vtg_bracket_completion_get_type (void) G_GNUC_CONST;
GType vtg_bracket_completion_register_type (GTypeModule * module);
#define VTG_PLUGIN_INSTANCE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstancePrivate))
enum  {
	VTG_PLUGIN_INSTANCE_DUMMY_PROPERTY,
	VTG_PLUGIN_INSTANCE_OUTPUT_VIEW,
	VTG_PLUGIN_INSTANCE_PROJECT_MANAGER_UI,
	VTG_PLUGIN_INSTANCE_SOURCE_OUTLINER,
	VTG_PLUGIN_INSTANCE_PROJECT_VIEW,
	VTG_PLUGIN_INSTANCE_WINDOW,
	VTG_PLUGIN_INSTANCE_BOOKMARKS
};
void vtg_source_outliner_set_active_view (VtgSourceOutliner* self, GeditView* value);
void vtg_plugin_instance_uninitialize_document (VtgPluginInstance* self, GeditDocument* doc);
VtgPluginInstance* vtg_plugin_instance_new (GeditWindow* window);
VtgPluginInstance* vtg_plugin_instance_construct (GType object_type, GeditWindow* window);
VtgProjectView* vtg_project_view_new (VtgPluginInstance* plugin_instance);
VtgProjectView* vtg_project_view_construct (GType object_type, VtgPluginInstance* plugin_instance);
GType vtg_plugin_get_type (void) G_GNUC_CONST;
GType vtg_plugin_register_type (GTypeModule * module);
GType vtg_projects_get_type (void) G_GNUC_CONST;
GType vtg_projects_register_type (GTypeModule * module);
VtgProjects* vtg_plugin_get_projects (VtgPlugin* self);
GType vtg_project_manager_get_type (void) G_GNUC_CONST;
GType vtg_project_manager_register_type (GTypeModule * module);
ValaList* vtg_projects_get_project_managers (VtgProjects* self);
void vtg_project_view_add_project (VtgProjectView* self, VbfProject* project);
VbfProject* vtg_project_manager_get_project (VtgProjectManager* self);
VtgSourceBookmarks* vtg_source_bookmarks_new (VtgPluginInstance* plugin_instance);
VtgSourceBookmarks* vtg_source_bookmarks_construct (GType object_type, VtgPluginInstance* plugin_instance);
static void vtg_plugin_instance_on_current_bookmark_changed (VtgPluginInstance* self, VtgSourceBookmarks* sender);
static void _vtg_plugin_instance_on_current_bookmark_changed_vtg_source_bookmarks_current_bookmark_changed (VtgSourceBookmarks* _sender, gpointer self);
static void vtg_plugin_instance_on_tab_added (GeditWindow* sender, GeditTab* tab, VtgPluginInstance* instance);
static void vtg_plugin_instance_on_tab_removed (GeditWindow* sender, GeditTab* tab, VtgPluginInstance* instance);
VtgOutputView* vtg_output_view_new (VtgPluginInstance* plugin_instance);
VtgOutputView* vtg_output_view_construct (GType object_type, VtgPluginInstance* plugin_instance);
VtgProjectManagerUi* vtg_project_manager_ui_new (VtgPluginInstance* plugin_instance);
VtgProjectManagerUi* vtg_project_manager_ui_construct (GType object_type, VtgPluginInstance* plugin_instance);
void vtg_plugin_instance_initialize_views (VtgPluginInstance* self);
void vtg_plugin_instance_initialize_document (VtgPluginInstance* self, GeditDocument* doc);
gpointer vtg_source_bookmark_ref (gpointer instance);
void vtg_source_bookmark_unref (gpointer instance);
GParamSpec* vtg_param_spec_source_bookmark (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vtg_value_set_source_bookmark (GValue* value, gpointer v_object);
void vtg_value_take_source_bookmark (GValue* value, gpointer v_object);
gpointer vtg_value_get_source_bookmark (const GValue* value);
GType vtg_source_bookmark_get_type (void) G_GNUC_CONST;
GType vtg_source_bookmark_register_type (GTypeModule * module);
VtgSourceBookmark* vtg_source_bookmarks_get_current_bookmark (VtgSourceBookmarks* self);
GeditTab* vtg_plugin_instance_activate_uri (VtgPluginInstance* self, const gchar* uri, gint line, gint col);
static void vtg_plugin_instance_check_vala_source_for_add (VtgPluginInstance* instance, VtgProjectManager* project_manager, GeditDocument* doc);
gboolean vtg_utils_is_vala_doc (GeditDocument* doc);
gchar* vtg_utils_get_document_name (GeditDocument* doc);
gchar* vtg_utils_get_document_uri (GeditDocument* doc);
static void vtg_plugin_instance_check_vala_source_for_remove (VtgPluginInstance* instance, VtgProjectManager* project_manager, GeditDocument* doc);
VtgProjectManager* vtg_projects_get_project_manager_for_document (VtgProjects* self, GeditDocument* document, GError** error);
void vtg_plugin_instance_initialize_view (VtgPluginInstance* self, VtgProjectManager* project, GeditView* view);
VtgSourceOutliner* vtg_plugin_instance_get_source_outliner (VtgPluginInstance* self);
void vtg_utils_trace (const gchar* format, ...);
void vtg_plugin_instance_uninitialize_view (VtgPluginInstance* self, GeditView* view);
GType vtg_vcs_types_get_type (void) G_GNUC_CONST;
gboolean vtg_project_manager_get_automanaged (VtgProjectManager* self);
void vtg_projects_close_project (VtgProjects* self, VtgProjectManager* project);
GType vtg_configuration_get_type (void) G_GNUC_CONST;
GType vtg_configuration_register_type (GTypeModule * module);
VtgConfiguration* vtg_plugin_get_config (VtgPlugin* self);
gboolean vtg_configuration_get_sourcecode_outliner_enabled (VtgConfiguration* self);
void vtg_plugin_instance_activate_sourcecode_outliner (VtgPluginInstance* self);
gboolean vtg_configuration_get_symbol_enabled (VtgConfiguration* self);
gboolean vtg_plugin_instance_scs_contains (VtgPluginInstance* self, GeditView* view);
void vtg_plugin_instance_activate_symbol (VtgPluginInstance* self, VtgProjectManager* project, GeditView* view);
gboolean vtg_configuration_get_bracket_enabled (VtgConfiguration* self);
gboolean vtg_plugin_instance_bcs_contains (VtgPluginInstance* self, GeditView* view);
void vtg_plugin_instance_activate_bracket (VtgPluginInstance* self, GeditView* view);
static void vtg_plugin_instance_on_notify_language (GeditDocument* sender, GParamSpec* pspec, VtgPluginInstance* instance);
static void vtg_plugin_instance_on_document_saved (GeditDocument* doc, void* arg1, VtgPluginInstance* self);
VtgSymbolCompletion* vtg_plugin_instance_scs_find_from_view (VtgPluginInstance* self, GeditView* view);
void vtg_plugin_instance_deactivate_symbol (VtgPluginInstance* self, VtgSymbolCompletion* sc);
void vtg_plugin_instance_deactivate_bracket (VtgPluginInstance* self, GeditView* view);
VtgSourceOutliner* vtg_source_outliner_new (VtgPluginInstance* plugin_instance);
VtgSourceOutliner* vtg_source_outliner_construct (GType object_type, VtgPluginInstance* plugin_instance);
void vtg_plugin_instance_deactivate_sourcecode_outliner (VtgPluginInstance* self);
VtgBracketCompletion* vtg_bracket_completion_new (VtgPluginInstance* plugin_instance, GeditView* view);
VtgBracketCompletion* vtg_bracket_completion_construct (GType object_type, VtgPluginInstance* plugin_instance, GeditView* view);
void vtg_bracket_completion_deactivate (VtgBracketCompletion* self);
AfroditeCompletionEngine* vtg_project_manager_get_completion_for_target (VtgProjectManager* self, VbfTarget* target);
AfroditeCompletionEngine* vtg_project_manager_get_completion_for_file (VtgProjectManager* self, const gchar* uri);
VtgSymbolCompletion* vtg_symbol_completion_new (VtgPluginInstance* plugin_instance, GeditView* view, AfroditeCompletionEngine* completion_engine);
VtgSymbolCompletion* vtg_symbol_completion_construct (GType object_type, VtgPluginInstance* plugin_instance, GeditView* view, AfroditeCompletionEngine* completion_engine);
void vtg_symbol_completion_deactivate (VtgSymbolCompletion* self);
void vtg_plugin_instance_deactivate_symbols (VtgPluginInstance* self);
void vtg_plugin_instance_deactivate_brackets (VtgPluginInstance* self);
VtgBracketCompletion* vtg_plugin_instance_bcs_find_from_view (VtgPluginInstance* self, GeditView* view);
GeditView* vtg_symbol_completion_get_view (VtgSymbolCompletion* self);
gboolean vtg_plugin_instance_on_idle_cursor_mode (VtgPluginInstance* self);
static gboolean _vtg_plugin_instance_on_idle_cursor_mode_gsource_func (gpointer self);
void vtg_plugin_instance_activate_display_name (VtgPluginInstance* self, const gchar* display_name, gint line, gint col);
void vtg_plugin_instance_unbind_completion_engine (VtgPluginInstance* self, AfroditeCompletionEngine* engine);
AfroditeCompletionEngine* vtg_symbol_completion_get_completion_engine (VtgSymbolCompletion* self);
void vtg_symbol_completion_set_completion_engine (VtgSymbolCompletion* self, AfroditeCompletionEngine* value);
void vtg_source_outliner_cleanup_completion_engine (VtgSourceOutliner* self, AfroditeCompletionEngine* engine);
void vtg_plugin_instance_bind_completion_engine_with_target (VtgPluginInstance* self, VbfTarget* target, AfroditeCompletionEngine* engine);
VbfTarget* vtg_projects_get_target_for_document (VtgProjects* self, GeditDocument* document);
GeditView* vtg_source_outliner_get_active_view (VtgSourceOutliner* self);
void vtg_source_outliner_setup_completion_engine (VtgSourceOutliner* self, AfroditeCompletionEngine* engine);
VtgProjectManager* vtg_project_view_get_current_project (VtgProjectView* self);
VtgOutputView* vtg_plugin_instance_get_output_view (VtgPluginInstance* self);
VtgProjectManagerUi* vtg_plugin_instance_get_project_manager_ui (VtgPluginInstance* self);
VtgProjectView* vtg_plugin_instance_get_project_view (VtgPluginInstance* self);
GeditWindow* vtg_plugin_instance_get_window (VtgPluginInstance* self);
VtgSourceBookmarks* vtg_plugin_instance_get_bookmarks (VtgPluginInstance* self);
static void vtg_plugin_instance_finalize (GObject* obj);
static void _vala_vtg_plugin_instance_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


static void _vtg_plugin_instance_on_current_bookmark_changed_vtg_source_bookmarks_current_bookmark_changed (VtgSourceBookmarks* _sender, gpointer self) {
	vtg_plugin_instance_on_current_bookmark_changed (self, _sender);
}


VtgPluginInstance* vtg_plugin_instance_construct (GType object_type, GeditWindow* window) {
	VtgPluginInstance * self = NULL;
	VtgProjectView* _tmp0_ = NULL;
	VtgSourceBookmarks* _tmp7_ = NULL;
	gulong _tmp8_;
	gulong _tmp9_;
	VtgOutputView* _tmp10_ = NULL;
	VtgProjectManagerUi* _tmp11_ = NULL;
	GList* _tmp12_ = NULL;
	g_return_val_if_fail (window != NULL, NULL);
	self = (VtgPluginInstance*) g_object_new (object_type, NULL);
	self->priv->_window = window;
	_tmp0_ = vtg_project_view_new (self);
	_g_object_unref0 (self->priv->_project_view);
	self->priv->_project_view = _tmp0_;
	{
		VtgProjects* _tmp1_ = NULL;
		ValaList* _tmp2_ = NULL;
		ValaList* _tmp3_;
		ValaList* _prj_list;
		gint _tmp4_;
		gint _prj_size;
		gint _prj_index;
		_tmp1_ = vtg_plugin_get_projects (vtg_plugin_main_instance);
		_tmp2_ = vtg_projects_get_project_managers (_tmp1_);
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_prj_list = _tmp3_;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _prj_list);
		_prj_size = _tmp4_;
		_prj_index = -1;
		while (TRUE) {
			gpointer _tmp5_ = NULL;
			VtgProjectManager* prj;
			VbfProject* _tmp6_ = NULL;
			_prj_index = _prj_index + 1;
			if (!(_prj_index < _prj_size)) {
				break;
			}
			_tmp5_ = vala_list_get (_prj_list, _prj_index);
			prj = (VtgProjectManager*) _tmp5_;
			_tmp6_ = vtg_project_manager_get_project (prj);
			vtg_project_view_add_project (self->priv->_project_view, _tmp6_);
			_g_object_unref0 (prj);
		}
		_vala_iterable_unref0 (_prj_list);
	}
	_tmp7_ = vtg_source_bookmarks_new (self);
	_g_object_unref0 (self->priv->_bookmarks);
	self->priv->_bookmarks = _tmp7_;
	g_signal_connect_object (self->priv->_bookmarks, "current-bookmark-changed", (GCallback) _vtg_plugin_instance_on_current_bookmark_changed_vtg_source_bookmarks_current_bookmark_changed, self, 0);
	_tmp8_ = g_signal_connect_after (self->priv->_window, "tab-added", (GCallback) vtg_plugin_instance_on_tab_added, self);
	self->priv->_tab_add_sig_id = _tmp8_;
	_tmp9_ = g_signal_connect (self->priv->_window, "tab-removed", (GCallback) vtg_plugin_instance_on_tab_removed, self);
	self->priv->_tab_removed_sig_id = _tmp9_;
	_tmp10_ = vtg_output_view_new (self);
	_g_object_unref0 (self->priv->_output_view);
	self->priv->_output_view = _tmp10_;
	_tmp11_ = vtg_project_manager_ui_new (self);
	_g_object_unref0 (self->priv->_project_manager_ui);
	self->priv->_project_manager_ui = _tmp11_;
	vtg_plugin_instance_initialize_views (self);
	_tmp12_ = gedit_window_get_documents (self->priv->_window);
	{
		GList* doc_collection;
		GList* doc_it;
		doc_collection = _tmp12_;
		for (doc_it = doc_collection; doc_it != NULL; doc_it = doc_it->next) {
			GeditDocument* _tmp13_;
			GeditDocument* doc;
			_tmp13_ = _g_object_ref0 ((GeditDocument*) doc_it->data);
			doc = _tmp13_;
			{
				vtg_plugin_instance_initialize_document (self, doc);
				_g_object_unref0 (doc);
			}
		}
		_g_list_free0 (doc_collection);
	}
	return self;
}


VtgPluginInstance* vtg_plugin_instance_new (GeditWindow* window) {
	return vtg_plugin_instance_construct (VTG_TYPE_PLUGIN_INSTANCE, window);
}


static void vtg_plugin_instance_on_current_bookmark_changed (VtgPluginInstance* self, VtgSourceBookmarks* sender) {
	VtgSourceBookmark* _tmp0_ = NULL;
	VtgSourceBookmark* book;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	_tmp0_ = vtg_source_bookmarks_get_current_bookmark (sender);
	book = _tmp0_;
	if (book != NULL) {
		GeditTab* _tmp1_ = NULL;
		GeditTab* _tmp2_;
		_tmp1_ = vtg_plugin_instance_activate_uri (self, book->uri, book->line, book->column);
		_tmp2_ = _tmp1_;
		_g_object_unref0 (_tmp2_);
	}
	_vtg_source_bookmark_unref0 (book);
}


static void vtg_plugin_instance_check_vala_source_for_add (VtgPluginInstance* instance, VtgProjectManager* project_manager, GeditDocument* doc) {
	gboolean _tmp0_;
	g_return_if_fail (instance != NULL);
	g_return_if_fail (project_manager != NULL);
	g_return_if_fail (doc != NULL);
	_tmp0_ = vtg_utils_is_vala_doc (doc);
	if (_tmp0_) {
		VbfProject* _tmp1_ = NULL;
		VbfGroup* _tmp2_ = NULL;
		VbfGroup* group;
		VbfTarget* _tmp3_ = NULL;
		VbfTarget* target;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		VbfSource* _tmp6_ = NULL;
		VbfSource* _tmp7_;
		VbfSource* source;
		_tmp1_ = vtg_project_manager_get_project (project_manager);
		_tmp2_ = vbf_project_get_group (_tmp1_, "Sources");
		group = _tmp2_;
		_tmp3_ = vbf_group_get_target_for_id (group, "Default");
		target = _tmp3_;
		_tmp4_ = vtg_utils_get_document_name (doc);
		_tmp5_ = _tmp4_;
		_tmp6_ = vbf_target_get_source (target, _tmp5_);
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp5_);
		source = _tmp7_;
		if (source == NULL) {
			gchar* _tmp8_ = NULL;
			gchar* _tmp9_;
			VbfSource* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
			gchar* _tmp12_;
			gboolean _tmp13_;
			VbfProject* _tmp15_ = NULL;
			_tmp8_ = vtg_utils_get_document_name (doc);
			_tmp9_ = _tmp8_;
			_tmp10_ = vbf_source_new_with_type (target, _tmp9_, VBF_FILE_TYPES_VALA_SOURCE);
			_g_object_unref0 (source);
			source = _tmp10_;
			_g_free0 (_tmp9_);
			_tmp11_ = vtg_utils_get_document_uri (doc);
			_tmp12_ = _tmp11_;
			_tmp13_ = _tmp12_ == NULL;
			_g_free0 (_tmp12_);
			if (_tmp13_) {
				gchar* _tmp14_ = NULL;
				_tmp14_ = vtg_utils_get_document_name (doc);
				_g_free0 (((VbfFile*) source)->filename);
				((VbfFile*) source)->filename = _tmp14_;
			}
			vbf_target_add_source (target, source);
			vala_map_set ((ValaMap*) instance->priv->open_docs, doc, source);
			_tmp15_ = vtg_project_manager_get_project (project_manager);
			vbf_project_update (_tmp15_);
		}
		_g_object_unref0 (source);
		_g_object_unref0 (target);
		_g_object_unref0 (group);
	}
}


static void vtg_plugin_instance_check_vala_source_for_remove (VtgPluginInstance* instance, VtgProjectManager* project_manager, GeditDocument* doc) {
	VbfProject* _tmp0_ = NULL;
	VbfGroup* _tmp1_ = NULL;
	VbfGroup* group;
	VbfTarget* _tmp2_ = NULL;
	VbfTarget* target;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	VbfSource* _tmp5_ = NULL;
	VbfSource* _tmp6_;
	VbfSource* source;
	gboolean _tmp8_;
	g_return_if_fail (instance != NULL);
	g_return_if_fail (project_manager != NULL);
	g_return_if_fail (doc != NULL);
	_tmp0_ = vtg_project_manager_get_project (project_manager);
	_tmp1_ = vbf_project_get_group (_tmp0_, "Sources");
	group = _tmp1_;
	_tmp2_ = vbf_group_get_target_for_id (group, "Default");
	target = _tmp2_;
	_tmp3_ = vtg_utils_get_document_name (doc);
	_tmp4_ = _tmp3_;
	_tmp5_ = vbf_target_get_source (target, _tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	source = _tmp6_;
	if (source != NULL) {
		VbfProject* _tmp7_ = NULL;
		vbf_target_remove_source (target, source);
		_tmp7_ = vtg_project_manager_get_project (project_manager);
		vbf_project_update (_tmp7_);
	}
	_tmp8_ = vala_map_contains ((ValaMap*) instance->priv->open_docs, doc);
	if (_tmp8_) {
		vala_map_remove ((ValaMap*) instance->priv->open_docs, doc);
	}
	_g_object_unref0 (source);
	_g_object_unref0 (target);
	_g_object_unref0 (group);
}


static void vtg_plugin_instance_on_tab_added (GeditWindow* sender, GeditTab* tab, VtgPluginInstance* instance) {
	GeditDocument* _tmp0_ = NULL;
	GeditDocument* _tmp1_;
	GeditDocument* doc;
	VtgProjects* _tmp2_ = NULL;
	VtgProjectManager* _tmp3_ = NULL;
	VtgProjectManager* project_manager;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp8_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (sender != NULL);
	g_return_if_fail (tab != NULL);
	g_return_if_fail (instance != NULL);
	_tmp0_ = gedit_tab_get_document (tab);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	doc = _tmp1_;
	_tmp2_ = vtg_plugin_get_projects (vtg_plugin_main_instance);
	_tmp3_ = vtg_projects_get_project_manager_for_document (_tmp2_, doc, &_inner_error_);
	project_manager = _tmp3_;
	if (_inner_error_ != NULL) {
		goto __catch44_g_error;
	}
	if (project_manager != NULL) {
		VbfProject* _tmp6_ = NULL;
		_tmp6_ = vtg_project_manager_get_project (project_manager);
		_tmp5_ = _tmp6_ != NULL;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		VbfProject* _tmp7_ = NULL;
		_tmp7_ = vtg_project_manager_get_project (project_manager);
		_tmp4_ = g_strcmp0 (_tmp7_->id, "vtg-default-project") == 0;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		vtg_plugin_instance_check_vala_source_for_add (instance, project_manager, doc);
	}
	_tmp8_ = vtg_utils_is_vala_doc (doc);
	if (_tmp8_) {
		GeditView* _tmp9_ = NULL;
		GeditView* _tmp10_;
		GeditView* view;
		VtgSourceOutliner* _tmp11_ = NULL;
		_tmp9_ = gedit_tab_get_view (tab);
		_tmp10_ = _g_object_ref0 (_tmp9_);
		view = _tmp10_;
		vtg_plugin_instance_initialize_view (instance, project_manager, view);
		_tmp11_ = vtg_plugin_instance_get_source_outliner (instance);
		if (_tmp11_ != NULL) {
			gchar* _tmp12_ = NULL;
			gchar* _tmp13_;
			VtgSourceOutliner* _tmp14_ = NULL;
			_tmp12_ = vtg_utils_get_document_name (doc);
			_tmp13_ = _tmp12_;
			vtg_utils_trace ("vtgplugininstance.vala:186: setup outliner for %s", _tmp13_);
			_g_free0 (_tmp13_);
			_tmp14_ = vtg_plugin_instance_get_source_outliner (instance);
			vtg_source_outliner_set_active_view (_tmp14_, view);
		}
		_g_object_unref0 (view);
	}
	vtg_plugin_instance_initialize_document (instance, doc);
	_g_object_unref0 (project_manager);
	goto __finally44;
	__catch44_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_critical ("vtgplugininstance.vala:193: error: %s", err->message);
		_g_error_free0 (err);
	}
	__finally44:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (doc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (doc);
}


static void vtg_plugin_instance_on_tab_removed (GeditWindow* sender, GeditTab* tab, VtgPluginInstance* instance) {
	GeditView* _tmp0_ = NULL;
	GeditView* _tmp1_;
	GeditView* view;
	GeditDocument* _tmp2_ = NULL;
	GeditDocument* _tmp3_;
	GeditDocument* doc;
	VtgProjects* _tmp4_ = NULL;
	VtgProjectManager* _tmp5_ = NULL;
	VtgProjectManager* project_manager;
	GError * _inner_error_ = NULL;
	g_return_if_fail (sender != NULL);
	g_return_if_fail (tab != NULL);
	g_return_if_fail (instance != NULL);
	_tmp0_ = gedit_tab_get_view (tab);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	view = _tmp1_;
	_tmp2_ = gedit_tab_get_document (tab);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	doc = _tmp3_;
	vtg_plugin_instance_uninitialize_view (instance, view);
	vtg_plugin_instance_uninitialize_document (instance, doc);
	_tmp4_ = vtg_plugin_get_projects (vtg_plugin_main_instance);
	_tmp5_ = vtg_projects_get_project_manager_for_document (_tmp4_, doc, &_inner_error_);
	project_manager = _tmp5_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (doc);
		_g_object_unref0 (view);
		goto __catch45_g_error;
	}
	if (project_manager != NULL) {
		if (project_manager->is_default) {
			vtg_plugin_instance_check_vala_source_for_remove (instance, project_manager, doc);
		} else {
			gboolean _tmp6_;
			_tmp6_ = vtg_project_manager_get_automanaged (project_manager);
			if (_tmp6_) {
				gboolean other_docs_opened;
				GeditApp* _tmp7_ = NULL;
				GList* _tmp8_ = NULL;
				other_docs_opened = FALSE;
				_tmp7_ = gedit_app_get_default ();
				_tmp8_ = gedit_app_get_documents (_tmp7_);
				{
					GList* document_collection;
					GList* document_it;
					document_collection = _tmp8_;
					for (document_it = document_collection; document_it != NULL; document_it = document_it->next) {
						GeditDocument* document;
						document = (GeditDocument*) document_it->data;
						{
							if (document != doc) {
								VtgProjects* _tmp9_ = NULL;
								VtgProjectManager* _tmp10_ = NULL;
								VtgProjectManager* _tmp11_;
								VtgProjectManager* _tmp12_;
								gboolean _tmp13_;
								_tmp9_ = vtg_plugin_get_projects (vtg_plugin_main_instance);
								_tmp10_ = vtg_projects_get_project_manager_for_document (_tmp9_, document, &_inner_error_);
								_tmp11_ = _tmp10_;
								if (_inner_error_ != NULL) {
									_g_list_free0 (document_collection);
									_g_object_unref0 (project_manager);
									_g_object_unref0 (doc);
									_g_object_unref0 (view);
									goto __catch45_g_error;
								}
								_tmp12_ = _tmp11_;
								_tmp13_ = _tmp12_ == project_manager;
								_g_object_unref0 (_tmp12_);
								if (_tmp13_) {
									other_docs_opened = TRUE;
								}
							}
						}
					}
					_g_list_free0 (document_collection);
				}
				if (!other_docs_opened) {
					VtgProjects* _tmp14_ = NULL;
					_tmp14_ = vtg_plugin_get_projects (vtg_plugin_main_instance);
					vtg_projects_close_project (_tmp14_, project_manager);
				}
			}
		}
	}
	_g_object_unref0 (project_manager);
	_g_object_unref0 (doc);
	_g_object_unref0 (view);
	goto __finally45;
	__catch45_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_critical ("vtgplugininstance.vala:229: error: %s", err->message);
		_g_error_free0 (err);
	}
	__finally45:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void vtg_plugin_instance_initialize_views (VtgPluginInstance* self) {
	GList* _tmp0_ = NULL;
	gboolean _tmp7_ = FALSE;
	VtgConfiguration* _tmp8_ = NULL;
	gboolean _tmp9_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gedit_window_get_views (self->priv->_window);
	{
		GList* view_collection;
		GList* view_it;
		view_collection = _tmp0_;
		for (view_it = view_collection; view_it != NULL; view_it = view_it->next) {
			GeditView* _tmp1_;
			GeditView* view;
			_tmp1_ = _g_object_ref0 ((GeditView*) view_it->data);
			view = _tmp1_;
			{
				GtkTextBuffer* _tmp2_ = NULL;
				GeditDocument* _tmp3_;
				GeditDocument* doc;
				gboolean _tmp4_;
				_tmp2_ = gtk_text_view_get_buffer ((GtkTextView*) view);
				_tmp3_ = _g_object_ref0 (GEDIT_DOCUMENT (_tmp2_));
				doc = _tmp3_;
				_tmp4_ = vtg_utils_is_vala_doc (doc);
				if (_tmp4_) {
					VtgProjects* _tmp5_ = NULL;
					VtgProjectManager* _tmp6_ = NULL;
					VtgProjectManager* project;
					_tmp5_ = vtg_plugin_get_projects (vtg_plugin_main_instance);
					_tmp6_ = vtg_projects_get_project_manager_for_document (_tmp5_, doc, &_inner_error_);
					project = _tmp6_;
					if (_inner_error_ != NULL) {
						goto __catch46_g_error;
					}
					vtg_plugin_instance_initialize_view (self, project, view);
					_g_object_unref0 (project);
					goto __finally46;
					__catch46_g_error:
					{
						GError * err;
						err = _inner_error_;
						_inner_error_ = NULL;
						g_critical ("vtgplugininstance.vala:242: error: %s", err->message);
						_g_error_free0 (err);
					}
					__finally46:
					if (_inner_error_ != NULL) {
						_g_object_unref0 (doc);
						_g_object_unref0 (view);
						_g_list_free0 (view_collection);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				_g_object_unref0 (doc);
				_g_object_unref0 (view);
			}
		}
		_g_list_free0 (view_collection);
	}
	_tmp8_ = vtg_plugin_get_config (vtg_plugin_main_instance);
	_tmp9_ = vtg_configuration_get_sourcecode_outliner_enabled (_tmp8_);
	if (_tmp9_) {
		_tmp7_ = self->priv->_source_outliner == NULL;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		vtg_plugin_instance_activate_sourcecode_outliner (self);
	}
}


void vtg_plugin_instance_initialize_view (VtgPluginInstance* self, VtgProjectManager* project, GeditView* view) {
	gboolean _tmp0_ = FALSE;
	VtgConfiguration* _tmp1_ = NULL;
	gboolean _tmp2_;
	gboolean _tmp4_ = FALSE;
	VtgConfiguration* _tmp5_ = NULL;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (project != NULL);
	g_return_if_fail (view != NULL);
	_tmp1_ = vtg_plugin_get_config (vtg_plugin_main_instance);
	_tmp2_ = vtg_configuration_get_symbol_enabled (_tmp1_);
	if (_tmp2_) {
		gboolean _tmp3_;
		_tmp3_ = vtg_plugin_instance_scs_contains (self, view);
		_tmp0_ = !_tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		vtg_plugin_instance_activate_symbol (self, project, view);
	}
	_tmp5_ = vtg_plugin_get_config (vtg_plugin_main_instance);
	_tmp6_ = vtg_configuration_get_bracket_enabled (_tmp5_);
	if (_tmp6_) {
		gboolean _tmp7_;
		_tmp7_ = vtg_plugin_instance_bcs_contains (self, view);
		_tmp4_ = !_tmp7_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		vtg_plugin_instance_activate_bracket (self, view);
	}
}


void vtg_plugin_instance_initialize_document (VtgPluginInstance* self, GeditDocument* doc) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (doc != NULL);
	g_signal_connect (doc, "notify::language", (GCallback) vtg_plugin_instance_on_notify_language, self);
	g_signal_connect (doc, "saved", (GCallback) vtg_plugin_instance_on_document_saved, self);
}


void vtg_plugin_instance_uninitialize_view (VtgPluginInstance* self, GeditView* view) {
	VtgSymbolCompletion* _tmp0_ = NULL;
	VtgSymbolCompletion* sc;
	g_return_if_fail (self != NULL);
	g_return_if_fail (view != NULL);
	_tmp0_ = vtg_plugin_instance_scs_find_from_view (self, view);
	sc = _tmp0_;
	if (sc != NULL) {
		vtg_plugin_instance_deactivate_symbol (self, sc);
	}
	vtg_plugin_instance_deactivate_bracket (self, view);
	_g_object_unref0 (sc);
}


void vtg_plugin_instance_activate_sourcecode_outliner (VtgPluginInstance* self) {
	VtgSourceOutliner* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = vtg_source_outliner_new (self);
	_g_object_unref0 (self->priv->_source_outliner);
	self->priv->_source_outliner = _tmp0_;
}


void vtg_plugin_instance_deactivate_sourcecode_outliner (VtgPluginInstance* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->_source_outliner != NULL) {
		_g_object_unref0 (self->priv->_source_outliner);
		self->priv->_source_outliner = NULL;
	}
}


void vtg_plugin_instance_activate_bracket (VtgPluginInstance* self, GeditView* view) {
	VtgBracketCompletion* _tmp0_ = NULL;
	VtgBracketCompletion* bc;
	g_return_if_fail (self != NULL);
	g_return_if_fail (view != NULL);
	_tmp0_ = vtg_bracket_completion_new (self, view);
	bc = _tmp0_;
	vala_map_set ((ValaMap*) self->priv->_bcs, view, bc);
	_g_object_unref0 (bc);
}


void vtg_plugin_instance_deactivate_bracket (VtgPluginInstance* self, GeditView* view) {
	gpointer _tmp0_ = NULL;
	VtgBracketCompletion* bc;
	g_return_if_fail (self != NULL);
	g_return_if_fail (view != NULL);
	_tmp0_ = vala_map_get ((ValaMap*) self->priv->_bcs, view);
	bc = (VtgBracketCompletion*) _tmp0_;
	if (bc != NULL) {
		vtg_bracket_completion_deactivate (bc);
	}
	vala_map_remove ((ValaMap*) self->priv->_bcs, view);
	_g_object_unref0 (bc);
}


void vtg_plugin_instance_activate_symbol (VtgPluginInstance* self, VtgProjectManager* project, GeditView* view) {
	GtkTextBuffer* _tmp0_ = NULL;
	GeditDocument* _tmp1_;
	GeditDocument* doc;
	gchar* _tmp2_ = NULL;
	gchar* file;
	AfroditeCompletionEngine* completion;
	VtgSymbolCompletion* _tmp11_ = NULL;
	VtgSymbolCompletion* sc;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (project != NULL);
	g_return_if_fail (view != NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) view);
	_tmp1_ = _g_object_ref0 (GEDIT_DOCUMENT (_tmp0_));
	doc = _tmp1_;
	g_return_if_fail (doc != NULL);
	_tmp2_ = vtg_utils_get_document_name (doc);
	file = _tmp2_;
	if (file == NULL) {
		_g_free0 (file);
		_g_object_unref0 (doc);
		return;
	}
	completion = NULL;
	if (project->is_default) {
		VbfProject* _tmp3_ = NULL;
		VbfGroup* _tmp4_ = NULL;
		VbfGroup* group;
		VbfTarget* _tmp5_ = NULL;
		VbfTarget* target;
		AfroditeCompletionEngine* _tmp6_ = NULL;
		_tmp3_ = vtg_project_manager_get_project (project);
		_tmp4_ = vbf_project_get_group (_tmp3_, "Sources");
		group = _tmp4_;
		_tmp5_ = vbf_group_get_target_for_id (group, "Default");
		target = _tmp5_;
		_tmp6_ = vtg_project_manager_get_completion_for_target (project, target);
		_g_object_unref0 (completion);
		completion = _tmp6_;
		_g_object_unref0 (target);
		_g_object_unref0 (group);
	} else {
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		gchar* _tmp9_;
		AfroditeCompletionEngine* _tmp10_ = NULL;
		_tmp7_ = g_filename_to_uri (file, NULL, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_CONVERT_ERROR) {
				goto __catch47_g_convert_error;
			}
			_g_object_unref0 (completion);
			_g_free0 (file);
			_g_object_unref0 (doc);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp9_ = _tmp8_;
		_tmp10_ = vtg_project_manager_get_completion_for_file (project, _tmp9_);
		_g_object_unref0 (completion);
		completion = _tmp10_;
		_g_free0 (_tmp9_);
		goto __finally47;
		__catch47_g_convert_error:
		{
			GError * err;
			err = _inner_error_;
			_inner_error_ = NULL;
			g_critical ("vtgplugininstance.vala:324: ConvertError: %s", err->message);
			_g_error_free0 (err);
		}
		__finally47:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (completion);
			_g_free0 (file);
			_g_object_unref0 (doc);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (completion == NULL) {
		g_warning ("vtgplugininstance.vala:328: No completion for file %s", file);
		_g_object_unref0 (completion);
		_g_free0 (file);
		_g_object_unref0 (doc);
		return;
	}
	_tmp11_ = vtg_symbol_completion_new (self, view, completion);
	sc = _tmp11_;
	vala_collection_add ((ValaCollection*) self->priv->_scs, sc);
	_g_object_unref0 (sc);
	_g_object_unref0 (completion);
	_g_free0 (file);
	_g_object_unref0 (doc);
}


void vtg_plugin_instance_deactivate_symbol (VtgPluginInstance* self, VtgSymbolCompletion* sc) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (sc != NULL);
	vtg_symbol_completion_deactivate (sc);
	vala_collection_remove ((ValaCollection*) self->priv->_scs, sc);
}


void vtg_plugin_instance_deactivate_symbols (VtgPluginInstance* self) {
	gint size;
	g_return_if_fail (self != NULL);
	size = 0;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gint _tmp1_;
		gint _tmp3_;
		gpointer _tmp4_ = NULL;
		VtgSymbolCompletion* _tmp5_;
		_tmp1_ = vala_collection_get_size ((ValaCollection*) self->priv->_scs);
		if (_tmp1_ > 0) {
			gint _tmp2_;
			_tmp2_ = vala_collection_get_size ((ValaCollection*) self->priv->_scs);
			_tmp0_ = _tmp2_ != size;
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp3_ = vala_collection_get_size ((ValaCollection*) self->priv->_scs);
		size = _tmp3_;
		_tmp4_ = vala_list_get (self->priv->_scs, 0);
		_tmp5_ = (VtgSymbolCompletion*) _tmp4_;
		vtg_plugin_instance_deactivate_symbol (self, _tmp5_);
		_g_object_unref0 (_tmp5_);
	}
}


void vtg_plugin_instance_deactivate_brackets (VtgPluginInstance* self) {
	gint size;
	g_return_if_fail (self != NULL);
	size = 0;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gint _tmp1_;
		gint _tmp3_;
		_tmp1_ = vala_map_get_size ((ValaMap*) self->priv->_bcs);
		if (_tmp1_ > 0) {
			gint _tmp2_;
			_tmp2_ = vala_map_get_size ((ValaMap*) self->priv->_bcs);
			_tmp0_ = _tmp2_ != size;
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp3_ = vala_map_get_size ((ValaMap*) self->priv->_bcs);
		size = _tmp3_;
		{
			ValaSet* _tmp4_ = NULL;
			ValaSet* _tmp5_;
			ValaIterator* _tmp6_ = NULL;
			ValaIterator* _tmp7_;
			ValaIterator* _view_it;
			_tmp4_ = vala_map_get_keys ((ValaMap*) self->priv->_bcs);
			_tmp5_ = _tmp4_;
			_tmp6_ = vala_iterable_iterator ((ValaIterable*) _tmp5_);
			_tmp7_ = _tmp6_;
			_vala_iterable_unref0 (_tmp5_);
			_view_it = _tmp7_;
			while (TRUE) {
				gboolean _tmp8_;
				gpointer _tmp9_ = NULL;
				GeditView* view;
				_tmp8_ = vala_iterator_next (_view_it);
				if (!_tmp8_) {
					break;
				}
				_tmp9_ = vala_iterator_get (_view_it);
				view = (GeditView*) _tmp9_;
				vtg_plugin_instance_deactivate_bracket (self, view);
				_g_object_unref0 (view);
				break;
			}
			_vala_iterator_unref0 (_view_it);
		}
	}
}


gboolean vtg_plugin_instance_bcs_contains (VtgPluginInstance* self, GeditView* view) {
	gboolean result = FALSE;
	VtgBracketCompletion* _tmp0_ = NULL;
	VtgBracketCompletion* _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (view != NULL, FALSE);
	_tmp0_ = vtg_plugin_instance_bcs_find_from_view (self, view);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ != NULL;
	_g_object_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}


VtgBracketCompletion* vtg_plugin_instance_bcs_find_from_view (VtgPluginInstance* self, GeditView* view) {
	VtgBracketCompletion* result = NULL;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (view != NULL, NULL);
	_tmp0_ = vala_map_contains ((ValaMap*) self->priv->_bcs, view);
	if (_tmp0_) {
		gpointer _tmp1_ = NULL;
		_tmp1_ = vala_map_get ((ValaMap*) self->priv->_bcs, view);
		result = (VtgBracketCompletion*) _tmp1_;
		return result;
	} else {
		result = NULL;
		return result;
	}
}


gboolean vtg_plugin_instance_scs_contains (VtgPluginInstance* self, GeditView* view) {
	gboolean result = FALSE;
	VtgSymbolCompletion* _tmp0_ = NULL;
	VtgSymbolCompletion* _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (view != NULL, FALSE);
	_tmp0_ = vtg_plugin_instance_scs_find_from_view (self, view);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ != NULL;
	_g_object_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}


VtgSymbolCompletion* vtg_plugin_instance_scs_find_from_view (VtgPluginInstance* self, GeditView* view) {
	VtgSymbolCompletion* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (view != NULL, NULL);
	{
		ValaList* _tmp0_;
		ValaList* _sc_list;
		gint _tmp1_;
		gint _sc_size;
		gint _sc_index;
		_tmp0_ = _vala_iterable_ref0 (self->priv->_scs);
		_sc_list = _tmp0_;
		_tmp1_ = vala_collection_get_size ((ValaCollection*) _sc_list);
		_sc_size = _tmp1_;
		_sc_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			VtgSymbolCompletion* sc;
			GeditView* _tmp3_ = NULL;
			_sc_index = _sc_index + 1;
			if (!(_sc_index < _sc_size)) {
				break;
			}
			_tmp2_ = vala_list_get (_sc_list, _sc_index);
			sc = (VtgSymbolCompletion*) _tmp2_;
			_tmp3_ = vtg_symbol_completion_get_view (sc);
			if (_tmp3_ == view) {
				result = sc;
				_vala_iterable_unref0 (_sc_list);
				return result;
			}
			_g_object_unref0 (sc);
		}
		_vala_iterable_unref0 (_sc_list);
	}
	result = NULL;
	return result;
}


void vtg_plugin_instance_uninitialize_document (VtgPluginInstance* self, GeditDocument* doc) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (doc != NULL);
	g_signal_handlers_disconnect_by_func (doc, (void*) vtg_plugin_instance_on_notify_language, self);
	g_signal_handlers_disconnect_by_func (doc, (void*) vtg_plugin_instance_on_document_saved, self);
}


static gboolean _vtg_plugin_instance_on_idle_cursor_mode_gsource_func (gpointer self) {
	gboolean result;
	result = vtg_plugin_instance_on_idle_cursor_mode (self);
	return result;
}


GeditTab* vtg_plugin_instance_activate_uri (VtgPluginInstance* self, const gchar* uri, gint line, gint col) {
	GeditTab* result = NULL;
	GeditTab* tab;
	GeditDocument* existing_doc;
	GList* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	tab = NULL;
	existing_doc = NULL;
	_tmp0_ = gedit_window_get_documents (self->priv->_window);
	{
		GList* doc_collection;
		GList* doc_it;
		doc_collection = _tmp0_;
		for (doc_it = doc_collection; doc_it != NULL; doc_it = doc_it->next) {
			GeditDocument* _tmp1_;
			GeditDocument* doc;
			_tmp1_ = _g_object_ref0 ((GeditDocument*) doc_it->data);
			doc = _tmp1_;
			{
				gchar* _tmp2_ = NULL;
				gchar* _tmp3_;
				gboolean _tmp4_;
				_tmp2_ = vtg_utils_get_document_uri (doc);
				_tmp3_ = _tmp2_;
				_tmp4_ = g_strcmp0 (_tmp3_, uri) == 0;
				_g_free0 (_tmp3_);
				if (_tmp4_) {
					GeditTab* _tmp5_ = NULL;
					GeditTab* _tmp6_;
					GeditDocument* _tmp7_;
					_tmp5_ = gedit_tab_get_from_document (doc);
					_tmp6_ = _g_object_ref0 (_tmp5_);
					_g_object_unref0 (tab);
					tab = _tmp6_;
					_tmp7_ = _g_object_ref0 (doc);
					_g_object_unref0 (existing_doc);
					existing_doc = _tmp7_;
					_g_object_unref0 (doc);
					break;
				}
				_g_object_unref0 (doc);
			}
		}
		_g_list_free0 (doc_collection);
	}
	if (tab == NULL) {
		GFile* _tmp8_ = NULL;
		GFile* _tmp9_;
		GeditEncoding* _tmp10_ = NULL;
		GeditTab* _tmp11_ = NULL;
		GeditTab* _tmp12_;
		GeditView* _tmp13_ = NULL;
		_tmp8_ = g_file_new_for_uri (uri);
		_tmp9_ = _tmp8_;
		_tmp10_ = gedit_encoding_get_utf8 ();
		_tmp11_ = gedit_window_create_tab_from_location (self->priv->_window, _tmp9_, _tmp10_, line, col, TRUE, FALSE);
		_tmp12_ = _g_object_ref0 (_tmp11_);
		_g_object_unref0 (tab);
		tab = _tmp12_;
		_g_object_unref0 (_tmp9_);
		gedit_window_set_active_tab (self->priv->_window, tab);
		_tmp13_ = gedit_tab_get_view (tab);
		self->priv->_last_created_view = _tmp13_;
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _vtg_plugin_instance_on_idle_cursor_mode_gsource_func, g_object_ref (self), g_object_unref);
	} else {
		gboolean _tmp14_ = FALSE;
		gedit_window_set_active_tab (self->priv->_window, tab);
		if (existing_doc != NULL) {
			_tmp14_ = line > 0;
		} else {
			_tmp14_ = FALSE;
		}
		if (_tmp14_) {
			gboolean _tmp15_;
			GeditView* _tmp16_ = NULL;
			_tmp15_ = gedit_document_goto_line_offset (existing_doc, line - 1, col - 1);
			if (!_tmp15_) {
				gedit_document_goto_line (existing_doc, line - 1);
			}
			_tmp16_ = gedit_tab_get_view (tab);
			gedit_view_scroll_to_cursor (_tmp16_);
		}
	}
	result = tab;
	_g_object_unref0 (existing_doc);
	return result;
}


gboolean vtg_plugin_instance_on_idle_cursor_mode (VtgPluginInstance* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->_last_created_view != NULL) {
		gedit_view_scroll_to_cursor (self->priv->_last_created_view);
		self->priv->_last_created_view = NULL;
	}
	result = FALSE;
	return result;
}


void vtg_plugin_instance_activate_display_name (VtgPluginInstance* self, const gchar* display_name, gint line, gint col) {
	GList* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (display_name != NULL);
	_tmp0_ = gedit_window_get_documents (self->priv->_window);
	{
		GList* doc_collection;
		GList* doc_it;
		doc_collection = _tmp0_;
		for (doc_it = doc_collection; doc_it != NULL; doc_it = doc_it->next) {
			GeditDocument* _tmp1_;
			GeditDocument* doc;
			_tmp1_ = _g_object_ref0 ((GeditDocument*) doc_it->data);
			doc = _tmp1_;
			{
				gchar* _tmp2_ = NULL;
				gchar* _tmp3_;
				gboolean _tmp4_;
				_tmp2_ = gedit_document_get_short_name_for_display (doc);
				_tmp3_ = _tmp2_;
				_tmp4_ = g_strcmp0 (_tmp3_, display_name) == 0;
				_g_free0 (_tmp3_);
				if (_tmp4_) {
					GeditTab* _tmp5_ = NULL;
					GeditTab* _tmp6_;
					GeditTab* tab;
					GeditView* _tmp7_ = NULL;
					_tmp5_ = gedit_tab_get_from_document (doc);
					_tmp6_ = _g_object_ref0 (_tmp5_);
					tab = _tmp6_;
					gedit_window_set_active_tab (self->priv->_window, tab);
					gedit_document_goto_line (doc, line - 1);
					_tmp7_ = gedit_tab_get_view (tab);
					gedit_view_scroll_to_cursor (_tmp7_);
					_g_object_unref0 (tab);
				}
				_g_object_unref0 (doc);
			}
		}
		_g_list_free0 (doc_collection);
	}
}


static void vtg_plugin_instance_on_notify_language (GeditDocument* sender, GParamSpec* pspec, VtgPluginInstance* instance) {
	GeditApp* _tmp0_ = NULL;
	GeditApp* _tmp1_;
	GeditApp* app;
	GList* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (sender != NULL);
	g_return_if_fail (pspec != NULL);
	g_return_if_fail (instance != NULL);
	_tmp0_ = gedit_app_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	app = _tmp1_;
	_tmp2_ = gedit_app_get_views (app);
	{
		GList* view_collection;
		GList* view_it;
		view_collection = _tmp2_;
		for (view_it = view_collection; view_it != NULL; view_it = view_it->next) {
			GeditView* _tmp3_;
			GeditView* view;
			_tmp3_ = _g_object_ref0 ((GeditView*) view_it->data);
			view = _tmp3_;
			{
				GtkTextBuffer* _tmp4_ = NULL;
				_tmp4_ = gtk_text_view_get_buffer ((GtkTextView*) view);
				if (_tmp4_ == GTK_TEXT_BUFFER (sender)) {
					VtgProjects* _tmp5_ = NULL;
					VtgProjectManager* _tmp6_ = NULL;
					VtgProjectManager* project_manager;
					gboolean _tmp7_;
					_tmp5_ = vtg_plugin_get_projects (vtg_plugin_main_instance);
					_tmp6_ = vtg_projects_get_project_manager_for_document (_tmp5_, sender, &_inner_error_);
					project_manager = _tmp6_;
					if (_inner_error_ != NULL) {
						goto __catch48_g_error;
					}
					_tmp7_ = vtg_utils_is_vala_doc (sender);
					if (!_tmp7_) {
						gboolean _tmp8_ = FALSE;
						if (project_manager != NULL) {
							VbfProject* _tmp9_ = NULL;
							_tmp9_ = vtg_project_manager_get_project (project_manager);
							_tmp8_ = g_strcmp0 (_tmp9_->id, "vtg-default-project") == 0;
						} else {
							_tmp8_ = FALSE;
						}
						if (_tmp8_) {
							vtg_plugin_instance_check_vala_source_for_remove (instance, project_manager, sender);
						}
						vtg_plugin_instance_uninitialize_view (instance, view);
					} else {
						gboolean _tmp10_ = FALSE;
						if (project_manager != NULL) {
							VbfProject* _tmp11_ = NULL;
							_tmp11_ = vtg_project_manager_get_project (project_manager);
							_tmp10_ = g_strcmp0 (_tmp11_->id, "vtg-default-project") == 0;
						} else {
							_tmp10_ = FALSE;
						}
						if (_tmp10_) {
							vtg_plugin_instance_check_vala_source_for_add (instance, project_manager, sender);
						}
						vtg_plugin_instance_initialize_view (instance, project_manager, view);
					}
					_g_object_unref0 (project_manager);
					goto __finally48;
					__catch48_g_error:
					{
						GError * err;
						err = _inner_error_;
						_inner_error_ = NULL;
						g_critical ("vtgplugininstance.vala:466: error: %s", err->message);
						_g_error_free0 (err);
					}
					__finally48:
					if (_inner_error_ != NULL) {
						_g_object_unref0 (view);
						_g_list_free0 (view_collection);
						_g_object_unref0 (app);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_g_object_unref0 (view);
					break;
				}
				_g_object_unref0 (view);
			}
		}
		_g_list_free0 (view_collection);
	}
	_g_object_unref0 (app);
}


void vtg_plugin_instance_unbind_completion_engine (VtgPluginInstance* self, AfroditeCompletionEngine* engine) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (engine != NULL);
	{
		ValaList* _tmp0_;
		ValaList* _sc_list;
		gint _tmp1_;
		gint _sc_size;
		gint _sc_index;
		_tmp0_ = _vala_iterable_ref0 (self->priv->_scs);
		_sc_list = _tmp0_;
		_tmp1_ = vala_collection_get_size ((ValaCollection*) _sc_list);
		_sc_size = _tmp1_;
		_sc_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			VtgSymbolCompletion* sc;
			AfroditeCompletionEngine* _tmp3_ = NULL;
			_sc_index = _sc_index + 1;
			if (!(_sc_index < _sc_size)) {
				break;
			}
			_tmp2_ = vala_list_get (_sc_list, _sc_index);
			sc = (VtgSymbolCompletion*) _tmp2_;
			_tmp3_ = vtg_symbol_completion_get_completion_engine (sc);
			if (_tmp3_ == engine) {
				vtg_symbol_completion_set_completion_engine (sc, NULL);
			}
			_g_object_unref0 (sc);
		}
		_vala_iterable_unref0 (_sc_list);
	}
	if (self->priv->_source_outliner != NULL) {
		vtg_source_outliner_cleanup_completion_engine (self->priv->_source_outliner, engine);
	}
}


void vtg_plugin_instance_bind_completion_engine_with_target (VtgPluginInstance* self, VbfTarget* target, AfroditeCompletionEngine* engine) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (target != NULL);
	g_return_if_fail (engine != NULL);
	{
		ValaList* _tmp0_;
		ValaList* _sc_list;
		gint _tmp1_;
		gint _sc_size;
		gint _sc_index;
		_tmp0_ = _vala_iterable_ref0 (self->priv->_scs);
		_sc_list = _tmp0_;
		_tmp1_ = vala_collection_get_size ((ValaCollection*) _sc_list);
		_sc_size = _tmp1_;
		_sc_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			VtgSymbolCompletion* sc;
			GeditView* _tmp3_ = NULL;
			GtkTextBuffer* _tmp4_ = NULL;
			GeditDocument* _tmp5_;
			GeditDocument* doc;
			VtgProjects* _tmp6_ = NULL;
			VbfTarget* _tmp7_ = NULL;
			VbfTarget* _tmp8_;
			gboolean _tmp9_;
			_sc_index = _sc_index + 1;
			if (!(_sc_index < _sc_size)) {
				break;
			}
			_tmp2_ = vala_list_get (_sc_list, _sc_index);
			sc = (VtgSymbolCompletion*) _tmp2_;
			_tmp3_ = vtg_symbol_completion_get_view (sc);
			_tmp4_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp3_);
			_tmp5_ = _g_object_ref0 (GEDIT_DOCUMENT (_tmp4_));
			doc = _tmp5_;
			_tmp6_ = vtg_plugin_get_projects (vtg_plugin_main_instance);
			_tmp7_ = vtg_projects_get_target_for_document (_tmp6_, doc);
			_tmp8_ = _tmp7_;
			_tmp9_ = _tmp8_ == target;
			_g_object_unref0 (_tmp8_);
			if (_tmp9_) {
				vtg_symbol_completion_set_completion_engine (sc, engine);
			}
			_g_object_unref0 (doc);
			_g_object_unref0 (sc);
		}
		_vala_iterable_unref0 (_sc_list);
	}
	if (self->priv->_source_outliner != NULL) {
		GeditView* _tmp10_ = NULL;
		GeditView* _tmp11_;
		GeditView* view;
		_tmp10_ = vtg_source_outliner_get_active_view (self->priv->_source_outliner);
		_tmp11_ = _g_object_ref0 (_tmp10_);
		view = _tmp11_;
		if (view != NULL) {
			GtkTextBuffer* _tmp12_ = NULL;
			GeditDocument* _tmp13_;
			GeditDocument* doc;
			VtgProjects* _tmp14_ = NULL;
			VbfTarget* _tmp15_ = NULL;
			VbfTarget* _tmp16_;
			gboolean _tmp17_;
			_tmp12_ = gtk_text_view_get_buffer ((GtkTextView*) view);
			_tmp13_ = _g_object_ref0 (GEDIT_DOCUMENT (_tmp12_));
			doc = _tmp13_;
			_tmp14_ = vtg_plugin_get_projects (vtg_plugin_main_instance);
			_tmp15_ = vtg_projects_get_target_for_document (_tmp14_, doc);
			_tmp16_ = _tmp15_;
			_tmp17_ = _tmp16_ == target;
			_g_object_unref0 (_tmp16_);
			if (_tmp17_) {
				vtg_source_outliner_setup_completion_engine (self->priv->_source_outliner, engine);
			}
			_g_object_unref0 (doc);
		}
		_g_object_unref0 (view);
	}
}


static void vtg_plugin_instance_on_document_saved (GeditDocument* doc, void* arg1, VtgPluginInstance* self) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	VtgProjects* _tmp2_ = NULL;
	VtgProjectManager* _tmp3_ = NULL;
	VtgProjectManager* project_manager;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (doc != NULL);
	_tmp0_ = vtg_utils_get_document_uri (doc);
	_tmp1_ = _tmp0_;
	vtg_utils_trace ("vtgplugininstance.vala:511: document saved: %s", _tmp1_);
	_g_free0 (_tmp1_);
	_tmp2_ = vtg_plugin_get_projects (vtg_plugin_main_instance);
	_tmp3_ = vtg_projects_get_project_manager_for_document (_tmp2_, doc, &_inner_error_);
	project_manager = _tmp3_;
	if (_inner_error_ != NULL) {
		goto __catch49_g_error;
	}
	if (project_manager->is_default) {
		VbfSource* source;
		gboolean _tmp4_;
		source = NULL;
		_tmp4_ = vala_map_contains ((ValaMap*) self->priv->open_docs, doc);
		if (_tmp4_) {
			gpointer _tmp5_ = NULL;
			_tmp5_ = vala_map_get ((ValaMap*) self->priv->open_docs, doc);
			_g_object_unref0 (source);
			source = (VbfSource*) _tmp5_;
		}
		if (source != NULL) {
			gchar* _tmp6_ = NULL;
			gchar* file;
			_tmp6_ = vtg_utils_get_document_uri (doc);
			file = _tmp6_;
			if (g_strcmp0 (((VbfFile*) source)->uri, file) != 0) {
				gchar* _tmp7_ = NULL;
				gchar* _tmp8_;
				gchar* _tmp9_ = NULL;
				gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				VtgProjectManager* _tmp13_ = NULL;
				VbfProject* _tmp14_ = NULL;
				vtg_utils_trace ("vtgplugininstance.vala:524: update source info for: %s", file);
				_tmp7_ = vtg_utils_get_document_uri (doc);
				_tmp8_ = _tmp7_;
				_tmp9_ = g_filename_from_uri (_tmp8_, NULL, &_inner_error_);
				_tmp10_ = _tmp9_;
				_g_free0 (_tmp8_);
				_tmp11_ = _tmp10_;
				if (_inner_error_ != NULL) {
					_g_free0 (file);
					_g_object_unref0 (source);
					_g_object_unref0 (project_manager);
					goto __catch49_g_error;
				}
				_tmp12_ = _tmp11_;
				vbf_file_update_file_data ((VbfFile*) source, _tmp12_);
				_g_free0 (_tmp12_);
				_tmp13_ = vtg_project_view_get_current_project (self->priv->_project_view);
				_tmp14_ = vtg_project_manager_get_project (_tmp13_);
				vbf_project_update (_tmp14_);
			}
			_g_free0 (file);
		} else {
			gchar* _tmp15_ = NULL;
			gchar* _tmp16_;
			_tmp15_ = vtg_utils_get_document_name (doc);
			_tmp16_ = _tmp15_;
			vtg_utils_trace ("vtgplugininstance.vala:529: can't find source file for: %s", _tmp16_);
			_g_free0 (_tmp16_);
		}
		_g_object_unref0 (source);
	}
	_g_object_unref0 (project_manager);
	goto __finally49;
	__catch49_g_error:
	{
		GError * err;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp17_ = vtg_utils_get_document_uri (doc);
		_tmp18_ = _tmp17_;
		g_warning ("vtgplugininstance.vala:533: error converting file to uri: %s", _tmp18_);
		_g_free0 (_tmp18_);
		_g_error_free0 (err);
	}
	__finally49:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


VtgOutputView* vtg_plugin_instance_get_output_view (VtgPluginInstance* self) {
	VtgOutputView* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_output_view;
	return result;
}


VtgProjectManagerUi* vtg_plugin_instance_get_project_manager_ui (VtgPluginInstance* self) {
	VtgProjectManagerUi* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_project_manager_ui;
	return result;
}


VtgSourceOutliner* vtg_plugin_instance_get_source_outliner (VtgPluginInstance* self) {
	VtgSourceOutliner* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_source_outliner;
	return result;
}


VtgProjectView* vtg_plugin_instance_get_project_view (VtgPluginInstance* self) {
	VtgProjectView* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_project_view;
	return result;
}


GeditWindow* vtg_plugin_instance_get_window (VtgPluginInstance* self) {
	GeditWindow* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_window;
	return result;
}


VtgSourceBookmarks* vtg_plugin_instance_get_bookmarks (VtgPluginInstance* self) {
	VtgSourceBookmarks* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_bookmarks;
	return result;
}


static void vtg_plugin_instance_class_init (VtgPluginInstanceClass * klass) {
	vtg_plugin_instance_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (VtgPluginInstancePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_vtg_plugin_instance_get_property;
	G_OBJECT_CLASS (klass)->finalize = vtg_plugin_instance_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_PLUGIN_INSTANCE_OUTPUT_VIEW, g_param_spec_object ("output-view", "output-view", "output-view", VTG_TYPE_OUTPUT_VIEW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_PLUGIN_INSTANCE_PROJECT_MANAGER_UI, g_param_spec_object ("project-manager-ui", "project-manager-ui", "project-manager-ui", VTG_TYPE_PROJECT_MANAGER_UI, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_PLUGIN_INSTANCE_SOURCE_OUTLINER, g_param_spec_object ("source-outliner", "source-outliner", "source-outliner", VTG_TYPE_SOURCE_OUTLINER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_PLUGIN_INSTANCE_PROJECT_VIEW, g_param_spec_object ("project-view", "project-view", "project-view", VTG_TYPE_PROJECT_VIEW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_PLUGIN_INSTANCE_WINDOW, g_param_spec_object ("window", "window", "window", gedit_window_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_PLUGIN_INSTANCE_BOOKMARKS, g_param_spec_object ("bookmarks", "bookmarks", "bookmarks", VTG_TYPE_SOURCE_BOOKMARKS, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void vtg_plugin_instance_instance_init (VtgPluginInstance * self) {
	ValaArrayList* _tmp0_ = NULL;
	ValaHashMap* _tmp1_ = NULL;
	ValaHashMap* _tmp2_ = NULL;
	self->priv = VTG_PLUGIN_INSTANCE_GET_PRIVATE (self);
	self->priv->_window = NULL;
	self->priv->_project_manager_ui = NULL;
	self->priv->_source_outliner = NULL;
	self->priv->_output_view = NULL;
	self->priv->_project_view = NULL;
	self->priv->_bookmarks = NULL;
	_tmp0_ = vala_array_list_new (VTG_TYPE_SYMBOL_COMPLETION, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_equal);
	self->priv->_scs = (ValaList*) _tmp0_;
	_tmp1_ = vala_hash_map_new (gedit_view_get_type (), (GBoxedCopyFunc) g_object_ref, g_object_unref, VTG_TYPE_BRACKET_COMPLETION, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	self->priv->_bcs = _tmp1_;
	self->priv->_last_created_view = NULL;
	self->priv->_tab_add_sig_id = (gulong) 0;
	self->priv->_tab_removed_sig_id = (gulong) 0;
	_tmp2_ = vala_hash_map_new (gedit_document_get_type (), (GBoxedCopyFunc) g_object_ref, g_object_unref, VBF_TYPE_SOURCE, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	self->priv->open_docs = _tmp2_;
}


static void vtg_plugin_instance_finalize (GObject* obj) {
	VtgPluginInstance * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GList* _tmp2_ = NULL;
	self = VTG_PLUGIN_INSTANCE (obj);
	if (self->priv->_source_outliner != NULL) {
		vtg_source_outliner_set_active_view (self->priv->_source_outliner, NULL);
	}
	_tmp0_ = g_signal_handler_is_connected (self->priv->_window, self->priv->_tab_add_sig_id);
	if (_tmp0_) {
		g_signal_handler_disconnect (self->priv->_window, self->priv->_tab_add_sig_id);
	}
	_tmp1_ = g_signal_handler_is_connected (self->priv->_window, self->priv->_tab_removed_sig_id);
	if (_tmp1_) {
		g_signal_handler_disconnect (self->priv->_window, self->priv->_tab_removed_sig_id);
	}
	_tmp2_ = gedit_window_get_documents (self->priv->_window);
	{
		GList* doc_collection;
		GList* doc_it;
		doc_collection = _tmp2_;
		for (doc_it = doc_collection; doc_it != NULL; doc_it = doc_it->next) {
			GeditDocument* _tmp3_;
			GeditDocument* doc;
			_tmp3_ = _g_object_ref0 ((GeditDocument*) doc_it->data);
			doc = _tmp3_;
			{
				vtg_plugin_instance_uninitialize_document (self, doc);
				_g_object_unref0 (doc);
			}
		}
		_g_list_free0 (doc_collection);
	}
	_g_object_unref0 (self->priv->_source_outliner);
	self->priv->_source_outliner = NULL;
	_g_object_unref0 (self->priv->_project_manager_ui);
	self->priv->_project_manager_ui = NULL;
	_g_object_unref0 (self->priv->_output_view);
	self->priv->_output_view = NULL;
	_g_object_unref0 (self->priv->_project_manager_ui);
	_g_object_unref0 (self->priv->_source_outliner);
	_g_object_unref0 (self->priv->_output_view);
	_g_object_unref0 (self->priv->_project_view);
	_g_object_unref0 (self->priv->_bookmarks);
	_vala_iterable_unref0 (self->priv->_scs);
	_vala_map_unref0 (self->priv->_bcs);
	_vala_map_unref0 (self->priv->open_docs);
	G_OBJECT_CLASS (vtg_plugin_instance_parent_class)->finalize (obj);
}


GType vtg_plugin_instance_get_type (void) {
	return vtg_plugin_instance_type_id;
}


GType vtg_plugin_instance_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (VtgPluginInstanceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vtg_plugin_instance_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VtgPluginInstance), 0, (GInstanceInitFunc) vtg_plugin_instance_instance_init, NULL };
	vtg_plugin_instance_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "VtgPluginInstance", &g_define_type_info, 0);
	return vtg_plugin_instance_type_id;
}


static void _vala_vtg_plugin_instance_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	VtgPluginInstance * self;
	self = VTG_PLUGIN_INSTANCE (object);
	switch (property_id) {
		case VTG_PLUGIN_INSTANCE_OUTPUT_VIEW:
		g_value_set_object (value, vtg_plugin_instance_get_output_view (self));
		break;
		case VTG_PLUGIN_INSTANCE_PROJECT_MANAGER_UI:
		g_value_set_object (value, vtg_plugin_instance_get_project_manager_ui (self));
		break;
		case VTG_PLUGIN_INSTANCE_SOURCE_OUTLINER:
		g_value_set_object (value, vtg_plugin_instance_get_source_outliner (self));
		break;
		case VTG_PLUGIN_INSTANCE_PROJECT_VIEW:
		g_value_set_object (value, vtg_plugin_instance_get_project_view (self));
		break;
		case VTG_PLUGIN_INSTANCE_WINDOW:
		g_value_set_object (value, vtg_plugin_instance_get_window (self));
		break;
		case VTG_PLUGIN_INSTANCE_BOOKMARKS:
		g_value_set_object (value, vtg_plugin_instance_get_bookmarks (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



