class DictLoader(object):
    def __init__(self, data):
        """
        A DictLoader simply returns the given dictionary as the settings.
        This is a great way to force specific settings at any level, such
        as for computed defaults.

        :Parameters:
          - `data`: Dictionary to become the settings.

        Example::

          DictLoader({ "foo": "bar" })

        Adding this to a Choices instance will yield the settings of
        ``{ "foo": "bar" }}``.
        """
        self.data = data

    def load(self, options, settings, **kwargs):
        return self.data
