#ifndef INCLUDED_TYPES_H
#define INCLUDED_TYPES_H
/* vim:ts=4:sw=4:noet
 * (tabspace=4)
 * 
 * Copyright (C) 2004, 2005 Walter Doekes, <walter@djcvt.net>.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* define that we want large files */
#define _FILE_OFFSET_BITS 64
#define _LARGEFILE64_SOURCE 1
#include <limits.h>

/* define the (u)intNN_t types */
#ifdef _WIN32

/* 8-bit */
#if UCHAR_MAX == 255
	typedef signed char int8_t;
	typedef unsigned char uint8_t;
#else
#	error UCHAR_MAX size is wrong
#endif

/* 16-bit */
#if USHRT_MAX == 65535
	typedef signed short int int16_t;
	typedef unsigned short int uint16_t;
#else
#	error USHRT_MAX size is wrong
#endif

/* 32-bit */
#if UINT_MAX == 4294967295u
	typedef signed int int32_t;
	typedef unsigned int uint32_t;
#elif ULONG_MAX == 4294967295u
	typedef signed long int int32_t;
	typedef unsigned long int uint32_t;
#else
#	error U(INT|LONG)_MAX sizes are wrong
#endif

/* 64-bit */
#ifdef _WIN32
	typedef signed __int64 int64_t;
	typedef unsigned __int64 uint64_t;
#else /* Hope for the best */
	typedef signed long long int int64_t;
	typedef unsigned long long int uint64_t;
#endif

#else /* !_WIN32 */

#	include <inttypes.h>

#endif /* !_WIN32 */

#endif /* INCLUDED_TYPES_H */
