#ifndef __misc_h
#define __misc_h

#define VF_OLD		0x1		/* This is an old, possibly incompatable version */
#define VF_NOBACK	0x2		/* Save file may be unreadable in earlier versions */
#define VF_UNKNOWN	0x4		/* Unknown version number (future version?) */

#define imin(a,b) ((a) < (b) ? (a) : (b))
#define imax(a,b) ((a) > (b) ? (a) : (b))
#define iabs(n) (((n) < 0) ? -(n) : (n))

struct versionDef {
  char		*name;		/* Name for version number */
  unsigned	flags;		/* flags for this version */
};

typedef struct {
  int major;		/* Major version number */
  int minor;		/* Minor version number */
  int revision;		/* Revision */
} Version;

typedef struct {
  int	length;
  char	**names;
} NetAliasList;

char *strend(char *s);
char *GetSysType();
char *skipfield(char *s);
char *quoteChars(char *buf,char *str,char *qlist);
void strreplace(char*s,const char *old_str,const char *new_str,int gbl);

int ParseVersion(const char *version,Version *V);
int VersionCmp(Version *V1,Version *V2);

#endif
