/**
 * Copyright (C) 2007-2013 Lawrence Murray
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * @author Lawrence Murray <lawrence@indii.org>
 * $Rev$
 * $Date$
 */
#ifndef INDII_TINT_MODEL_CLUSTERMODELOBSERVABLE_HPP
#define INDII_TINT_MODEL_CLUSTERMODELOBSERVABLE_HPP

#include <set>

namespace indii {
  class ClusterModelObserver;

/**
 * Observable object.
 */
class ClusterModelObservable {
public:
  /**
   * Destructor.
   */
  virtual ~ClusterModelObservable();

  /**
   * Registry type.
   */
  typedef std::set<ClusterModelObserver*> registry_t;

  /**
   * Register observer.
   */
  void subscribe(ClusterModelObserver* o);

  /**
   * Deregister observer.
   */
  void unsubscribe(ClusterModelObserver* o);

  /**
   * Notify change specific to a single cluster.
   *
   * @param i The cluster.
   */
  virtual void notifyClusterChange(const int i);

  /**
   * Notify change of hue rotation to a single cluster.
   *
   * @param i The cluster.
   */
  virtual void notifyHueChange(const int i);

  /**
   * Notify change of saturation adjustent to a single cluster.
   *
   * @param i The cluster.
   */
  virtual void notifySatChange(const int i);

  /**
   * Notify change of lightness adjustment to a single cluster.
   *
   * @param i The cluster.
   */
  virtual void notifyLightChange(const int i);

  /**
   * Notify change of alpha adjustment to a single cluster.
   *
   * @param i The cluster.
   */
  virtual void notifyAlphaChange(const int i);

  /**
   * Notify change in number of clusters.
   */
  virtual void notifyNumClustersChange();

  /**
   * Notify change in hard/soft cluster assignment.
   */
  virtual void notifyIsHardChange();

  /**
   * Notify change in number of repetitions.
   */
  virtual void notifyNumRepetitionsChange();

  /**
   * Notify change in saturation threshold.
   */
  virtual void notifySaturationThresholdChange();

  /**
   * Notify change in maximum pixels for clustering.
   */
  virtual void notifyMaxPixelsChange();

  /**
   * Notify change in saturation decay.
   */
  virtual void notifySaturationDecayChange();

  /**
   * Notify change in centroid decay.
   */
  virtual void notifyCentroidDecayChange();

  /**
   * Notify change in saturation softness.
   */
  virtual void notifySaturationSoftnessChange();

  /**
   * Notify change in centroid softness.
   */
  virtual void notifyCentroidSoftnessChange();

  /**
   * Notify destruction.
   */
  virtual void notifyDestroy();

protected:
  /**
   * Registry of observers.
   */
  registry_t os;
};
}

#endif
