/*
 *	libetm-0.4 / str_mem.h - Copyright (C) Emmanuel Thomas-Maurin 2008-2012
 * 	<manutm007@gmail.com>
 *
 *	- A few strings and memory management functions -
 *
 * 	This program is free software: you can redistribute it and/or modify
 * 	it under the terms of the GNU General Public License as published by
 * 	the Free Software Foundation, either version 3 of the License, or
 * 	(at your option) any later version.
 *
 * 	This program is distributed in the hope that it will be useful,
 * 	but WITHOUT ANY WARRANTY; without even the implied warranty of
 * 	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * 	GNU General Public License for more details.
 *
 * 	You should have received a copy of the GNU General Public License
 * 	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef INC_LIBETM_STR_MEM_H
#define INC_LIBETM_STR_MEM_H

/*
 * Copy n bytes max from src to dest then add '\0' at end of dest.
 */
char		*str_n_cpy(char *, const char *, size_t);

/*
 * Concanate n bytes max of src to dest then add '\0' at end of dest.
 * Strings may not be identical and should not overlap.
 */
char		*str_n_cat(char *, const char *, size_t);

/*
 * Create new_l_str (allocate memory) and copy str (can be NULL) to new_l_str.
 */
char		*l_str_new(const char *str);

/*
 * Append l_str_src (can be NULL) to l_str_dest (re-allocate memory as necessary).
 * l_str_dest must have been created by l_str_new - strings may overlap.
 */
char		*l_str_cat(char *, const char *);

/*
 * Free string created by l_str_new() or l_str_cat().
 */
void		l_str_free(char *);

/*
 * Wrappers for malloc(), realloc(), calloc() and free() which check returned value.
 */
void		*malloc2(size_t);
void		*realloc2(void *, size_t);
void		*calloc2(size_t, size_t);
void		free2(void *);

/*
 * Return size in readable format (KiB, MiB, GiB, TiB).
 * *** Allow up to 16 simultaneous calls ***
 * Convention: we assume 2.5 MiB = 2 MiB + [0.5 x 1024 = 512] KiB, not 500 KiB.
 * Otherwise, there is no way to express a value in the range 1000 - 1023,
 * so x.y MiB = x MiB + 0.y MiB, that is: not y x 100 KiB but y x 102.4 KiB
 * (isn't this a bit confusing?)
 */
const char	*readable_size(double);

/*
 * itoa() is not ansi c so this one could be useful.
 * *** Allow up to 16 simultaneous calls ***
 */
const char	*itoa2(long int);

/*
 * Modify string in place
 */
char		*remove_char_from_str(char *, char);

/*
 * Modify string in place
 */
char		*remove_trailing_whitespaces_from_str(char *);

/*
 * Very basic xor sym encryption for small strings (up to 511 chars).
 * *** Key must be ascii / if 2 chars match (in str and key) the string is cut ***
 * *** Allow up to 16 simultaneous calls ***
 * Works with ascii strings, probably not otherwise so don't try with
 * exotic things...
 */
const char	*str_crypt(const char *, const char *);

/*
 * Very basic crypto hash
 */
unsigned long	str_crypto_hash(const char *, const char*);

/*
 * Generate a random string up to 1023 chars long.
 * mode = a -> alpha / d -> digits / b ->  both
 */
const char	*rnd_str(char, int);
#endif /* INC_LIBETM_STR_MEM_H */
