[comment {-*- tcl -*- doctools manpage}]
[manpage_begin tcl::transform::zlib n 1]
[copyright {2009 Andreas Kupries <andreas_kupries@users.sourceforge.net>}]
[moddesc   {Reflected/virtual channel support}]
[category  Channels]
[titledesc {zlib (de)compression}]
[require Tcl 8.6]
[require tcl::transform::core [opt 1]]
[require tcl::transform::zlib [opt 1]]
[description]
[para]

The [package tcl::transform::zlib] package provides a command creating
a channel transformation which zlib compresses the written data, and
decompresses on reading.

[para] The internal [package TclOO] class implementing the transform
handler is a sub-class of the [package tcl::transform::core]
framework.

[section API]

[list_begin definitions]

[call [cmd ::tcl::transform::zlib] [arg chan] [opt [arg level]]]

This command creates a zlib compressor transformation on top of the
channel [arg chan] and returns its handle.

[para] The [arg level] specifies how much effort is put into the
compression, from [const 0] to [const 9], and defaults to [const 4].

[list_end]


[section {BUGS, IDEAS, FEEDBACK}]

This document, and the package it describes, will undoubtedly contain
bugs and other problems.

Please report such in the category [emph virtchannel] of the
[uri {http://sourceforge.net/tracker/?group_id=12883} {Tcllib SF Trackers}].

Please also report any ideas for enhancements you may have for either
package and/or documentation.


[keywords compression decompression transformation {channel transformation}]
[keywords zlib {tip 234} {virtual channel} {reflected channel} {tip 230}]
[manpage_end]
