from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


INTROSPECTION_SERVER = _Mock()

NOTIFICATION_SERVER = _Mock()

SIGNAL = _Mock()

errno = _Mock()

get_conf_path = _Mock()

log_last_error = _Mock()

os = _Mock()

read_packet = _Mock()

select_port = _Mock()

socket = _Mock()

start_introspection_server = _Mock()

start_notification_server = _Mock()

threading = _Mock()

write_packet = _Mock()

DEBUG = 0

DEBUG_INTROSPECTION = _Mock()

LOG_FILENAME = u'/home/cpascual/.spyder2/introspection.log'

SPYDER_PORT = 20128

class IntrospectionServer(_Mock):
  pass
  _Thread__initialized = False

class NotificationServer(_Mock):
  pass
  _Thread__initialized = False

class NotificationThread(_Mock):
  pass
  HighPriority = 4
  HighestPriority = 5
  IdlePriority = 0
  InheritPriority = 7
  LowPriority = 2
  LowestPriority = 1
  NormalPriority = 3
  TimeCriticalPriority = 6

class QThread(_Mock):
  pass
  HighPriority = 4
  HighestPriority = 5
  IdlePriority = 0
  InheritPriority = 7
  LowPriority = 2
  LowestPriority = 1
  NormalPriority = 3
  TimeCriticalPriority = 6

class Signal(_Mock):
  pass


