/* rygel-gst-data-source.c generated by valac 0.40.8, the Vala compiler
 * generated from rygel-gst-data-source.vala, do not modify */

/*
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Jens Georg <jensg@openismus.com>
 *         Prasanna Modem <prasanna@ecaspia.com>
 *         Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#include <glib.h>
#include <glib-object.h>
#include <rygel-server.h>
#include <gst/gst.h>
#include <gst/base/base.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gee.h>


#define RYGEL_TYPE_GST_DATA_SOURCE (rygel_gst_data_source_get_type ())
#define RYGEL_GST_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_GST_DATA_SOURCE, RygelGstDataSource))
#define RYGEL_GST_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_GST_DATA_SOURCE, RygelGstDataSourceClass))
#define RYGEL_IS_GST_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_GST_DATA_SOURCE))
#define RYGEL_IS_GST_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_GST_DATA_SOURCE))
#define RYGEL_GST_DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_GST_DATA_SOURCE, RygelGstDataSourceClass))

typedef struct _RygelGstDataSource RygelGstDataSource;
typedef struct _RygelGstDataSourceClass RygelGstDataSourceClass;
typedef struct _RygelGstDataSourcePrivate RygelGstDataSourcePrivate;

#define RYGEL_TYPE_GST_SINK (rygel_gst_sink_get_type ())
#define RYGEL_GST_SINK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_GST_SINK, RygelGstSink))
#define RYGEL_GST_SINK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_GST_SINK, RygelGstSinkClass))
#define RYGEL_IS_GST_SINK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_GST_SINK))
#define RYGEL_IS_GST_SINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_GST_SINK))
#define RYGEL_GST_SINK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_GST_SINK, RygelGstSinkClass))

typedef struct _RygelGstSink RygelGstSink;
typedef struct _RygelGstSinkClass RygelGstSinkClass;
enum  {
	RYGEL_GST_DATA_SOURCE_0_PROPERTY,
	RYGEL_GST_DATA_SOURCE_NUM_PROPERTIES
};
static GParamSpec* rygel_gst_data_source_properties[RYGEL_GST_DATA_SOURCE_NUM_PROPERTIES];
typedef struct _RygelGstSinkPrivate RygelGstSinkPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gst_caps_unref0(var) ((var == NULL) ? NULL : (var = (gst_caps_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef enum  {
	RYGEL_GST_DATA_SOURCE_ERROR_NOT_COMPATIBLE
} RygelGstDataSourceError;
#define RYGEL_GST_DATA_SOURCE_ERROR rygel_gst_data_source_error_quark ()
struct _RygelGstDataSource {
	GObject parent_instance;
	RygelGstDataSourcePrivate * priv;
	GstElement* src;
	RygelMediaResource* res;
};

struct _RygelGstDataSourceClass {
	GObjectClass parent_class;
};

struct _RygelGstDataSourcePrivate {
	GstPipeline* pipeline;
	RygelHTTPSeekRequest* seek;
	RygelGstSink* sink;
	guint bus_watch_id;
};

struct _RygelGstSink {
	GstBaseSink parent_instance;
	RygelGstSinkPrivate * priv;
	GCancellable* cancellable;
};

struct _RygelGstSinkClass {
	GstBaseSinkClass parent_class;
};

typedef enum  {
	RYGEL_GST_ERROR_MISSING_PLUGIN,
	RYGEL_GST_ERROR_LINK
} RygelGstError;
#define RYGEL_GST_ERROR rygel_gst_error_quark ()

static gpointer rygel_gst_data_source_parent_class = NULL;
static RygelDataSourceIface * rygel_gst_data_source_rygel_data_source_parent_iface = NULL;

GQuark rygel_gst_data_source_error_quark (void);
GType rygel_gst_data_source_get_type (void) G_GNUC_CONST;
GType rygel_gst_sink_get_type (void) G_GNUC_CONST;
#define RYGEL_GST_DATA_SOURCE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_GST_DATA_SOURCE, RygelGstDataSourcePrivate))
RygelGstDataSource* rygel_gst_data_source_new (const gchar* uri,
                                               RygelMediaResource* resource,
                                               GError** error);
RygelGstDataSource* rygel_gst_data_source_construct (GType object_type,
                                                     const gchar* uri,
                                                     RygelMediaResource* resource,
                                                     GError** error);
GstElement* rygel_gst_utils_create_source_for_uri (const gchar* uri);
RygelGstDataSource* rygel_gst_data_source_new_from_element (GstElement* element);
RygelGstDataSource* rygel_gst_data_source_construct_from_element (GType object_type,
                                                                  GstElement* element);
static GeeList* rygel_gst_data_source_real_preroll (RygelDataSource* base,
                                             RygelHTTPSeekRequest* seek_request,
                                             RygelPlaySpeedRequest* playspeed_request,
                                             GError** error);
static void rygel_gst_data_source_real_start (RygelDataSource* base,
                                       GError** error);
static void rygel_gst_data_source_prepare_pipeline (RygelGstDataSource* self,
                                             const gchar* name,
                                             GstElement* src,
                                             GError** error);
static void rygel_gst_data_source_real_freeze (RygelDataSource* base);
void rygel_gst_sink_freeze (RygelGstSink* self);
static void rygel_gst_data_source_real_thaw (RygelDataSource* base);
void rygel_gst_sink_thaw (RygelGstSink* self);
static void rygel_gst_data_source_real_stop (RygelDataSource* base);
static gboolean __lambda6_ (RygelGstDataSource* self);
static gboolean ___lambda6__gsource_func (gpointer self);
RygelGstSink* rygel_gst_sink_new (RygelDataSource* source,
                                  RygelHTTPSeekRequest* offsets);
RygelGstSink* rygel_gst_sink_construct (GType object_type,
                                        RygelDataSource* source,
                                        RygelHTTPSeekRequest* offsets);
static void rygel_gst_data_source_src_pad_added (RygelGstDataSource* self,
                                          GstElement* src,
                                          GstPad* src_pad);
static void _rygel_gst_data_source_src_pad_added_gst_element_pad_added (GstElement* _sender,
                                                                 GstPad* pad,
                                                                 gpointer self);
GQuark rygel_gst_error_quark (void);
static gboolean rygel_gst_data_source_bus_handler (RygelGstDataSource* self,
                                            GstBus* bus,
                                            GstMessage* message);
static gboolean _rygel_gst_data_source_bus_handler_gst_bus_func (GstBus* bus,
                                                          GstMessage* message,
                                                          gpointer self);
#define RYGEL_GST_SINK_NAME "http-gst-sink"
GstElement* rygel_gst_utils_get_rtp_depayloader (GstCaps* caps);
static inline void _dynamic_set_streamable0 (GstElement* obj,
                               gboolean value);
static inline void _dynamic_set_fragment_duration1 (GstElement* obj,
                                      gint value);
static gboolean rygel_gst_data_source_perform_seek (RygelGstDataSource* self);
static gboolean ___lambda5_ (RygelGstDataSource* self);
static gboolean ____lambda5__gsource_func (gpointer self);
static void rygel_gst_data_source_finalize (GObject * obj);


GQuark
rygel_gst_data_source_error_quark (void)
{
	return g_quark_from_static_string ("rygel_gst_data_source_error-quark");
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


RygelGstDataSource*
rygel_gst_data_source_construct (GType object_type,
                                 const gchar* uri,
                                 RygelMediaResource* resource,
                                 GError** error)
{
	RygelGstDataSource * self = NULL;
	RygelMediaResource* _tmp0_;
	GstElement* _tmp1_;
	GstElement* _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (uri != NULL, NULL);
	self = (RygelGstDataSource*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (resource);
	_g_object_unref0 (self->res);
	self->res = _tmp0_;
	_tmp1_ = rygel_gst_utils_create_source_for_uri (uri);
	_g_object_unref0 (self->src);
	self->src = _tmp1_;
	_tmp2_ = self->src;
	if (_tmp2_ == NULL) {
		gchar* msg = NULL;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		GError* _tmp5_;
		_tmp3_ = g_strdup (_ ("Could not create GstElement for URI %s"));
		msg = _tmp3_;
		_tmp4_ = msg;
		_tmp5_ = g_error_new (RYGEL_GST_DATA_SOURCE_ERROR, RYGEL_GST_DATA_SOURCE_ERROR_NOT_COMPATIBLE, _tmp4_, uri);
		_inner_error_ = _tmp5_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (msg);
		_g_object_unref0 (self);
		return NULL;
	}
	return self;
}


RygelGstDataSource*
rygel_gst_data_source_new (const gchar* uri,
                           RygelMediaResource* resource,
                           GError** error)
{
	return rygel_gst_data_source_construct (RYGEL_TYPE_GST_DATA_SOURCE, uri, resource, error);
}


RygelGstDataSource*
rygel_gst_data_source_construct_from_element (GType object_type,
                                              GstElement* element)
{
	RygelGstDataSource * self = NULL;
	GstElement* _tmp0_;
	g_return_val_if_fail (element != NULL, NULL);
	self = (RygelGstDataSource*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (element);
	_g_object_unref0 (self->src);
	self->src = _tmp0_;
	return self;
}


RygelGstDataSource*
rygel_gst_data_source_new_from_element (GstElement* element)
{
	return rygel_gst_data_source_construct_from_element (RYGEL_TYPE_GST_DATA_SOURCE, element);
}


static GeeList*
rygel_gst_data_source_real_preroll (RygelDataSource* base,
                                    RygelHTTPSeekRequest* seek_request,
                                    RygelPlaySpeedRequest* playspeed_request,
                                    GError** error)
{
	RygelGstDataSource * self;
	GeeList* result = NULL;
	GeeArrayList* response_list = NULL;
	GeeArrayList* _tmp0_;
	RygelHTTPSeekRequest* _tmp25_;
	GError * _inner_error_ = NULL;
	self = (RygelGstDataSource*) base;
	_tmp0_ = gee_array_list_new (RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	response_list = _tmp0_;
	if (playspeed_request != NULL) {
		GError* _tmp1_;
		_tmp1_ = g_error_new_literal (RYGEL_DATA_SOURCE_ERROR, RYGEL_DATA_SOURCE_ERROR_PLAYSPEED_FAILED, _ ("Playspeed not supported"));
		_inner_error_ = _tmp1_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (response_list);
		return NULL;
	}
	if (seek_request == NULL) {
		g_debug ("rygel-gst-data-source.vala:76: No seek requested - sending entire bina" \
"ry");
	} else {
		if (G_TYPE_CHECK_INSTANCE_TYPE (seek_request, RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST)) {
			RygelHTTPByteSeekResponse* seek_response = NULL;
			RygelHTTPByteSeekResponse* _tmp2_;
			RygelHTTPByteSeekResponse* _tmp3_;
			gint64 _tmp4_;
			gint64 _tmp5_;
			RygelHTTPByteSeekResponse* _tmp6_;
			gint64 _tmp7_;
			gint64 _tmp8_;
			RygelHTTPByteSeekResponse* _tmp9_;
			_tmp2_ = rygel_http_byte_seek_response_new_from_request (G_TYPE_CHECK_INSTANCE_TYPE (seek_request, RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST) ? ((RygelHTTPByteSeekRequest*) seek_request) : NULL);
			seek_response = _tmp2_;
			_tmp3_ = seek_response;
			_tmp4_ = rygel_http_byte_seek_response_get_start_byte (_tmp3_);
			_tmp5_ = _tmp4_;
			_tmp6_ = seek_response;
			_tmp7_ = rygel_http_byte_seek_response_get_end_byte (_tmp6_);
			_tmp8_ = _tmp7_;
			g_debug ("rygel-gst-data-source.vala:81: Processing byte seek request for bytes " \
"%lld-%lld", _tmp5_, _tmp8_);
			_tmp9_ = seek_response;
			gee_abstract_collection_add ((GeeAbstractCollection*) response_list, (RygelHTTPResponseElement*) _tmp9_);
			_g_object_unref0 (seek_response);
		} else {
			if (G_TYPE_CHECK_INSTANCE_TYPE (seek_request, RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST)) {
				RygelHTTPTimeSeekRequest* time_seek = NULL;
				RygelHTTPTimeSeekRequest* _tmp10_;
				RygelHTTPTimeSeekResponse* seek_response = NULL;
				RygelHTTPTimeSeekRequest* _tmp11_;
				RygelMediaResource* _tmp12_;
				glong _tmp13_;
				glong _tmp14_;
				RygelHTTPTimeSeekResponse* _tmp15_;
				RygelHTTPTimeSeekResponse* _tmp16_;
				gint64 _tmp17_;
				gint64 _tmp18_;
				RygelHTTPTimeSeekResponse* _tmp19_;
				gint64 _tmp20_;
				gint64 _tmp21_;
				RygelHTTPTimeSeekResponse* _tmp22_;
				_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (seek_request, RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST) ? ((RygelHTTPTimeSeekRequest*) seek_request) : NULL);
				time_seek = _tmp10_;
				_tmp11_ = time_seek;
				_tmp12_ = self->res;
				_tmp13_ = rygel_media_resource_get_duration (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = rygel_http_time_seek_response_new_from_request (_tmp11_, (gint64) (_tmp14_ * G_TIME_SPAN_SECOND));
				seek_response = _tmp15_;
				_tmp16_ = seek_response;
				_tmp17_ = rygel_http_time_seek_response_get_start_time (_tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = seek_response;
				_tmp20_ = rygel_http_time_seek_response_get_end_time (_tmp19_);
				_tmp21_ = _tmp20_;
				g_debug ("rygel-gst-data-source.vala:95: Processing time seek request for %lldms" \
"-%lldms", _tmp18_, _tmp21_);
				_tmp22_ = seek_response;
				gee_abstract_collection_add ((GeeAbstractCollection*) response_list, (RygelHTTPResponseElement*) _tmp22_);
				_g_object_unref0 (seek_response);
				_g_object_unref0 (time_seek);
			} else {
				const gchar* _tmp23_;
				GError* _tmp24_;
				_tmp23_ = g_type_name (G_TYPE_FROM_INSTANCE ((GObject*) seek_request));
				_tmp24_ = g_error_new (RYGEL_DATA_SOURCE_ERROR, RYGEL_DATA_SOURCE_ERROR_SEEK_FAILED, _ ("HTTPSeekRequest type %s unsupported"), _tmp23_);
				_inner_error_ = _tmp24_;
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (response_list);
				return NULL;
			}
		}
	}
	_tmp25_ = _g_object_ref0 (seek_request);
	_g_object_unref0 (self->priv->seek);
	self->priv->seek = _tmp25_;
	result = (GeeList*) response_list;
	return result;
}


static void
rygel_gst_data_source_real_start (RygelDataSource* base,
                                  GError** error)
{
	RygelGstDataSource * self;
	GstElement* _tmp0_;
	RygelHTTPSeekRequest* _tmp1_;
	GError * _inner_error_ = NULL;
	self = (RygelGstDataSource*) base;
	_tmp0_ = self->src;
	rygel_gst_data_source_prepare_pipeline (self, "RygelGstDataSource", _tmp0_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp1_ = self->priv->seek;
	if (_tmp1_ != NULL) {
		GstPipeline* _tmp2_;
		_tmp2_ = self->priv->pipeline;
		gst_element_set_state ((GstElement*) _tmp2_, GST_STATE_PAUSED);
	} else {
		GstPipeline* _tmp3_;
		_tmp3_ = self->priv->pipeline;
		gst_element_set_state ((GstElement*) _tmp3_, GST_STATE_PLAYING);
	}
}


static void
rygel_gst_data_source_real_freeze (RygelDataSource* base)
{
	RygelGstDataSource * self;
	RygelGstSink* _tmp0_;
	self = (RygelGstDataSource*) base;
	_tmp0_ = self->priv->sink;
	rygel_gst_sink_freeze (_tmp0_);
}


static void
rygel_gst_data_source_real_thaw (RygelDataSource* base)
{
	RygelGstDataSource * self;
	RygelGstSink* _tmp0_;
	self = (RygelGstDataSource*) base;
	_tmp0_ = self->priv->sink;
	rygel_gst_sink_thaw (_tmp0_);
}


static gboolean
__lambda6_ (RygelGstDataSource* self)
{
	gboolean result = FALSE;
	g_signal_emit_by_name ((RygelDataSource*) self, "done");
	result = FALSE;
	return result;
}


static gboolean
___lambda6__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda6_ ((RygelGstDataSource*) self);
	return result;
}


static void
rygel_gst_data_source_real_stop (RygelDataSource* base)
{
	RygelGstDataSource * self;
	RygelGstSink* _tmp0_;
	GCancellable* _tmp1_;
	GstPipeline* _tmp2_;
	guint _tmp3_;
	self = (RygelGstDataSource*) base;
	_tmp0_ = self->priv->sink;
	_tmp1_ = _tmp0_->cancellable;
	g_cancellable_cancel (_tmp1_);
	_tmp2_ = self->priv->pipeline;
	gst_element_set_state ((GstElement*) _tmp2_, GST_STATE_NULL);
	_tmp3_ = self->priv->bus_watch_id;
	if (_tmp3_ != ((guint) 0)) {
		guint _tmp4_;
		_tmp4_ = self->priv->bus_watch_id;
		g_source_remove (_tmp4_);
		self->priv->bus_watch_id = (guint) 0;
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda6__gsource_func, g_object_ref (self), g_object_unref);
}


static void
_rygel_gst_data_source_src_pad_added_gst_element_pad_added (GstElement* _sender,
                                                            GstPad* pad,
                                                            gpointer self)
{
	rygel_gst_data_source_src_pad_added ((RygelGstDataSource*) self, _sender, pad);
}


static gboolean
_rygel_gst_data_source_bus_handler_gst_bus_func (GstBus* bus,
                                                 GstMessage* message,
                                                 gpointer self)
{
	gboolean result;
	result = rygel_gst_data_source_bus_handler ((RygelGstDataSource*) self, bus, message);
	return result;
}


static void
rygel_gst_data_source_prepare_pipeline (RygelGstDataSource* self,
                                        const gchar* name,
                                        GstElement* src,
                                        GError** error)
{
	RygelHTTPSeekRequest* _tmp0_;
	RygelGstSink* _tmp1_;
	GstPipeline* _tmp2_;
	GstPipeline* _tmp3_;
	GstPipeline* _tmp5_;
	RygelGstSink* _tmp6_;
	guint16 _tmp7_;
	GstBus* bus = NULL;
	GstPipeline* _tmp18_;
	GstBus* _tmp19_;
	GstBus* _tmp20_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (src != NULL);
	_tmp0_ = self->priv->seek;
	_tmp1_ = rygel_gst_sink_new ((RygelDataSource*) self, _tmp0_);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->sink);
	self->priv->sink = _tmp1_;
	_tmp2_ = (GstPipeline*) gst_pipeline_new (name);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->pipeline);
	self->priv->pipeline = _tmp2_;
	_tmp3_ = self->priv->pipeline;
	if (_tmp3_ == NULL) {
		GError* _tmp4_;
		_tmp4_ = g_error_new_literal (RYGEL_DATA_SOURCE_ERROR, RYGEL_DATA_SOURCE_ERROR_GENERAL, _ ("Failed to create pipeline"));
		_inner_error_ = _tmp4_;
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp5_ = self->priv->pipeline;
	_tmp6_ = self->priv->sink;
	gst_bin_add_many ((GstBin*) _tmp5_, src, (GstElement*) _tmp6_, NULL);
	_tmp7_ = src->numsrcpads;
	if (((gint) _tmp7_) == 0) {
		g_signal_connect_object (src, "pad-added", (GCallback) _rygel_gst_data_source_src_pad_added_gst_element_pad_added, self, 0);
	} else {
		RygelGstSink* _tmp8_;
		_tmp8_ = self->priv->sink;
		if (!gst_element_link (src, (GstElement*) _tmp8_)) {
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			RygelGstSink* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			GError* _tmp16_;
			GError* _tmp17_;
			_tmp9_ = gst_object_get_name ((GstObject*) src);
			_tmp10_ = _tmp9_;
			_tmp11_ = _tmp10_;
			_tmp12_ = self->priv->sink;
			_tmp13_ = gst_object_get_name ((GstObject*) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = _tmp14_;
			_tmp16_ = g_error_new (RYGEL_GST_ERROR, RYGEL_GST_ERROR_LINK, _ ("Failed to link %s to %s"), _tmp11_, _tmp15_);
			_tmp17_ = _tmp16_;
			_g_free0 (_tmp15_);
			_g_free0 (_tmp11_);
			_inner_error_ = _tmp17_;
			g_propagate_error (error, _inner_error_);
			return;
		}
	}
	_tmp18_ = self->priv->pipeline;
	_tmp19_ = gst_pipeline_get_bus (_tmp18_);
	bus = _tmp19_;
	_tmp20_ = bus;
	self->priv->bus_watch_id = gst_bus_add_watch_full (_tmp20_, G_PRIORITY_DEFAULT, _rygel_gst_data_source_bus_handler_gst_bus_func, g_object_ref (self), g_object_unref);
	_g_object_unref0 (bus);
}


static void
rygel_gst_data_source_src_pad_added (RygelGstDataSource* self,
                                     GstElement* src,
                                     GstPad* src_pad)
{
	GstCaps* caps = NULL;
	GstCaps* _tmp0_;
	GstElement* sink = NULL;
	GstPipeline* _tmp1_;
	GstElement* _tmp2_;
	GstPad* sink_pad = NULL;
	GstElement* depay = NULL;
	GstCaps* _tmp3_;
	GstElement* _tmp4_;
	GstElement* _tmp5_;
	GstPad* _tmp24_;
	GstElement* _tmp32_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (src != NULL);
	g_return_if_fail (src_pad != NULL);
	_tmp0_ = gst_pad_query_caps (src_pad, NULL);
	caps = _tmp0_;
	_tmp1_ = self->priv->pipeline;
	_tmp2_ = gst_bin_get_by_name ((GstBin*) _tmp1_, RYGEL_GST_SINK_NAME);
	sink = _tmp2_;
	_tmp3_ = caps;
	_tmp4_ = rygel_gst_utils_get_rtp_depayloader (_tmp3_);
	depay = _tmp4_;
	_tmp5_ = depay;
	if (_tmp5_ != NULL) {
		GstPipeline* _tmp6_;
		GstElement* _tmp7_;
		GstElement* _tmp8_;
		GstElement* _tmp9_;
		GstElement* _tmp18_;
		GstCaps* _tmp19_;
		GstPad* _tmp20_;
		_tmp6_ = self->priv->pipeline;
		_tmp7_ = depay;
		gst_bin_add ((GstBin*) _tmp6_, _tmp7_);
		_tmp8_ = depay;
		_tmp9_ = sink;
		if (!gst_element_link (_tmp8_, _tmp9_)) {
			GstElement* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			GstElement* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp10_ = depay;
			_tmp11_ = gst_object_get_name ((GstObject*) _tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = _tmp12_;
			_tmp14_ = sink;
			_tmp15_ = gst_object_get_name ((GstObject*) _tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = _tmp16_;
			g_critical (_ ("Failed to link %s to %s"), _tmp13_, _tmp17_);
			_g_free0 (_tmp17_);
			_g_free0 (_tmp13_);
			g_signal_emit_by_name ((RygelDataSource*) self, "done");
			_g_object_unref0 (depay);
			_g_object_unref0 (sink_pad);
			_g_object_unref0 (sink);
			_gst_caps_unref0 (caps);
			return;
		}
		_tmp18_ = depay;
		_tmp19_ = caps;
		_tmp20_ = gst_element_get_compatible_pad (_tmp18_, src_pad, _tmp19_);
		_g_object_unref0 (sink_pad);
		sink_pad = _tmp20_;
	} else {
		GstElement* _tmp21_;
		GstCaps* _tmp22_;
		GstPad* _tmp23_;
		_tmp21_ = sink;
		_tmp22_ = caps;
		_tmp23_ = gst_element_get_compatible_pad (_tmp21_, src_pad, _tmp22_);
		_g_object_unref0 (sink_pad);
		sink_pad = _tmp23_;
	}
	_tmp24_ = sink_pad;
	if (gst_pad_link_full (src_pad, _tmp24_, GST_PAD_LINK_CHECK_DEFAULT) != GST_PAD_LINK_OK) {
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		GstPad* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		_tmp25_ = gst_object_get_name ((GstObject*) src_pad);
		_tmp26_ = _tmp25_;
		_tmp27_ = _tmp26_;
		_tmp28_ = sink_pad;
		_tmp29_ = gst_object_get_name ((GstObject*) _tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = _tmp30_;
		g_critical (_ ("Failed to link pad %s to %s"), _tmp27_, _tmp31_);
		_g_free0 (_tmp31_);
		_g_free0 (_tmp27_);
		g_signal_emit_by_name ((RygelDataSource*) self, "done");
		_g_object_unref0 (depay);
		_g_object_unref0 (sink_pad);
		_g_object_unref0 (sink);
		_gst_caps_unref0 (caps);
		return;
	}
	_tmp32_ = depay;
	if (_tmp32_ != NULL) {
		GstElement* _tmp33_;
		_tmp33_ = depay;
		gst_element_sync_state_with_parent (_tmp33_);
	}
	_g_object_unref0 (depay);
	_g_object_unref0 (sink_pad);
	_g_object_unref0 (sink);
	_gst_caps_unref0 (caps);
}


static inline void
_dynamic_set_streamable0 (GstElement* obj,
                          gboolean value)
{
	g_object_set (obj, "streamable", value, NULL);
}


static inline void
_dynamic_set_fragment_duration1 (GstElement* obj,
                                 gint value)
{
	g_object_set (obj, "fragment-duration", value, NULL);
}


static gboolean
___lambda5_ (RygelGstDataSource* self)
{
	gboolean result = FALSE;
	g_signal_emit_by_name ((RygelDataSource*) self, "done");
	result = FALSE;
	return result;
}


static gboolean
____lambda5__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda5_ ((RygelGstDataSource*) self);
	return result;
}


static gboolean
rygel_gst_data_source_bus_handler (RygelGstDataSource* self,
                                   GstBus* bus,
                                   GstMessage* message)
{
	gboolean result = FALSE;
	gboolean ret = FALSE;
	GstMessageType _tmp0_;
	gboolean _tmp45_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (bus != NULL, FALSE);
	g_return_val_if_fail (message != NULL, FALSE);
	ret = TRUE;
	_tmp0_ = message->type;
	if (_tmp0_ == GST_MESSAGE_EOS) {
		ret = FALSE;
	} else {
		GstMessageType _tmp1_;
		_tmp1_ = message->type;
		if (_tmp1_ == GST_MESSAGE_STATE_CHANGED) {
			GstObject* _tmp2_;
			GstPipeline* _tmp3_;
			GstState old_state = 0;
			GstState new_state = 0;
			GstState _tmp4_ = 0;
			GstState _tmp5_ = 0;
			gboolean _tmp6_ = FALSE;
			GstState _tmp7_;
			gchar* filename = NULL;
			GstState _tmp18_;
			GstState _tmp19_;
			gchar* _tmp20_;
			GstPipeline* _tmp21_;
			const gchar* _tmp22_;
			RygelHTTPSeekRequest* _tmp23_;
			_tmp2_ = message->src;
			_tmp3_ = self->priv->pipeline;
			if (_tmp2_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gst_object_get_type (), GstObject)) {
				result = TRUE;
				return result;
			}
			gst_message_parse_state_changed (message, &_tmp4_, &_tmp5_, NULL);
			old_state = _tmp4_;
			new_state = _tmp5_;
			_tmp7_ = old_state;
			if (_tmp7_ == GST_STATE_NULL) {
				GstState _tmp8_;
				_tmp8_ = new_state;
				_tmp6_ = _tmp8_ == GST_STATE_READY;
			} else {
				_tmp6_ = FALSE;
			}
			if (_tmp6_) {
				GstElement* element = NULL;
				GstPipeline* _tmp9_;
				GstElement* _tmp10_;
				GstElement* _tmp11_;
				_tmp9_ = self->priv->pipeline;
				_tmp10_ = gst_bin_get_by_name ((GstBin*) _tmp9_, "muxer");
				element = _tmp10_;
				_tmp11_ = element;
				if (_tmp11_ != NULL) {
					gchar* name = NULL;
					GstElement* _tmp12_;
					GstElementFactory* _tmp13_;
					gchar* _tmp14_;
					const gchar* _tmp15_;
					_tmp12_ = element;
					_tmp13_ = gst_element_get_factory (_tmp12_);
					_tmp14_ = gst_object_get_name ((GstObject*) _tmp13_);
					name = _tmp14_;
					_tmp15_ = name;
					if (g_strcmp0 (_tmp15_, "mp4mux") == 0) {
						GstElement* _tmp16_;
						GstElement* _tmp17_;
						_tmp16_ = element;
						_dynamic_set_streamable0 (_tmp16_, TRUE);
						_tmp17_ = element;
						_dynamic_set_fragment_duration1 (_tmp17_, 1000);
					}
					_g_free0 (name);
				}
				_g_object_unref0 (element);
			}
			_tmp18_ = old_state;
			_tmp19_ = new_state;
			_tmp20_ = g_strdup_printf ("rygel_media_engine_%d_%d", (gint) _tmp18_, (gint) _tmp19_);
			filename = _tmp20_;
			_tmp21_ = self->priv->pipeline;
			_tmp22_ = filename;
			gst_debug_bin_to_dot_file_with_ts ((GstBin*) _tmp21_, GST_DEBUG_GRAPH_SHOW_ALL, _tmp22_);
			_tmp23_ = self->priv->seek;
			if (_tmp23_ != NULL) {
				gboolean _tmp24_ = FALSE;
				GstState _tmp25_;
				_tmp25_ = old_state;
				if (_tmp25_ == GST_STATE_READY) {
					GstState _tmp26_;
					_tmp26_ = new_state;
					_tmp24_ = _tmp26_ == GST_STATE_PAUSED;
				} else {
					_tmp24_ = FALSE;
				}
				if (_tmp24_) {
					if (rygel_gst_data_source_perform_seek (self)) {
						GstPipeline* _tmp27_;
						_tmp27_ = self->priv->pipeline;
						gst_element_set_state ((GstElement*) _tmp27_, GST_STATE_PLAYING);
					}
				}
			}
			_g_free0 (filename);
		} else {
			GError* err = NULL;
			gchar* err_msg = NULL;
			GstMessageType _tmp28_;
			_tmp28_ = message->type;
			if (_tmp28_ == GST_MESSAGE_ERROR) {
				GstPipeline* _tmp29_;
				GError* _tmp30_ = NULL;
				gchar* _tmp31_ = NULL;
				GstPipeline* _tmp32_;
				gchar* _tmp33_;
				gchar* _tmp34_;
				gchar* _tmp35_;
				const gchar* _tmp36_;
				_tmp29_ = self->priv->pipeline;
				gst_debug_bin_to_dot_file_with_ts ((GstBin*) _tmp29_, GST_DEBUG_GRAPH_SHOW_ALL, "rygel_media_engine_error");
				gst_message_parse_error (message, &_tmp30_, &_tmp31_);
				_g_error_free0 (err);
				err = _tmp30_;
				_g_free0 (err_msg);
				err_msg = _tmp31_;
				_tmp32_ = self->priv->pipeline;
				_tmp33_ = gst_object_get_name ((GstObject*) _tmp32_);
				_tmp34_ = _tmp33_;
				_tmp35_ = _tmp34_;
				_tmp36_ = err_msg;
				g_critical (_ ("Error from pipeline %s: %s"), _tmp35_, _tmp36_);
				_g_free0 (_tmp35_);
				ret = FALSE;
			} else {
				GstMessageType _tmp37_;
				_tmp37_ = message->type;
				if (_tmp37_ == GST_MESSAGE_WARNING) {
					GError* _tmp38_ = NULL;
					gchar* _tmp39_ = NULL;
					GstPipeline* _tmp40_;
					gchar* _tmp41_;
					gchar* _tmp42_;
					gchar* _tmp43_;
					const gchar* _tmp44_;
					gst_message_parse_warning (message, &_tmp38_, &_tmp39_);
					_g_error_free0 (err);
					err = _tmp38_;
					_g_free0 (err_msg);
					err_msg = _tmp39_;
					_tmp40_ = self->priv->pipeline;
					_tmp41_ = gst_object_get_name ((GstObject*) _tmp40_);
					_tmp42_ = _tmp41_;
					_tmp43_ = _tmp42_;
					_tmp44_ = err_msg;
					g_warning (_ ("Warning from pipeline %s: %s"), _tmp43_, _tmp44_);
					_g_free0 (_tmp43_);
				}
			}
			_g_free0 (err_msg);
			_g_error_free0 (err);
		}
	}
	_tmp45_ = ret;
	if (!_tmp45_) {
		g_idle_add_full (G_PRIORITY_DEFAULT, ____lambda5__gsource_func, g_object_ref (self), g_object_unref);
		self->priv->bus_watch_id = (guint) 0;
	}
	result = ret;
	return result;
}


static gboolean
rygel_gst_data_source_perform_seek (RygelGstDataSource* self)
{
	gboolean result = FALSE;
	GstSeekType stop_type = 0;
	GstFormat format = 0;
	GstSeekFlags flags = 0;
	gint64 start = 0LL;
	gint64 stop = 0LL;
	RygelHTTPSeekRequest* _tmp0_;
	gint64 _tmp38_;
	GstPipeline* _tmp39_;
	GstFormat _tmp40_;
	GstSeekFlags _tmp41_;
	gint64 _tmp42_;
	GstSeekType _tmp43_;
	gint64 _tmp44_;
	g_return_val_if_fail (self != NULL, FALSE);
	stop_type = GST_SEEK_TYPE_NONE;
	flags = GST_SEEK_FLAG_FLUSH;
	_tmp0_ = self->priv->seek;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST)) {
		RygelHTTPTimeSeekRequest* time_seek = NULL;
		RygelHTTPSeekRequest* _tmp1_;
		RygelHTTPTimeSeekRequest* _tmp2_;
		GstSeekFlags _tmp3_;
		RygelHTTPTimeSeekRequest* _tmp4_;
		gint64 _tmp5_;
		gboolean _tmp6_ = FALSE;
		GstElement* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gboolean _tmp11_;
		RygelHTTPTimeSeekRequest* _tmp14_;
		gint64 _tmp15_;
		gint64 _tmp16_;
		gint64 _tmp17_;
		_tmp1_ = self->priv->seek;
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST) ? ((RygelHTTPTimeSeekRequest*) _tmp1_) : NULL);
		time_seek = _tmp2_;
		format = GST_FORMAT_TIME;
		_tmp3_ = flags;
		flags = _tmp3_ | GST_SEEK_FLAG_KEY_UNIT;
		_tmp4_ = time_seek;
		_tmp5_ = _tmp4_->start_time;
		start = _tmp5_ * GST_USECOND;
		_tmp7_ = self->src;
		_tmp8_ = gst_object_get_name ((GstObject*) _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strcmp0 (_tmp10_, "dvdreadsrc") == 0;
		_g_free0 (_tmp10_);
		if (_tmp11_) {
			gint64 _tmp12_;
			_tmp12_ = start;
			_tmp6_ = _tmp12_ == ((gint64) 0);
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			gint64 _tmp13_;
			_tmp13_ = start;
			start = _tmp13_ + (1 * GST_SECOND);
		}
		_tmp14_ = time_seek;
		_tmp15_ = _tmp14_->end_time;
		stop = _tmp15_ * GST_USECOND;
		_tmp16_ = start;
		_tmp17_ = stop;
		g_debug ("rygel-gst-data-source.vala:299: Performing time-range seek: %lldns to " \
"%lldns", _tmp16_, _tmp17_);
		_g_object_unref0 (time_seek);
	} else {
		RygelHTTPSeekRequest* _tmp18_;
		_tmp18_ = self->priv->seek;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST)) {
			RygelHTTPByteSeekRequest* byte_seek = NULL;
			RygelHTTPSeekRequest* _tmp19_;
			RygelHTTPByteSeekRequest* _tmp20_;
			RygelHTTPByteSeekRequest* _tmp21_;
			gint64 _tmp22_;
			gint64 _tmp23_;
			RygelHTTPByteSeekRequest* _tmp24_;
			gint64 _tmp25_;
			gint64 _tmp26_;
			GstSeekFlags _tmp27_;
			RygelHTTPByteSeekRequest* _tmp28_;
			gint64 _tmp29_;
			gint64 _tmp30_;
			RygelHTTPByteSeekRequest* _tmp31_;
			gint64 _tmp32_;
			gint64 _tmp33_;
			gint64 _tmp34_;
			gint64 _tmp35_;
			_tmp19_ = self->priv->seek;
			_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST) ? ((RygelHTTPByteSeekRequest*) _tmp19_) : NULL);
			byte_seek = _tmp20_;
			_tmp21_ = byte_seek;
			_tmp22_ = rygel_http_byte_seek_request_get_range_length (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = byte_seek;
			_tmp25_ = rygel_http_byte_seek_request_get_total_size (_tmp24_);
			_tmp26_ = _tmp25_;
			if (_tmp23_ >= _tmp26_) {
				result = TRUE;
				_g_object_unref0 (byte_seek);
				return result;
			}
			format = GST_FORMAT_BYTES;
			_tmp27_ = flags;
			flags = _tmp27_ | GST_SEEK_FLAG_ACCURATE;
			_tmp28_ = byte_seek;
			_tmp29_ = rygel_http_byte_seek_request_get_start_byte (_tmp28_);
			_tmp30_ = _tmp29_;
			start = _tmp30_;
			_tmp31_ = byte_seek;
			_tmp32_ = rygel_http_byte_seek_request_get_end_byte (_tmp31_);
			_tmp33_ = _tmp32_;
			stop = _tmp33_;
			_tmp34_ = start;
			_tmp35_ = stop;
			g_debug ("rygel-gst-data-source.vala:312: Performing byte-range seek: bytes %lld" \
" to %lld", _tmp34_, _tmp35_);
			_g_object_unref0 (byte_seek);
		} else {
			GError* _result_ = NULL;
			GError* _tmp36_;
			GError* _tmp37_;
			_tmp36_ = g_error_new_literal (RYGEL_DATA_SOURCE_ERROR, RYGEL_DATA_SOURCE_ERROR_SEEK_FAILED, _ ("Unsupported seek type"));
			_result_ = _tmp36_;
			_tmp37_ = _result_;
			g_signal_emit_by_name ((RygelDataSource*) self, "error", _tmp37_);
			result = FALSE;
			_g_error_free0 (_result_);
			return result;
		}
	}
	_tmp38_ = stop;
	if (_tmp38_ > ((gint64) 0)) {
		stop_type = GST_SEEK_TYPE_SET;
	}
	_tmp39_ = self->priv->pipeline;
	_tmp40_ = format;
	_tmp41_ = flags;
	_tmp42_ = start;
	_tmp43_ = stop_type;
	_tmp44_ = stop;
	if (!gst_element_seek ((GstElement*) _tmp39_, 1.0, _tmp40_, _tmp41_, GST_SEEK_TYPE_SET, _tmp42_, _tmp43_, _tmp44_ + 1)) {
		gint64 _tmp45_;
		gint64 _tmp46_;
		GError* _tmp47_;
		GError* _tmp48_;
		_tmp45_ = start;
		_tmp46_ = stop;
		g_warning (_ ("Failed to seek to offsets %lld:%lld"), _tmp45_, _tmp46_);
		_tmp47_ = g_error_new_literal (RYGEL_DATA_SOURCE_ERROR, RYGEL_DATA_SOURCE_ERROR_SEEK_FAILED, _ ("Failed to seek"));
		_tmp48_ = _tmp47_;
		g_signal_emit_by_name ((RygelDataSource*) self, "error", _tmp48_);
		_g_error_free0 (_tmp48_);
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


static void
rygel_gst_data_source_class_init (RygelGstDataSourceClass * klass)
{
	rygel_gst_data_source_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelGstDataSourcePrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_gst_data_source_finalize;
}


static void
rygel_gst_data_source_rygel_data_source_interface_init (RygelDataSourceIface * iface)
{
	rygel_gst_data_source_rygel_data_source_parent_iface = g_type_interface_peek_parent (iface);
	iface->preroll = (GeeList* (*) (RygelDataSource *, RygelHTTPSeekRequest*, RygelPlaySpeedRequest*, GError**)) rygel_gst_data_source_real_preroll;
	iface->start = (void (*) (RygelDataSource *, GError**)) rygel_gst_data_source_real_start;
	iface->freeze = (void (*) (RygelDataSource *)) rygel_gst_data_source_real_freeze;
	iface->thaw = (void (*) (RygelDataSource *)) rygel_gst_data_source_real_thaw;
	iface->stop = (void (*) (RygelDataSource *)) rygel_gst_data_source_real_stop;
}


static void
rygel_gst_data_source_instance_init (RygelGstDataSource * self)
{
	self->priv = RYGEL_GST_DATA_SOURCE_GET_PRIVATE (self);
	self->priv->seek = NULL;
}


static void
rygel_gst_data_source_finalize (GObject * obj)
{
	RygelGstDataSource * self;
	RygelGstSink* _tmp0_;
	GstPipeline* _tmp3_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_GST_DATA_SOURCE, RygelGstDataSource);
	_tmp0_ = self->priv->sink;
	if (_tmp0_ != NULL) {
		RygelGstSink* _tmp1_;
		GCancellable* _tmp2_;
		_tmp1_ = self->priv->sink;
		_tmp2_ = _tmp1_->cancellable;
		g_cancellable_cancel (_tmp2_);
	}
	_tmp3_ = self->priv->pipeline;
	if (_tmp3_ != NULL) {
		GstPipeline* _tmp4_;
		_tmp4_ = self->priv->pipeline;
		gst_element_set_state ((GstElement*) _tmp4_, GST_STATE_NULL);
	}
	_g_object_unref0 (self->src);
	_g_object_unref0 (self->res);
	_g_object_unref0 (self->priv->pipeline);
	_g_object_unref0 (self->priv->seek);
	_g_object_unref0 (self->priv->sink);
	G_OBJECT_CLASS (rygel_gst_data_source_parent_class)->finalize (obj);
}


GType
rygel_gst_data_source_get_type (void)
{
	static volatile gsize rygel_gst_data_source_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_gst_data_source_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelGstDataSourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_gst_data_source_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelGstDataSource), 0, (GInstanceInitFunc) rygel_gst_data_source_instance_init, NULL };
		static const GInterfaceInfo rygel_data_source_info = { (GInterfaceInitFunc) rygel_gst_data_source_rygel_data_source_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_gst_data_source_type_id;
		rygel_gst_data_source_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelGstDataSource", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_gst_data_source_type_id, RYGEL_TYPE_DATA_SOURCE, &rygel_data_source_info);
		g_once_init_leave (&rygel_gst_data_source_type_id__volatile, rygel_gst_data_source_type_id);
	}
	return rygel_gst_data_source_type_id__volatile;
}



